/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.recitation;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.tools.intellij.aiplugin.recitation.RecitationTrackingService;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lcom/google/tools/intellij/aiplugin/recitation/RecitationTrackingEditorFactoryListener;", "Lcom/intellij/openapi/editor/event/EditorFactoryListener;", "()V", "editorReleased", "", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "isDiffViewEditor", "", "isFileStillOpenInAnotherEditor", "aiplugin.ij-platform"})
@StabilityInferred(parameters=1)
public final class RecitationTrackingEditorFactoryListener
implements EditorFactoryListener {
    public static final int $stable;

    public void editorReleased(@NotNull EditorFactoryEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project2 = event.getEditor().getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        if (project3.isDisposed()) {
            return;
        }
        if (this.isDiffViewEditor(event) || this.isFileStillOpenInAnotherEditor(event)) {
            return;
        }
        RecitationTrackingService recitationTrackingService = RecitationTrackingService.Companion.getInstance(project3);
        Editor editor2 = event.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        recitationTrackingService.stopTracking(editor2);
    }

    private final boolean isFileStillOpenInAnotherEditor(EditorFactoryEvent event) {
        Editor[] editorArray = event.getFactory().getEditors(event.getEditor().getDocument());
        Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getEditors(...)");
        Editor[] editors = editorArray;
        return editors.length > 1;
    }

    private final boolean isDiffViewEditor(EditorFactoryEvent event) {
        return event.getEditor().getEditorKind() == EditorKind.DIFF;
    }
}

