/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.integration;

import com.google.cloud.tools.intellij.analytics.MetricWithMetadata;
import com.google.cloud.tools.intellij.analytics.MetricsLocalDirectoryUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a*\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a\u0014\u0010\b\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a8\u0006\t"}, d2={"filterUnusedMetricsAndMetadataFromActualList", "", "Lcom/google/cloud/tools/intellij/analytics/MetricWithMetadata;", "expected", "actual", "validateMetrics", "", "expectedMetrics", "validateMetricsAndReset", "aiplugin.ij-platform"})
@SourceDebugExtension(value={"SMAP\nMetricsValidationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetricsValidationUtil.kt\ncom/google/tools/intellij/aiplugin/integration/MetricsValidationUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,88:1\n774#2:89\n865#2:90\n1761#2,3:91\n866#2:94\n1563#2:95\n1634#2,2:96\n1761#2,3:101\n1636#2:108\n488#3,3:98\n491#3,4:104\n*S KotlinDebug\n*F\n+ 1 MetricsValidationUtil.kt\ncom/google/tools/intellij/aiplugin/integration/MetricsValidationUtilKt\n*L\n71#1:89\n71#1:90\n73#1:91,3\n71#1:94\n75#1:95\n75#1:96,2\n80#1:101,3\n75#1:108\n79#1:98,3\n79#1:104,4\n*E\n"})
public final class MetricsValidationUtilKt {
    public static final boolean validateMetricsAndReset(@NotNull List<MetricWithMetadata> expectedMetrics) {
        Intrinsics.checkNotNullParameter(expectedMetrics, (String)"expectedMetrics");
        boolean doMetricsMatch = MetricsValidationUtilKt.validateMetrics(expectedMetrics);
        MetricsLocalDirectoryUtilKt.getUiTestMetricsFileLocation().delete();
        return doMetricsMatch;
    }

    private static final boolean validateMetrics(List<MetricWithMetadata> expectedMetrics) {
        if (expectedMetrics.isEmpty()) {
            String string = "**********\nERROR: Metrics Validation Skipped\nexpectedMetrics list was empty\n**********\n";
            System.out.println((Object)string);
            return false;
        }
        List<MetricWithMetadata> actualMetrics = MetricsLocalDirectoryUtilKt.getActualTestMetricsFromLocalFile();
        List<MetricWithMetadata> filteredActualMetrics = MetricsValidationUtilKt.filterUnusedMetricsAndMetadataFromActualList(expectedMetrics, actualMetrics);
        System.out.println((Object)("DEBUG: Recorded Metrics = " + actualMetrics));
        boolean doMetricsMatch = Intrinsics.areEqual(expectedMetrics, filteredActualMetrics);
        if (doMetricsMatch) {
            String string = "**********\nSUCCESS: Metrics Match\nexpectedMetrics = " + expectedMetrics + "\nfilteredActualMetrics = " + filteredActualMetrics + "\n**********\n";
            System.out.println((Object)string);
        } else {
            String string = "**********\nERROR: Metrics Do Not Match\nexpectedMetrics = " + expectedMetrics + "\nfilteredActualMetrics = " + filteredActualMetrics + "\n**********\n";
            System.out.println((Object)string);
        }
        return doMetricsMatch;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<MetricWithMetadata> filterUnusedMetricsAndMetadataFromActualList(List<MetricWithMetadata> expected, List<MetricWithMetadata> actual) {
        void $this$mapTo$iv$iv;
        Object $this$any$iv;
        MetricWithMetadata actualMetric;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = actual;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block9: {
                actualMetric = (MetricWithMetadata)element$iv$iv;
                boolean bl2 = false;
                $this$any$iv = expected;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    Iterator iterator = $this$any$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv = iterator.next();
                        MetricWithMetadata it = (MetricWithMetadata)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getEventName(), (Object)actualMetric.getEventName())) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$filterKeys$iv;
            void filteredMetric;
            actualMetric = (MetricWithMetadata)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            $this$any$iv = filteredMetric.getEventMetadata();
            String string = filteredMetric.getEventName();
            boolean $i$f$filterKeys = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                boolean bl4;
                block10: {
                    String key = (String)entry$iv.getKey();
                    boolean bl5 = false;
                    Iterable $this$any$iv2 = expected;
                    boolean $i$f$any = false;
                    if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                        bl4 = false;
                    } else {
                        for (Object element$iv : $this$any$iv2) {
                            MetricWithMetadata expectedMetric = (MetricWithMetadata)element$iv;
                            boolean bl6 = false;
                            if (!(Intrinsics.areEqual((Object)expectedMetric.getEventName(), (Object)filteredMetric.getEventName()) && expectedMetric.getEventMetadata().containsKey(key))) continue;
                            bl4 = true;
                            break block10;
                        }
                        bl4 = false;
                    }
                }
                if (!bl4) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map map2 = result$iv;
            String string2 = string;
            collection.add(new MetricWithMetadata(string2, map2));
        }
        return (List)destination$iv$iv;
    }
}

