/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.completion;

import com.google.api.services.cloudcode_pa.v1internal.model.EditableRegion;
import com.google.tools.intellij.aiplugin.completion.SuggestionLine;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import java.awt.Point;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\u001c\u0010\t\u001a\u00020\b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\b\u001a\u001c\u0010\u000b\u001a\u00020\b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\b\u001a\u0012\u0010\f\u001a\u00020\r*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\b\u00a8\u0006\u000f"}, d2={"acceptSuggestionLine", "", "Lcom/intellij/openapi/editor/Editor;", "suggestionLine", "Lcom/google/tools/intellij/aiplugin/completion/SuggestionLine;", "calculateEditableRegion", "Lcom/google/api/services/cloudcode_pa/v1internal/model/EditableRegion;", "caretOffset", "", "getBlockSuggestionLineOffset", "lineDelta", "getInlineSuggestionLineOffset", "isLineVisible", "", "line", "aiplugin.ij-platform"})
public final class EditorUtilsKt {
    public static final boolean isLineVisible(@NotNull Editor $this$isLineVisible, int line) {
        Intrinsics.checkNotNullParameter((Object)$this$isLineVisible, (String)"<this>");
        Rectangle rectangle = $this$isLineVisible.getScrollingModel().getVisibleArea();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
        Rectangle visibleArea = rectangle;
        LogicalPosition logicalPosition = $this$isLineVisible.xyToLogicalPosition(visibleArea.getLocation());
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"xyToLogicalPosition(...)");
        LogicalPosition startPosition = logicalPosition;
        int endY = visibleArea.y + visibleArea.height - 1;
        LogicalPosition logicalPosition2 = $this$isLineVisible.xyToLogicalPosition(new Point(visibleArea.x, endY));
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition2, (String)"xyToLogicalPosition(...)");
        LogicalPosition endPosition = logicalPosition2;
        int n = startPosition.line;
        return line <= endPosition.line ? n <= line : false;
    }

    public static final int getInlineSuggestionLineOffset(@NotNull Editor $this$getInlineSuggestionLineOffset, @NotNull SuggestionLine suggestionLine, int lineDelta) {
        Intrinsics.checkNotNullParameter((Object)$this$getInlineSuggestionLineOffset, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)suggestionLine, (String)"suggestionLine");
        int atLine = suggestionLine.getAtLine() - lineDelta;
        if (atLine < 0 || atLine >= $this$getInlineSuggestionLineOffset.getDocument().getLineCount()) {
            return -1;
        }
        Integer n = suggestionLine.getInlineOffset();
        return $this$getInlineSuggestionLineOffset.getDocument().getLineStartOffset(atLine) + (n != null ? n : 0);
    }

    public static /* synthetic */ int getInlineSuggestionLineOffset$default(Editor editor2, SuggestionLine suggestionLine, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return EditorUtilsKt.getInlineSuggestionLineOffset(editor2, suggestionLine, n);
    }

    public static final int getBlockSuggestionLineOffset(@NotNull Editor $this$getBlockSuggestionLineOffset, @NotNull SuggestionLine suggestionLine, int lineDelta) {
        Intrinsics.checkNotNullParameter((Object)$this$getBlockSuggestionLineOffset, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)suggestionLine, (String)"suggestionLine");
        int atLine = suggestionLine.getAtLine() - 1 - lineDelta;
        if (atLine < 0) {
            return 0;
        }
        if (atLine >= $this$getBlockSuggestionLineOffset.getDocument().getLineCount()) {
            return -1;
        }
        return $this$getBlockSuggestionLineOffset.getDocument().getLineEndOffset(atLine);
    }

    public static /* synthetic */ int getBlockSuggestionLineOffset$default(Editor editor2, SuggestionLine suggestionLine, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return EditorUtilsKt.getBlockSuggestionLineOffset(editor2, suggestionLine, n);
    }

    @NotNull
    public static final EditableRegion calculateEditableRegion(@NotNull Editor $this$calculateEditableRegion, int caretOffset2) {
        EditableRegion editableRegion;
        Intrinsics.checkNotNullParameter((Object)$this$calculateEditableRegion, (String)"<this>");
        int caretLine = $this$calculateEditableRegion.getDocument().getLineNumber(caretOffset2);
        int startLine = 0;
        startLine = Math.max(caretLine - 25, 1);
        int endLine = 0;
        endLine = Math.min(caretLine + 25, $this$calculateEditableRegion.getDocument().getLineCount());
        if (startLine == 1) {
            endLine = Math.min(50, $this$calculateEditableRegion.getDocument().getLineCount());
        } else if (endLine == $this$calculateEditableRegion.getDocument().getLineCount()) {
            startLine = Math.max(endLine - 50, 1);
        }
        EditableRegion $this$calculateEditableRegion_u24lambda_u240 = editableRegion = new EditableRegion();
        boolean bl = false;
        $this$calculateEditableRegion_u24lambda_u240.setFirstLine(Integer.valueOf(startLine));
        $this$calculateEditableRegion_u24lambda_u240.setLastLine(Integer.valueOf(endLine));
        return editableRegion;
    }

    public static final void acceptSuggestionLine(@NotNull Editor $this$acceptSuggestionLine, @NotNull SuggestionLine suggestionLine) {
        int offset2;
        Intrinsics.checkNotNullParameter((Object)$this$acceptSuggestionLine, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)suggestionLine, (String)"suggestionLine");
        if ($this$acceptSuggestionLine.isDisposed()) {
            return;
        }
        if (suggestionLine.getAtLine() >= $this$acceptSuggestionLine.getDocument().getLineCount()) {
            return;
        }
        int n = offset2 = suggestionLine.isInline() || suggestionLine.isDeletion() ? EditorUtilsKt.getInlineSuggestionLineOffset$default($this$acceptSuggestionLine, suggestionLine, 0, 2, null) : EditorUtilsKt.getBlockSuggestionLineOffset$default($this$acceptSuggestionLine, suggestionLine, 0, 2, null);
        if (offset2 == -1) {
            return;
        }
        int endOffset = offset2 + suggestionLine.getToReplace().length();
        if (endOffset > $this$acceptSuggestionLine.getDocument().getTextLength()) {
            return;
        }
        String text2 = suggestionLine.isInline() || suggestionLine.isDeletion() ? suggestionLine.getText() : "\n" + suggestionLine.getText();
        $this$acceptSuggestionLine.getDocument().replaceString(offset2, offset2 + suggestionLine.getToReplace().length(), (CharSequence)text2);
        $this$acceptSuggestionLine.getCaretModel().moveToOffset(offset2 + text2.length());
    }
}

