/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.aiplugin.editor.predictionservices.session;

import com.android.studio.ml.suggestion.controls.EditorSuggestionControl;
import com.android.studio.ml.suggestion.session.SuggestionControlSession;
import com.google.tools.aiplugin.editor.predictionservices.controls.JumpToLocationControl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006J\b\u0010\u0010\u001a\u00020\rH\u0016J\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\rH\u0007J\b\u0010\u0014\u001a\u00020\u0012H\u0007J\b\u0010\u0015\u001a\u00020\rH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/session/NextEditPredictionControlSession;", "Lcom/android/studio/ml/suggestion/session/SuggestionControlSession;", "editor", "Lcom/intellij/openapi/editor/Editor;", "controls", "", "Lcom/android/studio/ml/suggestion/controls/EditorSuggestionControl;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Ljava/util/List;)V", "Ljava/util/Queue;", "listener", "Lcom/google/tools/aiplugin/editor/predictionservices/session/NextEditPredictionControlSession$AdvancementListener;", "start", "", "setUpHead", "getActiveControl", "dispose", "canHandleProceedAction", "", "handleProceedAction", "canHandleCancelAction", "handleCancelAction", "AdvancementListener", "aiplugin.editor.prediction-services"})
@SourceDebugExtension(value={"SMAP\nNextEditPredictionControlSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditPredictionControlSession.kt\ncom/google/tools/aiplugin/editor/predictionservices/session/NextEditPredictionControlSession\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1#2:109\n1#2:111\n2756#3:110\n*S KotlinDebug\n*F\n+ 1 NextEditPredictionControlSession.kt\ncom/google/tools/aiplugin/editor/predictionservices/session/NextEditPredictionControlSession\n*L\n64#1:111\n64#1:110\n*E\n"})
public final class NextEditPredictionControlSession
implements SuggestionControlSession {
    @NotNull
    private final Editor editor;
    @NotNull
    private final Queue<EditorSuggestionControl> controls;
    @NotNull
    private final AdvancementListener listener;

    public NextEditPredictionControlSession(@NotNull Editor editor2, @NotNull List<? extends EditorSuggestionControl> controls2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(controls2, (String)"controls");
        this.editor = editor2;
        this.controls = new ConcurrentLinkedQueue(controls2);
        this.listener = new AdvancementListener();
        if (!(!((Collection)controls2).isEmpty())) {
            boolean bl = false;
            String string = "Cannot create session with no controls.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public void start() {
        Project project2 = this.editor.getProject();
        if (project2 != null) {
            Project it = project2;
            boolean bl = false;
            v1 = new JumpToLocationControl(it, this.editor, this, (Function0<? extends EditorSuggestionControl>)((Function0)new Function0<EditorSuggestionControl>((Object)this){

                public final EditorSuggestionControl invoke() {
                    return ((NextEditPredictionControlSession)this.receiver).getActiveControl();
                }
            }));
        } else {
            v1 = null;
        }
        this.setUpHead();
    }

    private final void setUpHead() {
        EditorSuggestionControl nextControl = this.controls.peek();
        if (nextControl == null) {
            Disposer.dispose((Disposable)this);
            return;
        }
        nextControl.addListener(this.listener, this);
        nextControl.show();
    }

    @Nullable
    public final EditorSuggestionControl getActiveControl() {
        return this.controls.peek();
    }

    public void dispose() {
        Iterable iterable;
        Iterable $this$onEach$iv = this.controls;
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2418$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
            Disposable p0 = (Disposable)element$iv;
            boolean bl2 = false;
            Disposer.dispose((Disposable)p0);
        }
        ((Queue)iterable).clear();
    }

    public final boolean canHandleProceedAction() {
        return this.getActiveControl() != null;
    }

    @RequiresEdt
    public final void handleProceedAction() {
        EditorSuggestionControl editorSuggestionControl = this.getActiveControl();
        if (editorSuggestionControl == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        EditorSuggestionControl activeControl = editorSuggestionControl;
        if (activeControl.isVisible()) {
            activeControl.accept();
        } else {
            this.editor.getScrollingModel().scrollTo(activeControl.getLogicalPosition(), ScrollType.CENTER);
        }
    }

    @RequiresEdt
    public final boolean canHandleCancelAction() {
        EditorSuggestionControl editorSuggestionControl = this.getActiveControl();
        if (editorSuggestionControl == null) {
            return false;
        }
        EditorSuggestionControl control = editorSuggestionControl;
        return control.isVisible();
    }

    @RequiresEdt
    public final void handleCancelAction() {
        EditorSuggestionControl editorSuggestionControl = this.getActiveControl();
        if (editorSuggestionControl == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        EditorSuggestionControl activeControl = editorSuggestionControl;
        activeControl.reject();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/session/NextEditPredictionControlSession$AdvancementListener;", "Lcom/android/studio/ml/suggestion/controls/EditorSuggestionControl$Listener;", "<init>", "(Lcom/google/tools/aiplugin/editor/predictionservices/session/NextEditPredictionControlSession;)V", "advance", "", "onAccept", "onReject", "aiplugin.editor.prediction-services"})
    @SourceDebugExtension(value={"SMAP\nNextEditPredictionControlSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditPredictionControlSession.kt\ncom/google/tools/aiplugin/editor/predictionservices/session/NextEditPredictionControlSession$AdvancementListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
    private final class AdvancementListener
    implements EditorSuggestionControl.Listener {
        private final void advance() {
            EditorSuggestionControl editorSuggestionControl = (EditorSuggestionControl)NextEditPredictionControlSession.this.controls.poll();
            if (editorSuggestionControl != null) {
                Disposable p0 = editorSuggestionControl;
                boolean bl = false;
                Disposer.dispose((Disposable)p0);
            }
            NextEditPredictionControlSession.this.setUpHead();
        }

        @Override
        public void onAccept() {
            this.advance();
        }

        @Override
        public void onReject() {
            Disposer.dispose((Disposable)NextEditPredictionControlSession.this);
        }
    }
}

