/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.aiplugin.editor.predictionservices.controls;

import com.android.studio.ml.SmlBundle;
import com.android.studio.ml.suggestion.controls.EditorSuggestionControl;
import com.android.studio.ml.suggestion.controls.StickyLinesAwareVisibleAreaKt;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0011\u001a\u00020\u0012H\u0003J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0002J\u000e\u0010\u0016\u001a\u00020\u0017*\u0004\u0018\u00010\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/controls/JumpToLocationControl;", "Lcom/intellij/openapi/Disposable$Default;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "activeControlProvider", "Lkotlin/Function0;", "Lcom/android/studio/ml/suggestion/controls/EditorSuggestionControl;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/Disposable;Lkotlin/jvm/functions/Function0;)V", "balloon", "Lcom/intellij/openapi/ui/popup/Balloon;", "balloonData", "Lcom/google/tools/aiplugin/editor/predictionservices/controls/JumpToLocationControl$BalloonData;", "update", "", "createAndShowBalloon", "data", "hideBalloon", "asString", "", "Lcom/intellij/openapi/actionSystem/Shortcut;", "calculateBalloonPosition", "Lcom/intellij/ui/awt/RelativePoint;", "BalloonData", "aiplugin.editor.prediction-services"})
@SourceDebugExtension(value={"SMAP\nJumpToLocationControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JumpToLocationControl.kt\ncom/google/tools/aiplugin/editor/predictionservices/controls/JumpToLocationControl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,219:1\n1#2:220\n*E\n"})
public final class JumpToLocationControl
implements Disposable.Default {
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    @NotNull
    private final Function0<EditorSuggestionControl> activeControlProvider;
    @Nullable
    private Balloon balloon;
    @Nullable
    private BalloonData balloonData;

    public JumpToLocationControl(@NotNull Project project2, @NotNull Editor editor2, @NotNull Disposable parentDisposable, @NotNull Function0<? extends EditorSuggestionControl> activeControlProvider) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(activeControlProvider, (String)"activeControlProvider");
        this.project = project2;
        this.editor = editor2;
        this.activeControlProvider = activeControlProvider;
        Disposer.register((Disposable)parentDisposable, (Disposable)((Disposable)this));
        this.editor.getScrollingModel().addVisibleAreaListener(arg_0 -> JumpToLocationControl._init_$lambda$0(this, arg_0), (Disposable)this);
        FileEditorManagerListener fileEditorManagerListener2 = new FileEditorManagerListener(this){
            final /* synthetic */ JumpToLocationControl this$0;
            {
                this.this$0 = $receiver;
            }

            public void selectionChanged(FileEditorManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                JumpToLocationControl.access$update(this.this$0);
            }
        };
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, (Object)fileEditorManagerListener2);
        BulkAwareDocumentListener.Simple documentListener2 = new BulkAwareDocumentListener.Simple(this){
            final /* synthetic */ JumpToLocationControl this$0;
            {
                this.this$0 = $receiver;
            }

            public void afterDocumentChange(Document document2) {
                Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
                JumpToLocationControl.access$update(this.this$0);
            }
        };
        this.editor.getDocument().addDocumentListener((DocumentListener)documentListener2, (Disposable)this);
        ApplicationKt.getApplication().invokeLater(() -> JumpToLocationControl._init_$lambda$1(this));
    }

    @RequiresEdt
    private final void update() {
        String string;
        boolean isEditorActive = Intrinsics.areEqual((Object)FileEditorManager.getInstance((Project)this.project).getSelectedTextEditor(), (Object)this.editor);
        if (!isEditorActive) {
            this.hideBalloon();
            return;
        }
        EditorSuggestionControl activeControl = (EditorSuggestionControl)this.activeControlProvider.invoke();
        if (activeControl == null || activeControl.isVisible()) {
            this.hideBalloon();
            return;
        }
        Rectangle visibleArea = StickyLinesAwareVisibleAreaKt.visibleAreaWithoutStickyLines(this.editor);
        BalloonData.Position position = this.editor.logicalPositionToXY((LogicalPosition)activeControl.getLogicalPosition()).y < visibleArea.y ? BalloonData.Position.TOP : BalloonData.Position.BOTTOM;
        String string2 = this.asString(KeymapUtil.getPrimaryShortcut((String)"NextEditPredictionProceedAction"));
        String string3 = activeControl.getHintText();
        if (string3 == null) {
            string3 = SmlBundle.message("sml.studiobot.suggestion.jump.to.suggestion", new Object[0]);
        }
        if ((string = activeControl.getDescriptionText()) == null) {
            string = SmlBundle.message("sml.studiobot.suggestion.scroll.to.active.suggestion", new Object[0]);
        }
        BalloonData data2 = new BalloonData(this.editor, string2, string3, string, position);
        if (this.balloon != null && Intrinsics.areEqual((Object)this.balloonData, (Object)data2)) {
            return;
        }
        this.hideBalloon();
        this.balloonData = data2;
        this.createAndShowBalloon(data2);
    }

    /*
     * WARNING - void declaration
     */
    private final void createAndShowBalloon(BalloonData data2) {
        void it;
        Balloon balloon2;
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createBalloonBuilder(data2.toBalloonContent()).setAnimationCycle(0).setHideOnAction(true).setHideOnKeyOutside(false).setHideOnClickOutside(false).setHideOnFrameResize(false).setShowCallout(false);
        Intrinsics.checkNotNullExpressionValue((Object)balloonBuilder, (String)"setShowCallout(...)");
        BalloonBuilder balloonBuilder2 = balloonBuilder;
        Balloon balloon3 = balloon2 = balloonBuilder2.createBalloon();
        JumpToLocationControl jumpToLocationControl = this;
        boolean bl = false;
        Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)it));
        RelativePoint relativePoint = this.calculateBalloonPosition(data2);
        it.show(relativePoint, switch (WhenMappings.$EnumSwitchMapping$0[data2.getPosition().ordinal()]) {
            case 1 -> Balloon.Position.below;
            case 2 -> Balloon.Position.above;
            default -> throw new NoWhenBranchMatchedException();
        });
        jumpToLocationControl.balloon = balloon2;
    }

    private final void hideBalloon() {
        Balloon balloon2 = this.balloon;
        if (balloon2 != null) {
            Disposable p0 = (Disposable)balloon2;
            boolean bl = false;
            Disposer.dispose((Disposable)p0);
        }
        this.balloon = null;
        this.balloonData = null;
    }

    private final String asString(Shortcut $this$asString) {
        String string;
        if ($this$asString == null) {
            return "Click here";
        }
        switch ($this$asString.toString()) {
            case "[pressed TAB]": {
                string = "Tab";
                break;
            }
            case "[pressed ENTER]": {
                string = "Enter";
                break;
            }
            case "[shift pressed RIGHT]": {
                string = "Shift \u2192";
                break;
            }
            default: {
                String string2 = KeymapUtil.getShortcutText((Shortcut)$this$asString);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getShortcutText(...)");
            }
        }
        return string;
    }

    private final RelativePoint calculateBalloonPosition(BalloonData data2) {
        Rectangle visibleArea = StickyLinesAwareVisibleAreaKt.visibleAreaWithoutStickyLines(this.editor);
        Point point = switch (WhenMappings.$EnumSwitchMapping$0[data2.getPosition().ordinal()]) {
            case 1 -> new Point(visibleArea.x + visibleArea.width / 2, visibleArea.y);
            case 2 -> new Point(visibleArea.x + visibleArea.width / 2, visibleArea.y + visibleArea.height);
            default -> throw new NoWhenBranchMatchedException();
        };
        return new RelativePoint((Component)this.editor.getContentComponent(), point);
    }

    private static final void _init_$lambda$0(JumpToLocationControl this$0, VisibleAreaEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.update();
    }

    private static final void _init_$lambda$1(JumpToLocationControl this$0) {
        this$0.update();
    }

    public static final /* synthetic */ void access$update(JumpToLocationControl $this) {
        $this.update();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001:\u0001\"B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0014\u001a\u00020\u0015J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c6\u0003J;\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/controls/JumpToLocationControl$BalloonData;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "shortcut", "", "shortText", "longText", "position", "Lcom/google/tools/aiplugin/editor/predictionservices/controls/JumpToLocationControl$BalloonData$Position;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/google/tools/aiplugin/editor/predictionservices/controls/JumpToLocationControl$BalloonData$Position;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getShortcut", "()Ljava/lang/String;", "getShortText", "getLongText", "getPosition", "()Lcom/google/tools/aiplugin/editor/predictionservices/controls/JumpToLocationControl$BalloonData$Position;", "toBalloonContent", "Ljavax/swing/JComponent;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "Position", "aiplugin.editor.prediction-services"})
    private static final class BalloonData {
        @NotNull
        private final Editor editor;
        @NotNull
        private final String shortcut;
        @NotNull
        private final String shortText;
        @NotNull
        private final String longText;
        @NotNull
        private final Position position;

        public BalloonData(@NotNull Editor editor2, @NotNull String shortcut, @NotNull String shortText, @NotNull String longText, @NotNull Position position) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)shortcut, (String)"shortcut");
            Intrinsics.checkNotNullParameter((Object)shortText, (String)"shortText");
            Intrinsics.checkNotNullParameter((Object)longText, (String)"longText");
            Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
            this.editor = editor2;
            this.shortcut = shortcut;
            this.shortText = shortText;
            this.longText = longText;
            this.position = position;
        }

        @NotNull
        public final Editor getEditor() {
            return this.editor;
        }

        @NotNull
        public final String getShortcut() {
            return this.shortcut;
        }

        @NotNull
        public final String getShortText() {
            return this.shortText;
        }

        @NotNull
        public final String getLongText() {
            return this.longText;
        }

        @NotNull
        public final Position getPosition() {
            return this.position;
        }

        @NotNull
        public final JComponent toBalloonContent() {
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.setToolTipText(this.longText);
            Icon icon2 = switch (WhenMappings.$EnumSwitchMapping$0[this.position.ordinal()]) {
                case 1 -> AllIcons.Actions.PreviousOccurence;
                case 2 -> AllIcons.Actions.NextOccurence;
                default -> throw new NoWhenBranchMatchedException();
            };
            Intrinsics.checkNotNull((Object)icon2);
            Icon icon3 = icon2;
            panel2.add((Component)new JBLabel(this.shortcut + ": " + this.shortText, icon3, 0), "Center");
            panel2.setCursor(Cursor.getPredefinedCursor(12));
            panel2.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ BalloonData this$0;
                {
                    this.this$0 = $receiver;
                }

                public void mouseClicked(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    AnAction anAction = ActionManager.getInstance().getAction("NextEditPredictionProceedAction");
                    if (anAction == null) {
                        return;
                    }
                    AnAction action = anAction;
                    DataContext dataContext2 = SimpleDataContext.builder().add(CommonDataKeys.EDITOR, (Object)this.this$0.getEditor()).build();
                    Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"build(...)");
                    DataContext dataContext3 = dataContext2;
                    AnActionEvent anActionEvent = AnActionEvent.createEvent((DataContext)dataContext3, null, (String)"popup", (ActionUiKind)ActionUiKind.NONE, (InputEvent)e);
                    Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createEvent(...)");
                    AnActionEvent actionEvent = anActionEvent;
                    ActionUtil.performActionDumbAwareWithCallbacks((AnAction)action, (AnActionEvent)actionEvent);
                }
            });
            return panel2;
        }

        @NotNull
        public final Editor component1() {
            return this.editor;
        }

        @NotNull
        public final String component2() {
            return this.shortcut;
        }

        @NotNull
        public final String component3() {
            return this.shortText;
        }

        @NotNull
        public final String component4() {
            return this.longText;
        }

        @NotNull
        public final Position component5() {
            return this.position;
        }

        @NotNull
        public final BalloonData copy(@NotNull Editor editor2, @NotNull String shortcut, @NotNull String shortText, @NotNull String longText, @NotNull Position position) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)shortcut, (String)"shortcut");
            Intrinsics.checkNotNullParameter((Object)shortText, (String)"shortText");
            Intrinsics.checkNotNullParameter((Object)longText, (String)"longText");
            Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
            return new BalloonData(editor2, shortcut, shortText, longText, position);
        }

        public static /* synthetic */ BalloonData copy$default(BalloonData balloonData, Editor editor2, String string, String string2, String string3, Position position, int n, Object object) {
            if ((n & 1) != 0) {
                editor2 = balloonData.editor;
            }
            if ((n & 2) != 0) {
                string = balloonData.shortcut;
            }
            if ((n & 4) != 0) {
                string2 = balloonData.shortText;
            }
            if ((n & 8) != 0) {
                string3 = balloonData.longText;
            }
            if ((n & 0x10) != 0) {
                position = balloonData.position;
            }
            return balloonData.copy(editor2, string, string2, string3, position);
        }

        @NotNull
        public String toString() {
            return "BalloonData(editor=" + this.editor + ", shortcut=" + this.shortcut + ", shortText=" + this.shortText + ", longText=" + this.longText + ", position=" + this.position + ")";
        }

        public int hashCode() {
            int result2 = this.editor.hashCode();
            result2 = result2 * 31 + this.shortcut.hashCode();
            result2 = result2 * 31 + this.shortText.hashCode();
            result2 = result2 * 31 + this.longText.hashCode();
            result2 = result2 * 31 + this.position.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BalloonData)) {
                return false;
            }
            BalloonData balloonData = (BalloonData)other;
            if (!Intrinsics.areEqual((Object)this.editor, (Object)balloonData.editor)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.shortcut, (Object)balloonData.shortcut)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.shortText, (Object)balloonData.shortText)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.longText, (Object)balloonData.longText)) {
                return false;
            }
            return this.position == balloonData.position;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/controls/JumpToLocationControl$BalloonData$Position;", "", "<init>", "(Ljava/lang/String;I)V", "TOP", "BOTTOM", "aiplugin.editor.prediction-services"})
        public static final class Position
        extends Enum<Position> {
            public static final /* enum */ Position TOP = new Position();
            public static final /* enum */ Position BOTTOM = new Position();
            private static final /* synthetic */ Position[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Position[] values() {
                return (Position[])$VALUES.clone();
            }

            public static Position valueOf(String value) {
                return Enum.valueOf(Position.class, value);
            }

            @NotNull
            public static EnumEntries<Position> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = positionArray = new Position[]{Position.TOP, Position.BOTTOM};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Position.values().length];
                try {
                    nArray[Position.TOP.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Position.BOTTOM.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BalloonData.Position.values().length];
            try {
                nArray[BalloonData.Position.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BalloonData.Position.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

