/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.aiplugin.editor.predictionservices;

import com.android.tools.idea.studiobot.AiExcludeService;
import com.google.tools.aiplugin.editor.prediction.Config;
import com.google.tools.aiplugin.editor.prediction.DocumentChangeTracker;
import com.google.tools.aiplugin.editor.prediction.NextEditPredictor;
import com.google.tools.aiplugin.editor.prediction.Prediction;
import com.google.tools.aiplugin.editor.prediction.PredictionModelProvider;
import com.google.tools.aiplugin.editor.predictionservices.StudioPredictionModelProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.datetime.Clock;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\f\u0010\u000eJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001fJ\u000e\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006%"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/PredictionService;", "Lcom/intellij/openapi/Disposable$Default;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "clock", "Lkotlinx/datetime/Clock;", "edtDispatcher", "Lkotlin/coroutines/CoroutineContext;", "provider", "Lcom/google/tools/aiplugin/editor/prediction/PredictionModelProvider;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lkotlinx/datetime/Clock;Lkotlin/coroutines/CoroutineContext;Lcom/google/tools/aiplugin/editor/prediction/PredictionModelProvider;)V", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getCs", "()Lkotlinx/coroutines/CoroutineScope;", "tracker", "Lcom/google/tools/aiplugin/editor/prediction/DocumentChangeTracker;", "predictor", "Lcom/google/tools/aiplugin/editor/prediction/NextEditPredictor;", "getPredictor", "()Lcom/google/tools/aiplugin/editor/prediction/NextEditPredictor;", "predictions", "Lkotlinx/coroutines/flow/Flow;", "Lcom/google/tools/aiplugin/editor/prediction/Prediction;", "getPredictions", "()Lkotlinx/coroutines/flow/Flow;", "start", "", "predict", "updateConfig", "config", "Lcom/google/tools/aiplugin/editor/prediction/Config;", "Companion", "aiplugin.editor.prediction-services"})
public final class PredictionService
implements Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final DocumentChangeTracker tracker;
    @NotNull
    private final NextEditPredictor predictor;

    public PredictionService(@NotNull Project project2, @NotNull CoroutineScope cs, @NotNull Clock clock, @NotNull CoroutineContext edtDispatcher, @NotNull PredictionModelProvider provider) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)edtDispatcher, (String)"edtDispatcher");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.project = project2;
        this.cs = cs;
        this.tracker = new DocumentChangeTracker(clock, (Disposable)this);
        this.predictor = new NextEditPredictor(this.tracker, this.cs, edtDispatcher, provider, (Function1<? super Path, Boolean>)((Function1)arg_0 -> PredictionService.predictor$lambda$0(this, arg_0)));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final CoroutineScope getCs() {
        return this.cs;
    }

    public PredictionService(@NotNull Project project2, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this(project2, cs, (Clock)Clock.System.INSTANCE, CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), new StudioPredictionModelProvider(project2));
    }

    @NotNull
    public final NextEditPredictor getPredictor() {
        return this.predictor;
    }

    @NotNull
    public final Flow<Prediction> getPredictions() {
        return this.predictor.getPredictions();
    }

    public final void start() {
        this.predictor.start();
    }

    public final void predict() {
        this.predictor.predict();
    }

    public final void updateConfig(@NotNull Config config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        this.predictor.updateConfig(config2);
    }

    private static final boolean predictor$lambda$0(PredictionService this$0, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AiExcludeService.Companion.getInstance(this$0.project).isFileExcluded(it);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/google/tools/aiplugin/editor/predictionservices/PredictionService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/google/tools/aiplugin/editor/predictionservices/PredictionService;", "project", "Lcom/intellij/openapi/project/Project;", "aiplugin.editor.prediction-services"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PredictionService getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Object object = project2.getService(PredictionService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (PredictionService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

