/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.aiplugin.editor.prediction;

import com.google.tools.aiplugin.editor.prediction.FailType;
import com.google.tools.aiplugin.editor.prediction.Prediction;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\b\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0001\b\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u00a8\u0006\u001d"}, d2={"Lcom/google/tools/aiplugin/editor/prediction/PredictionEvent;", "", "title", "", "<init>", "(Ljava/lang/String;)V", "getTitle", "()Ljava/lang/String;", "time", "Ljava/time/LocalDateTime;", "getTime", "()Ljava/time/LocalDateTime;", "toString", "Success", "Outdated", "Fail", "LlmRequest", "Initiated", "Forced", "Flushed", "LlmResponse", "Lcom/google/tools/aiplugin/editor/prediction/PredictionEvent$Fail;", "Lcom/google/tools/aiplugin/editor/prediction/PredictionEvent$Flushed;", "Lcom/google/tools/aiplugin/editor/prediction/PredictionEvent$Forced;", "Lcom/google/tools/aiplugin/editor/prediction/PredictionEvent$Initiated;", "Lcom/google/tools/aiplugin/editor/prediction/PredictionEvent$LlmRequest;", "Lcom/google/tools/aiplugin/editor/prediction/PredictionEvent$LlmResponse;", "Lcom/google/tools/aiplugin/editor/prediction/PredictionEvent$Outdated;", "Lcom/google/tools/aiplugin/editor/prediction/PredictionEvent$Success;", "aiplugin.editor.prediction"})
public abstract sealed class PredictionEvent {
    @NotNull
    private final String title;
    @NotNull
    private final LocalDateTime time;

    private PredictionEvent(String title) {
        this.title = title;
        LocalDateTime localDateTime = LocalDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(...)");
        this.time = localDateTime;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final LocalDateTime getTime() {
        return this.time;
    }

    @NotNull
    public String toString() {
        return "[" + this.time.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + "] " + this.title;
    }

    public /* synthetic */ PredictionEvent(String title, DefaultConstructorMarker $constructor_marker) {
        this(title);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/google/tools/aiplugin/editor/prediction/PredictionEvent$Fail;", "Lcom/google/tools/aiplugin/editor/prediction/PredictionEvent;", "stamp", "", "type", "Lcom/google/tools/aiplugin/editor/prediction/FailType;", "message", "", "<init>", "(JLcom/google/tools/aiplugin/editor/prediction/FailType;Ljava/lang/String;)V", "getStamp", "()J", "getType", "()Lcom/google/tools/aiplugin/editor/prediction/FailType;", "getMessage", "()Ljava/lang/String;", "aiplugin.editor.prediction"})
    public static final class Fail
    extends PredictionEvent {
        private final long stamp;
        @NotNull
        private final FailType type;
        @NotNull
        private final String message;

        public Fail(long stamp, @NotNull FailType type2, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super("Failed prediction (" + type2 + ")", null);
            this.stamp = stamp;
            this.type = type2;
            this.message = message;
        }

        public final long getStamp() {
            return this.stamp;
        }

        @NotNull
        public final FailType getType() {
            return this.type;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/google/tools/aiplugin/editor/prediction/PredictionEvent$Flushed;", "Lcom/google/tools/aiplugin/editor/prediction/PredictionEvent;", "<init>", "()V", "aiplugin.editor.prediction"})
    public static final class Flushed
    extends PredictionEvent {
        public Flushed() {
            super("Sync event", null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/google/tools/aiplugin/editor/prediction/PredictionEvent$Forced;", "Lcom/google/tools/aiplugin/editor/prediction/PredictionEvent;", "<init>", "()V", "aiplugin.editor.prediction"})
    public static final class Forced
    extends PredictionEvent {
        public Forced() {
            super("Manual prediction initiated", null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/google/tools/aiplugin/editor/prediction/PredictionEvent$Initiated;", "Lcom/google/tools/aiplugin/editor/prediction/PredictionEvent;", "<init>", "()V", "aiplugin.editor.prediction"})
    public static final class Initiated
    extends PredictionEvent {
        public Initiated() {
            super("Idle prediction initiated", null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/google/tools/aiplugin/editor/prediction/PredictionEvent$LlmRequest;", "Lcom/google/tools/aiplugin/editor/prediction/PredictionEvent;", "stamp", "", "prompt", "", "<init>", "(JLjava/lang/String;)V", "getStamp", "()J", "getPrompt", "()Ljava/lang/String;", "aiplugin.editor.prediction"})
    public static final class LlmRequest
    extends PredictionEvent {
        private final long stamp;
        @NotNull
        private final String prompt;

        public LlmRequest(long stamp, @NotNull String prompt2) {
            Intrinsics.checkNotNullParameter((Object)prompt2, (String)"prompt");
            super("Sending request to the LLM", null);
            this.stamp = stamp;
            this.prompt = prompt2;
        }

        public final long getStamp() {
            return this.stamp;
        }

        @NotNull
        public final String getPrompt() {
            return this.prompt;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/google/tools/aiplugin/editor/prediction/PredictionEvent$LlmResponse;", "Lcom/google/tools/aiplugin/editor/prediction/PredictionEvent;", "stamp", "", "response", "", "<init>", "(JLjava/lang/String;)V", "getStamp", "()J", "getResponse", "()Ljava/lang/String;", "aiplugin.editor.prediction"})
    public static final class LlmResponse
    extends PredictionEvent {
        private final long stamp;
        @NotNull
        private final String response;

        public LlmResponse(long stamp, @NotNull String response2) {
            Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
            super("Response received from the LLM", null);
            this.stamp = stamp;
            this.response = response2;
        }

        public final long getStamp() {
            return this.stamp;
        }

        @NotNull
        public final String getResponse() {
            return this.response;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/google/tools/aiplugin/editor/prediction/PredictionEvent$Outdated;", "Lcom/google/tools/aiplugin/editor/prediction/PredictionEvent;", "prediction", "Lcom/google/tools/aiplugin/editor/prediction/Prediction;", "<init>", "(Lcom/google/tools/aiplugin/editor/prediction/Prediction;)V", "getPrediction", "()Lcom/google/tools/aiplugin/editor/prediction/Prediction;", "aiplugin.editor.prediction"})
    public static final class Outdated
    extends PredictionEvent {
        @NotNull
        private final Prediction prediction;

        public Outdated(@NotNull Prediction prediction) {
            Intrinsics.checkNotNullParameter((Object)prediction, (String)"prediction");
            super("Outdated prediction", null);
            this.prediction = prediction;
        }

        @NotNull
        public final Prediction getPrediction() {
            return this.prediction;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/google/tools/aiplugin/editor/prediction/PredictionEvent$Success;", "Lcom/google/tools/aiplugin/editor/prediction/PredictionEvent;", "prediction", "Lcom/google/tools/aiplugin/editor/prediction/Prediction;", "<init>", "(Lcom/google/tools/aiplugin/editor/prediction/Prediction;)V", "getPrediction", "()Lcom/google/tools/aiplugin/editor/prediction/Prediction;", "aiplugin.editor.prediction"})
    public static final class Success
    extends PredictionEvent {
        @NotNull
        private final Prediction prediction;

        public Success(@NotNull Prediction prediction) {
            Intrinsics.checkNotNullParameter((Object)prediction, (String)"prediction");
            super("Successful prediction", null);
            this.prediction = prediction;
        }

        @NotNull
        public final Prediction getPrediction() {
            return this.prediction;
        }
    }
}

