/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.project;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.cloudresourcemanager.CloudResourceManager;
import com.google.api.services.cloudresourcemanager.model.ListProjectsResponse;
import com.google.api.services.cloudresourcemanager.model.Project;
import com.google.cloud.tools.intellij.api.CloudResourceManagerClient;
import com.google.cloud.tools.intellij.login.CredentialedUser;
import com.google.cloud.tools.intellij.util.ThreadUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Nullable;

class ProjectLoader {
    private static final Logger logger = Logger.getInstance(ProjectLoader.class);
    private static final String PROJECT_DELETE_REQUESTED = "DELETE_REQUESTED";
    private static final int PAGE_SIZE = Integer.MAX_VALUE;
    private final CloudResourceManagerClient cloudResourceManagerClient = new CloudResourceManagerClient();

    ProjectLoader() {
    }

    ListenableFuture<List<Project>> loadUserProjectsInBackground(CredentialedUser user) {
        return this.loadUserProjectsInBackground(user, "", new AtomicBoolean(false));
    }

    ListenableFuture<List<Project>> loadUserProjectsInBackground(CredentialedUser user, String filter2, AtomicBoolean cancelled) {
        return ThreadUtil.getInstance().executeInBackground(() -> this.loadUserProjects(user, filter2, cancelled));
    }

    private List<Project> loadUserProjects(CredentialedUser user, String filter2, AtomicBoolean cancelled) {
        CloudResourceManager cloudResourceManagerClient = this.createCloudResourceManager(user);
        ArrayList<Project> result2 = new ArrayList<Project>();
        if (cancelled.get()) {
            return result2;
        }
        ListProjectsResponse response2 = this.getProjectsList(cloudResourceManagerClient, filter2, "");
        if (response2 != null && response2.getProjects() != null) {
            ArrayList allProjects = new ArrayList(response2.getProjects());
            while (!Strings.isNullOrEmpty((String)response2.getNextPageToken()) && !cancelled.get()) {
                response2 = this.getProjectsList(cloudResourceManagerClient, filter2, response2.getNextPageToken());
                allProjects.addAll(response2.getProjects());
            }
            allProjects.stream().filter(project2 -> !PROJECT_DELETE_REQUESTED.equals(project2.getLifecycleState())).filter(project2 -> !Strings.isNullOrEmpty((String)project2.getProjectId())).map(project2 -> project2.setName(Strings.nullToEmpty((String)project2.getName()))).forEach(result2::add);
            result2.sort(Comparator.comparing(project2 -> project2.getName().toLowerCase(Locale.getDefault())));
        }
        return result2;
    }

    private ListProjectsResponse getProjectsList(CloudResourceManager cloudResourceManagerClient, String filter2, String nextToken) {
        try {
            CloudResourceManager.Projects.List projectsList = cloudResourceManagerClient.projects().list().setFilter(String.format("lifecycleState:active name:\"*%1$s*\" OR id:\"*%1$s*\"", this.sanitizeFilter(filter2))).setPageSize(Integer.valueOf(Integer.MAX_VALUE));
            if (!Strings.isNullOrEmpty((String)nextToken)) {
                projectsList.setPageToken(nextToken);
            }
            return (ListProjectsResponse)projectsList.execute();
        }
        catch (Exception e) {
            logger.warn("Exception during projects list loading", (Throwable)e);
            return new ListProjectsResponse();
        }
    }

    @VisibleForTesting
    String sanitizeFilter(String filter2) {
        return filter2.replaceAll("[^-!:? a-zA-Z0-9]", "");
    }

    @Nullable
    CloudResourceManager createCloudResourceManager(CredentialedUser credentialedUser) {
        return credentialedUser != null ? this.cloudResourceManagerClient.getCloudResourceManagerClient((HttpRequestInitializer)credentialedUser.getCredential()) : null;
    }
}

