/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.project;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.awt.Component;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class FilteredTextTableCellRenderer
extends DefaultTableCellRenderer {
    private String filterText;

    void setFilterText(String filterText) {
        this.filterText = filterText;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        label.setText(this.highlightFilterText(this.filterText, label.getText()));
        return label;
    }

    @VisibleForTesting
    String highlightFilterText(String filterText, String text2) {
        if (!Strings.isNullOrEmpty((String)filterText) && !Strings.isNullOrEmpty((String)text2)) {
            String quotedFilterText = "(?i)(" + Pattern.quote(filterText) + ")";
            return "<html>" + text2.replaceAll(quotedFilterText, "<b>$1</b>");
        }
        return text2;
    }
}

