/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.login;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.oauth2.Oauth2;
import com.google.api.services.oauth2.model.Userinfo;
import com.google.cloud.tools.intellij.login.ByoidProviderKt;
import com.google.cloud.tools.intellij.login.IUserPropertyCallback;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;

public final class GoogleLoginUtils {
    public static final Logger LOG = Logger.getInstance(GoogleLoginUtils.class);
    public static final int DEFAULT_PICTURE_SIZE = 96;
    private static final Pattern FIFE_AVATAR_URL = Pattern.compile("lh.*(googleusercontent|google)\\.com");

    public static void provideUserPicture(@NotNull Userinfo userInfo, @NotNull Consumer<Image> pictureCallback) {
        URL newUrl = GoogleLoginUtils.appendSizeParameterIfNecessary(userInfo.getPicture());
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                if (newUrl == null) {
                    pictureCallback.accept(null);
                } else {
                    pictureCallback.accept(ImageIO.read(newUrl));
                }
            }
            catch (Exception exception) {
                LOG.warn("Something went wrong loading the user image", (Throwable)exception);
                pictureCallback.accept(null);
            }
        });
    }

    public static URL appendSizeParameterIfNecessary(@NotNull String url) {
        try {
            boolean isFifeAvatarUrl;
            URIBuilder uriBuilder = new URIBuilder(url);
            boolean bl = isFifeAvatarUrl = FIFE_AVATAR_URL.matcher(url).find() && (url.contains("/a/") || url.contains("/a-"));
            if (!isFifeAvatarUrl) {
                uriBuilder.addParameter("sz", String.valueOf(96));
            }
            return uriBuilder.build().toURL();
        }
        catch (MalformedURLException | URISyntaxException exception) {
            LOG.warn("Unable to append size parameter to url: " + url, (Throwable)exception);
            return null;
        }
    }

    public static void getUserInfo(@NotNull Credential credential, IUserPropertyCallback<Userinfo> callback2) {
        if (ByoidProviderKt.isByoidEnabled()) {
            LOG.warn("Retrieving user info for BYOID 3p is not supported");
        } else {
            GoogleLoginUtils.getUserInfo1P(credential, callback2);
        }
    }

    private static void getUserInfo1P(@NotNull Credential credential, IUserPropertyCallback<Userinfo> callback2) {
        Oauth2 userInfoService = new Oauth2.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new GsonFactory(), (HttpRequestInitializer)credential).setApplicationName("intellij-plugin-core").build();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Userinfo userInfo = null;
            try {
                userInfo = (Userinfo)userInfoService.userinfo().get().execute();
            }
            catch (Exception ex) {
                LOG.warn("Error retrieving user information.", (Throwable)ex);
            }
            if (userInfo != null && userInfo.getId() != null) {
                callback2.setProperty(userInfo);
            } else {
                callback2.setProperty(null);
            }
        });
    }
}

