/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.hats;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.util.PropertiesComponent;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0006J\b\u0010\u0013\u001a\u00020\u0006H\u0007R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000b\u0010\u0003\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/google/cloud/tools/intellij/hats/HatsSessionIndex;", "", "<init>", "()V", "dateToSessionIndexCache", "", "", "", "propertiesComponent", "Lcom/intellij/ide/util/PropertiesComponent;", "kotlin.jvm.PlatformType", "getPropertiesComponent$annotations", "getPropertiesComponent", "()Lcom/intellij/ide/util/PropertiesComponent;", "setPropertiesComponent", "(Lcom/intellij/ide/util/PropertiesComponent;)V", "restorePersistedIndex", "", "generateHatsSessionIndex", "currentDateToString", "Companion", "aiplugin.cloudcode-core"})
@SourceDebugExtension(value={"SMAP\nHatsSessionIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HatsSessionIndex.kt\ncom/google/cloud/tools/intellij/hats/HatsSessionIndex\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public final class HatsSessionIndex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Integer> dateToSessionIndexCache = new LinkedHashMap();
    private PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
    @NotNull
    private static final String SESSION_INDEX_FORMAT = "%s_%s";
    @NotNull
    private static final String SESSION_DATE_PATTERN = "yyyyMMdd";
    private static final DateTimeFormatter SESSION_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd");
    @NotNull
    private static final Regex IDE_SESSION_INDEX_REGEX = new Regex("(\\d{8})_(\\d+)");
    @NotNull
    public static final String SESSION_INDEX_PROPERTY_NAME = "hats_session_index";

    public final PropertiesComponent getPropertiesComponent() {
        return this.propertiesComponent;
    }

    public final void setPropertiesComponent(PropertiesComponent propertiesComponent) {
        this.propertiesComponent = propertiesComponent;
    }

    @VisibleForTesting
    public static /* synthetic */ void getPropertiesComponent$annotations() {
    }

    public final void restorePersistedIndex() {
        block3: {
            String string = this.propertiesComponent.getValue(SESSION_INDEX_PROPERTY_NAME);
            if (string == null) break block3;
            String it = string;
            boolean bl = false;
            MatchResult matchResult = Regex.find$default((Regex)IDE_SESSION_INDEX_REGEX, (CharSequence)it, (int)0, (int)2, null);
            if (matchResult != null) {
                Object object;
                MatchResult match = matchResult;
                boolean bl2 = false;
                String dateString = (String)match.getGroupValues().get(1);
                String counterString = (String)match.getGroupValues().get(2);
                Object object2 = this;
                try {
                    HatsSessionIndex $this$restorePersistedIndex_u24lambda_u242_u24lambda_u241_u24lambda_u240 = object2;
                    boolean bl3 = false;
                    object = Result.constructor-impl((Object)Integer.parseInt(counterString));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object2 = object;
                object = 0;
                int counter = ((Number)(Result.isFailure-impl((Object)object2) ? object : object2)).intValue();
                this.dateToSessionIndexCache.put(dateString, counter);
            }
        }
    }

    @NotNull
    public final synchronized String generateHatsSessionIndex() {
        String todayString = this.currentDateToString();
        this.dateToSessionIndexCache.putIfAbsent(todayString, 0);
        Integer currentIndex = this.dateToSessionIndexCache.get(todayString);
        if (currentIndex == null) {
            currentIndex = 0;
        }
        this.dateToSessionIndexCache.put(todayString, currentIndex + 1);
        String string = SESSION_INDEX_FORMAT;
        Object[] objectArray = new Object[]{todayString, currentIndex};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String sessionIndex = string2;
        string = SESSION_INDEX_FORMAT;
        objectArray = new Object[]{todayString, currentIndex + 1};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        this.propertiesComponent.setValue(SESSION_INDEX_PROPERTY_NAME, string3);
        return sessionIndex;
    }

    @VisibleForTesting
    @NotNull
    public final String currentDateToString() {
        String string = SESSION_DATE_FORMAT.format(LocalDateTime.now());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\u0003\u00a8\u0006\u000e"}, d2={"Lcom/google/cloud/tools/intellij/hats/HatsSessionIndex$Companion;", "", "<init>", "()V", "SESSION_INDEX_FORMAT", "", "SESSION_DATE_PATTERN", "SESSION_DATE_FORMAT", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "IDE_SESSION_INDEX_REGEX", "Lkotlin/text/Regex;", "SESSION_INDEX_PROPERTY_NAME", "getSESSION_INDEX_PROPERTY_NAME$annotations", "aiplugin.cloudcode-core"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getSESSION_INDEX_PROPERTY_NAME$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

