/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.feedback;

import com.google.cloud.tools.intellij.feedback.FeedbackReportType;
import com.google.common.base.Strings;
import com.google.protobuf.ByteString;
import com.google.protos.userfeedback.proto2api.Common;
import com.google.protos.userfeedback.proto2api.MobileCommon;
import com.google.protos.userfeedback.proto2api.Web;
import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ExceptionUtil;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b&\u0018\u0000 E2\u00020\u0001:\u0001EB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0005H&J\b\u0010\u0007\u001a\u00020\u0005H&J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH&J\b\u0010\u000b\u001a\u00020\u0005H&J\u0016\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\rH\u0014J.\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\t2\u0006\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u0015J0\u0010\u0016\u001a\u00020\u00172\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\t2\u0006\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0018\u0010\u0018\u001a\u00020\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u001bJ\u001a\u0010\u001c\u001a\u00020\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0007JZ\u0010\u001d\u001a\u00020\u00172\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\t2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010 \u001a\u00020!2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0014\u0010\"\u001a\u0004\u0018\u00010\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0010\u0010#\u001a\n %*\u0004\u0018\u00010$0$H\u0002J\u0010\u0010&\u001a\n %*\u0004\u0018\u00010'0'H\u0002J(\u0010(\u001a\u00020)2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\t2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0010\u0010*\u001a\n %*\u0004\u0018\u00010+0+H\u0002J?\u0010,\u001a\u00020-2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0002\u0010.J9\u0010/\u001a\u0010\u0012\f\u0012\n %*\u0004\u0018\u000100000\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0002\u00101J\u0010\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u000204H\u0002J$\u00105\u001a\u0010\u0012\f\u0012\n %*\u0004\u0018\u000106060\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\tH\u0002J\u0016\u00107\u001a\u0002082\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\tH\u0002J\b\u00109\u001a\u00020\u0005H\u0007J\b\u0010:\u001a\u00020;H\u0007J\b\u0010<\u001a\u00020=H\u0007J\r\u0010>\u001a\u00070?\u00a2\u0006\u0002\b@H\u0007J\u0012\u0010A\u001a\f0\u0005\u00a2\u0006\u0002\bB\u00a2\u0006\u0002\b@H\u0007J\b\u0010C\u001a\u00020DH\u0007\u00a8\u0006F"}, d2={"Lcom/google/cloud/tools/intellij/feedback/FeedbackSerializerServiceBase;", "", "<init>", "()V", "getInstallerPackageName", "", "getPackageName", "getPluginVersion", "getExperimentIds", "", "", "getExperimentFlags", "getAdditionalProductSpecificData", "", "serializeUserInitiatedReport", "", "attachments", "Lcom/intellij/openapi/diagnostic/Attachment;", "description", "userEmail", "userConsentsToBeContacted", "", "getUserInitiatedReport", "Lcom/google/protos/userfeedback/proto2api/MobileCommon$MobileBugReport;", "serializeCrashReport", "errorDescription", "throwable", "", "getCrashReport", "getMobileBugReport", "reportType", "Lcom/google/cloud/tools/intellij/feedback/FeedbackReportType;", "getCrashData", "Lcom/google/protos/userfeedback/proto2api/MobileCommon$CrashData;", "assemblePIISafeStackTrace", "getPackageData", "Lcom/google/protos/userfeedback/proto2api/MobileCommon$PackageData;", "kotlin.jvm.PlatformType", "getBuildData", "Lcom/google/protos/userfeedback/proto2api/MobileCommon$BuildData;", "getMobileData", "Lcom/google/protos/userfeedback/proto2api/MobileCommon$MobileData;", "getSystemData", "Lcom/google/protos/userfeedback/proto2api/MobileCommon$SystemData;", "getCommonData", "Lcom/google/protos/userfeedback/proto2api/Common$CommonData;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;Ljava/lang/String;Ljava/lang/Boolean;)Lcom/google/protos/userfeedback/proto2api/Common$CommonData;", "getProductSpecificData", "Lcom/google/protos/userfeedback/proto2api/Web$ProductSpecificData;", "(Ljava/lang/String;Ljava/lang/Throwable;Ljava/lang/Boolean;)Ljava/util/List;", "createExceptionMarker", "stackTraceElement", "Ljava/lang/StackTraceElement;", "getProductSpecificBinaryData", "Lcom/google/protos/userfeedback/proto2api/Common$ProductSpecificBinaryData;", "getUserInitiatedFeedbackData", "Lcom/google/protos/userfeedback/proto2api/MobileCommon$UserInitiatedFeedbackData;", "getLastAction", "getApplication", "Lcom/intellij/openapi/application/Application;", "getApplicationInfoEx", "Lcom/intellij/openapi/application/ex/ApplicationInfoEx;", "getApplicationNamesInfo", "Lcom/intellij/openapi/application/ApplicationNamesInfo;", "Lorg/jetbrains/annotations/NotNull;", "getAppVersion", "Lcom/intellij/openapi/util/NlsSafe;", "getTimestamp", "", "Companion", "aiplugin.cloudcode-core"})
@SourceDebugExtension(value={"SMAP\nFeedbackSerializerServiceBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeedbackSerializerServiceBase.kt\ncom/google/cloud/tools/intellij/feedback/FeedbackSerializerServiceBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,395:1\n1563#2:396\n1634#2,3:397\n1563#2:401\n1634#2,3:402\n1563#2:405\n1634#2,3:406\n1#3:400\n*S KotlinDebug\n*F\n+ 1 FeedbackSerializerServiceBase.kt\ncom/google/cloud/tools/intellij/feedback/FeedbackSerializerServiceBase\n*L\n313#1:396\n313#1:397,3\n348#1:401\n348#1:402,3\n365#1:405\n365#1:406,3\n*E\n"})
public abstract class FeedbackSerializerServiceBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String APP_EAP_KEY = "app.eap";
    @NotNull
    private static final String APP_INTERNAL_KEY = "app.internal";
    @NotNull
    private static final String APP_NAME_KEY = "app.name";
    @NotNull
    private static final String APP_NAME_VERSION_KEY = "app.name.version";
    @NotNull
    private static final String APP_VERSION_MAJOR_KEY = "app.version.major";
    @NotNull
    private static final String APP_VERSION_MINOR_KEY = "app.version.minor";
    @NotNull
    private static final String ERROR_DESCRIPTION_KEY = "error.description";
    @NotNull
    private static final String ERROR_MESSAGE_KEY = "error.message";
    @NotNull
    private static final String ERROR_STACKTRACE_KEY = "error.stacktrace";
    @NotNull
    private static final String FEEDBACK_USER_CTL_CONSENT_KEY = "feedbackUserCtlConsent";
    @NotNull
    private static final String JAVA_VERSION_KEY = "java.version";
    @NotNull
    private static final String JAVA_VM_VENDOR_KEY = "java.vm.vendor";
    @NotNull
    private static final String LAST_ACTION_KEY = "last.action";
    @NotNull
    private static final String NONE_STRING = "__NONE__";
    @NotNull
    private static final String OS_NAME_KEY = "os.name";
    @NotNull
    private static final String OS_VERSION = "os.version";
    @NotNull
    private static final String OS_ARCHITECTURE = "os.arch";
    @NotNull
    private static final String PLUGIN_VERSION = "plugin.version";
    @NotNull
    private static final String FLAGS = "flags";
    @NotNull
    private static final String UNKNOWN_VALUE = "unknown";

    @NotNull
    public abstract String getInstallerPackageName();

    @NotNull
    public abstract String getPackageName();

    @NotNull
    public abstract String getPluginVersion();

    @NotNull
    public abstract List<Integer> getExperimentIds();

    @NotNull
    public abstract String getExperimentFlags();

    @NotNull
    protected Map<String, String> getAdditionalProductSpecificData() {
        return MapsKt.emptyMap();
    }

    @NotNull
    public final byte[] serializeUserInitiatedReport(@NotNull List<Attachment> attachments, @NotNull String description, @Nullable String userEmail, boolean userConsentsToBeContacted) {
        Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        byte[] byArray = this.getUserInitiatedReport(attachments, description, userEmail, userConsentsToBeContacted).toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    @VisibleForTesting
    @NotNull
    public final MobileCommon.MobileBugReport getUserInitiatedReport(@NotNull List<Attachment> attachments, @NotNull String description, @Nullable String userEmail, boolean userConsentsToBeContacted) {
        Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return FeedbackSerializerServiceBase.getMobileBugReport$default(this, attachments, description, null, FeedbackReportType.UserInitiated, null, userEmail, userConsentsToBeContacted, 20, null);
    }

    @NotNull
    public final byte[] serializeCrashReport(@Nullable String errorDescription, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        byte[] byArray = this.getCrashReport(errorDescription, throwable).toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    @VisibleForTesting
    @NotNull
    public final MobileCommon.MobileBugReport getCrashReport(@Nullable String errorDescription, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        return FeedbackSerializerServiceBase.getMobileBugReport$default(this, null, null, errorDescription, FeedbackReportType.Crash, throwable, null, false, 99, null);
    }

    private final MobileCommon.MobileBugReport getMobileBugReport(List<Attachment> attachments, String description, String errorDescription, FeedbackReportType reportType, Throwable throwable, String userEmail, boolean userConsentsToBeContacted) {
        MobileCommon.MobileData mobileData = this.getMobileData(attachments, reportType, throwable);
        Common.CommonData commonData = this.getCommonData(description, errorDescription, throwable, userEmail, userConsentsToBeContacted);
        MobileCommon.MobileBugReport mobileBugReport = MobileCommon.MobileBugReport.newBuilder().setCommonData(commonData).setMobileData(mobileData).build();
        Intrinsics.checkNotNullExpressionValue((Object)mobileBugReport, (String)"build(...)");
        return mobileBugReport;
    }

    static /* synthetic */ MobileCommon.MobileBugReport getMobileBugReport$default(FeedbackSerializerServiceBase feedbackSerializerServiceBase, List list, String string, String string2, FeedbackReportType feedbackReportType, Throwable throwable, String string3, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getMobileBugReport");
        }
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            throwable = null;
        }
        if ((n & 0x20) != 0) {
            string3 = null;
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        return feedbackSerializerServiceBase.getMobileBugReport(list, string, string2, feedbackReportType, throwable, string3, bl);
    }

    private final MobileCommon.CrashData getCrashData(Throwable throwable) {
        Throwable throwable2 = throwable;
        StackTraceElement[] stackTraceElements = throwable2 != null ? throwable2.getStackTrace() : null;
        StackTraceElement stackTraceElement = null;
        if (stackTraceElements != null && !(stackTraceElements.length == 0)) {
            stackTraceElement = stackTraceElements[0];
        }
        MobileCommon.CrashData.Builder builder = MobileCommon.CrashData.newBuilder();
        Object object = throwable;
        if (object == null || (object = object.getClass()) == null || (object = ((Class)object).toString()) == null) {
            object = UNKNOWN_VALUE;
        }
        StackTraceElement stackTraceElement2 = stackTraceElement;
        StackTraceElement stackTraceElement3 = stackTraceElement;
        StackTraceElement stackTraceElement4 = stackTraceElement;
        StackTraceElement stackTraceElement5 = stackTraceElement;
        StackTraceElement stackTraceElement6 = stackTraceElement;
        MobileCommon.CrashData.Builder builder2 = builder.setExceptionClassName((String)object).setExceptionMessage(stackTraceElement2 != null ? this.createExceptionMarker(stackTraceElement2) : UNKNOWN_VALUE).setThrowFileName(stackTraceElement3 != null ? stackTraceElement3.getFileName() : UNKNOWN_VALUE).setThrowLineNumber(stackTraceElement4 != null ? stackTraceElement4.getLineNumber() : 0).setThrowClassName(stackTraceElement5 != null ? stackTraceElement5.getClassName() : UNKNOWN_VALUE).setThrowMethodName(stackTraceElement6 != null ? stackTraceElement6.getMethodName() : UNKNOWN_VALUE);
        String string = this.assemblePIISafeStackTrace(throwable);
        if (string == null) {
            string = UNKNOWN_VALUE;
        }
        MobileCommon.CrashData crashData = builder2.setStackTrace(string).build();
        Intrinsics.checkNotNullExpressionValue((Object)crashData, (String)"build(...)");
        return crashData;
    }

    private final String assemblePIISafeStackTrace(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        Object[] stackTraceElements = throwable.getStackTrace();
        String separator = "\n\tat ";
        String string = throwable.getClass().getCanonicalName();
        Intrinsics.checkNotNull((Object)stackTraceElements);
        return string + separator + ArraysKt.joinToString$default((Object[])stackTraceElements, (CharSequence)separator, null, null, (int)0, null, FeedbackSerializerServiceBase::assemblePIISafeStackTrace$lambda$0, (int)30, null);
    }

    private final MobileCommon.PackageData getPackageData() {
        return MobileCommon.PackageData.newBuilder().setPackageName(this.getPackageName()).setInstallerPackageName(this.getInstallerPackageName()).setProcessName(this.getInstallerPackageName()).build();
    }

    private final MobileCommon.BuildData getBuildData() {
        return MobileCommon.BuildData.newBuilder().setDevice(UNKNOWN_VALUE).setBuildId(this.getAppVersion()).setRelease(this.getAppVersion()).setBuildType(UNKNOWN_VALUE).setModel(UNKNOWN_VALUE).setProduct(this.getInstallerPackageName()).build();
    }

    private final MobileCommon.MobileData getMobileData(List<Attachment> attachments, FeedbackReportType reportType, Throwable throwable) {
        MobileCommon.BuildData buildData = this.getBuildData();
        MobileCommon.SystemData systemData = this.getSystemData();
        MobileCommon.PackageData packageData = this.getPackageData();
        MobileCommon.MobileData.Builder mobileDataBuilder = MobileCommon.MobileData.newBuilder().setSystemData(systemData).setPackageData(packageData).setBuildData(buildData).setReportType(reportType.getCode());
        switch (WhenMappings.$EnumSwitchMapping$0[reportType.ordinal()]) {
            case 1: {
                MobileCommon.CrashData crashData = this.getCrashData(throwable);
                mobileDataBuilder.setCrashData(crashData);
                break;
            }
            case 2: {
                MobileCommon.UserInitiatedFeedbackData userInitiatedFeedbackData = this.getUserInitiatedFeedbackData(attachments);
                mobileDataBuilder.setUserInitiatedFeedbackData(userInitiatedFeedbackData);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        MobileCommon.MobileData mobileData = mobileDataBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)mobileData, (String)"build(...)");
        return mobileData;
    }

    private final MobileCommon.SystemData getSystemData() {
        return MobileCommon.SystemData.newBuilder().setTimestamp(this.getTimestamp()).build();
    }

    /*
     * WARNING - void declaration
     */
    private final Common.CommonData getCommonData(String description, String errorDescription, Throwable throwable, String userEmail, Boolean userConsentsToBeContacted) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List<Web.ProductSpecificData> productSpecificData = this.getProductSpecificData(errorDescription, throwable, userConsentsToBeContacted);
        Iterable iterable = this.getExperimentIds();
        Common.CommonData.Builder builder = Common.CommonData.newBuilder().setProductVersion(this.getAppVersion()).addAllProductSpecificData((Iterable)productSpecificData);
        boolean $i$f$map = false;
        void var10_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(String.valueOf((int)it));
        }
        Common.CommonData.Builder commonDataBuilder = builder.addAllExperimentId((Iterable)((List)destination$iv$iv));
        String string = description;
        if (string != null) {
            String it = string;
            boolean bl = false;
            commonDataBuilder.setDescription(it);
        }
        String string2 = userEmail;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            commonDataBuilder.setUserEmail(it);
        }
        Common.CommonData commonData = commonDataBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)commonData, (String)"build(...)");
        return commonData;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Web.ProductSpecificData> getProductSpecificData(String errorDescription, Throwable throwable, Boolean userConsentsToBeContacted) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string;
        void it;
        Object object;
        Object object2 = new Pair[18];
        object2[0] = TuplesKt.to((Object)APP_EAP_KEY, (Object)String.valueOf(this.getApplicationInfoEx().isEAP()));
        object2[1] = TuplesKt.to((Object)APP_INTERNAL_KEY, (Object)String.valueOf(this.getApplication().isInternal()));
        object2[2] = TuplesKt.to((Object)APP_NAME_KEY, (Object)this.getApplicationNamesInfo().getFullProductName());
        object2[3] = TuplesKt.to((Object)APP_NAME_VERSION_KEY, (Object)this.getApplicationInfoEx().getVersionName());
        object2[4] = TuplesKt.to((Object)APP_VERSION_MAJOR_KEY, (Object)this.getApplicationInfoEx().getMajorVersion());
        object2[5] = TuplesKt.to((Object)APP_VERSION_MINOR_KEY, (Object)this.getApplicationInfoEx().getMinorVersion());
        object2[6] = TuplesKt.to((Object)ERROR_DESCRIPTION_KEY, (Object)errorDescription);
        Throwable throwable2 = throwable;
        object2[7] = TuplesKt.to((Object)ERROR_MESSAGE_KEY, (Object)(throwable2 != null ? throwable2.getMessage() : null));
        Pair[] pairArray = object2;
        int n = 8;
        String string2 = ERROR_STACKTRACE_KEY;
        Throwable throwable3 = throwable;
        if (throwable3 != null) {
            Throwable throwable4 = throwable3;
            String string3 = string2;
            int n2 = n;
            object = pairArray;
            boolean bl = false;
            String string4 = ExceptionUtil.getThrowableText((Throwable)it);
            pairArray = object;
            n = n2;
            string2 = string3;
            string = string4;
        } else {
            string = null;
        }
        pairArray[n] = TuplesKt.to((Object)string2, string);
        Boolean bl = userConsentsToBeContacted;
        object2[9] = TuplesKt.to((Object)FEEDBACK_USER_CTL_CONSENT_KEY, (Object)(bl != null ? bl.toString() : null));
        object2[10] = TuplesKt.to((Object)JAVA_VERSION_KEY, (Object)SystemInfo.JAVA_VERSION);
        object2[11] = TuplesKt.to((Object)JAVA_VM_VENDOR_KEY, (Object)SystemInfo.JAVA_VENDOR);
        object2[12] = TuplesKt.to((Object)LAST_ACTION_KEY, (Object)this.getLastAction());
        object2[13] = TuplesKt.to((Object)OS_NAME_KEY, (Object)SystemInfo.OS_NAME);
        object2[14] = TuplesKt.to((Object)OS_VERSION, (Object)SystemInfo.OS_VERSION);
        object2[15] = TuplesKt.to((Object)OS_ARCHITECTURE, (Object)SystemInfo.OS_ARCH);
        object2[16] = TuplesKt.to((Object)PLUGIN_VERSION, (Object)this.getPluginVersion());
        object2[17] = TuplesKt.to((Object)FLAGS, (Object)this.getExperimentFlags());
        object2 = MapsKt.plus((Map)MapsKt.mapOf((Pair[])object2), this.getAdditionalProductSpecificData()).entrySet();
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            object = destination$iv$iv;
            boolean bl2 = false;
            Web.ProductSpecificData.Builder builder = Web.ProductSpecificData.newBuilder().setKey((String)it2.getKey());
            String string5 = (String)it2.getValue();
            if (string5 == null) {
                string5 = NONE_STRING;
            }
            object.add(builder.setValue(string5).build());
        }
        return (List)destination$iv$iv;
    }

    private final String createExceptionMarker(StackTraceElement stackTraceElement) {
        String string = "%s#%s:%s";
        Object[] objectArray = new Object[]{Strings.nullToEmpty((String)stackTraceElement.getClassName()), Strings.nullToEmpty((String)stackTraceElement.getMethodName()), stackTraceElement.getLineNumber()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Common.ProductSpecificBinaryData> getProductSpecificBinaryData(List<Attachment> attachments) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = attachments;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Attachment attachment2 = (Attachment)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Common.ProductSpecificBinaryData.newBuilder().setData(ByteString.copyFrom((byte[])it.getBytes())).setName(it.getDisplayText()).build());
        }
        return (List)destination$iv$iv;
    }

    private final MobileCommon.UserInitiatedFeedbackData getUserInitiatedFeedbackData(List<Attachment> attachments) {
        List<Common.ProductSpecificBinaryData> productSpecificBinaryData = this.getProductSpecificBinaryData(attachments);
        MobileCommon.UserInitiatedFeedbackData userInitiatedFeedbackData = MobileCommon.UserInitiatedFeedbackData.newBuilder().addAllProductSpecificBinaryData((Iterable)productSpecificBinaryData).build();
        Intrinsics.checkNotNullExpressionValue((Object)userInitiatedFeedbackData, (String)"build(...)");
        return userInitiatedFeedbackData;
    }

    @VisibleForTesting
    @NotNull
    public final String getLastAction() {
        String string = IdeaLogger.ourLastActionId;
        if (string == null) {
            string = NONE_STRING;
        }
        return string;
    }

    @VisibleForTesting
    @NotNull
    public final Application getApplication() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        return application;
    }

    @VisibleForTesting
    @NotNull
    public final ApplicationInfoEx getApplicationInfoEx() {
        ApplicationInfoEx applicationInfoEx = ApplicationInfoEx.getInstanceEx();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfoEx, (String)"getInstanceEx(...)");
        return applicationInfoEx;
    }

    @VisibleForTesting
    @NotNull
    public final ApplicationNamesInfo getApplicationNamesInfo() {
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"getInstance(...)");
        return applicationNamesInfo;
    }

    @VisibleForTesting
    @NotNull
    public final String getAppVersion() {
        String string = ApplicationInfo.getInstance().getFullVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullVersion(...)");
        return string;
    }

    @VisibleForTesting
    public final long getTimestamp() {
        return Instant.now().toEpochMilli();
    }

    private static final CharSequence assemblePIISafeStackTrace$lambda$0(StackTraceElement it) {
        String string = it.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0014\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/google/cloud/tools/intellij/feedback/FeedbackSerializerServiceBase$Companion;", "", "<init>", "()V", "APP_EAP_KEY", "", "APP_INTERNAL_KEY", "APP_NAME_KEY", "APP_NAME_VERSION_KEY", "APP_VERSION_MAJOR_KEY", "APP_VERSION_MINOR_KEY", "ERROR_DESCRIPTION_KEY", "ERROR_MESSAGE_KEY", "ERROR_STACKTRACE_KEY", "FEEDBACK_USER_CTL_CONSENT_KEY", "JAVA_VERSION_KEY", "JAVA_VM_VENDOR_KEY", "LAST_ACTION_KEY", "NONE_STRING", "OS_NAME_KEY", "OS_VERSION", "OS_ARCHITECTURE", "PLUGIN_VERSION", "FLAGS", "UNKNOWN_VALUE", "aiplugin.cloudcode-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FeedbackReportType.values().length];
            try {
                nArray[FeedbackReportType.Crash.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeedbackReportType.UserInitiated.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

