/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.analytics.firelog;

import com.google.cloud.tools.intellij.analytics.UsageTrackerBase;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public abstract class MetricsLogSchedulerBase
implements AppLifecycleListener {
    private static final Logger logger = Logger.getInstance(MetricsLogSchedulerBase.class);
    @VisibleForTesting
    static final long MIN_NEXT_REQUEST_WAIT_MILLIS = TimeUnit.MINUTES.toMillis(1L);
    @VisibleForTesting
    static final long MIN_NEXT_RETRY_WAIT_MILLIS = TimeUnit.MINUTES.toMillis(10L);
    private static final AtomicLong retryAttempts = new AtomicLong(1L);

    public abstract UsageTrackerBase getUsageTrackerService();

    public ScheduledExecutorService getAppScheduledExecutorService() {
        return AppExecutorUtil.getAppScheduledExecutorService();
    }

    public void appFrameCreated(@NotNull List<String> commandLineArgs) {
        this.start();
    }

    public void start() {
        logger.debug("Starting MetricsLogScheduler.");
        this.getAppScheduledExecutorService().schedule(this::flushLogsAndScheduleNextFlush, MIN_NEXT_REQUEST_WAIT_MILLIS, TimeUnit.MILLISECONDS);
        if (this.getUsageTrackerService().uploadFromDiskEnabled()) {
            this.getAppScheduledExecutorService().schedule(this::flushAndScheduleOfflineLogs, MIN_NEXT_RETRY_WAIT_MILLIS, TimeUnit.MILLISECONDS);
        }
    }

    public void appClosing() {
        logger.debug("App closing... flushing logs.");
        this.getUsageTrackerService().flushInBackground();
    }

    @RequiresBackgroundThread
    private void flushLogsAndScheduleNextFlush() {
        long nextSendWaitMillis = MIN_NEXT_REQUEST_WAIT_MILLIS;
        UsageTrackerBase usageTrackerService = this.getUsageTrackerService();
        if (usageTrackerService == null) {
            return;
        }
        try {
            logger.debug("Flushing logs.");
            Optional<Duration> nextSendWaitDurationResponse = usageTrackerService.flushAndAwait();
            nextSendWaitMillis = MetricsLogSchedulerBase.getBoundedNextSendWaitMillis(nextSendWaitDurationResponse);
            logger.debug("Scheduling next log flush in " + nextSendWaitMillis + " ms.");
        }
        catch (RuntimeException e) {
            logger.warn("Error flushing logs.", (Throwable)e);
        }
        this.getAppScheduledExecutorService().schedule(this::flushLogsAndScheduleNextFlush, nextSendWaitMillis, TimeUnit.MILLISECONDS);
    }

    @RequiresBackgroundThread
    @VisibleForTesting
    void flushAndScheduleOfflineLogs() {
        Duration nextRetryWait;
        if (this.getUsageTrackerService().uploadFromDiskEnabled()) {
            UsageTrackerBase usageTrackerService = this.getUsageTrackerService();
            if (usageTrackerService == null) {
                return;
            }
            logger.debug("Flushing offline logs.");
            boolean retrySuccess = usageTrackerService.retryFailedUploadsAndAwait();
            if (retrySuccess) {
                retryAttempts.set(1L);
            } else {
                retryAttempts.incrementAndGet();
            }
        }
        if ((nextRetryWait = Duration.ofMillis(retryAttempts.get() * retryAttempts.get() * MIN_NEXT_RETRY_WAIT_MILLIS)).compareTo(Duration.ofHours(1L)) > 0) {
            nextRetryWait = Duration.ofHours(1L);
        }
        logger.debug("Scheduling next offline log flush in " + nextRetryWait.toMinutes() + " minutes.");
        this.getAppScheduledExecutorService().schedule(this::flushAndScheduleOfflineLogs, nextRetryWait.toMillis(), TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    static long getBoundedNextSendWaitMillis(Optional<Duration> nextSendWaitDurationResponse) {
        if (nextSendWaitDurationResponse.isEmpty()) {
            return MIN_NEXT_REQUEST_WAIT_MILLIS;
        }
        return Math.max(nextSendWaitDurationResponse.get().toMillis(), MIN_NEXT_REQUEST_WAIT_MILLIS);
    }
}

