/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.analytics;

import com.google.cloud.tools.intellij.analytics.MetricWithMetadata;
import com.google.cloud.tools.intellij.analytics.MetricsFileType;
import com.google.gson.Gson;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a\b\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0006\u0010\n\u001a\u00020\u0007\u001a\u0006\u0010\u000b\u001a\u00020\u0007\u001a\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"localMetricsDir", "", "METRICS_DIRECTORY", "LOCAL_METRICS_FILENAME", "UI_TEST_METRICS_FILENAME", "getLocalMetricsFileParentDirectory", "getLocalMetricsFileLocation", "Ljava/io/File;", "metricsFileType", "Lcom/google/cloud/tools/intellij/analytics/MetricsFileType;", "getLocalTestMetricsFileLocation", "getUiTestMetricsFileLocation", "getActualTestMetricsFromLocalFile", "", "Lcom/google/cloud/tools/intellij/analytics/MetricWithMetadata;", "aiplugin.cloudcode-core"})
@SourceDebugExtension(value={"SMAP\nMetricsLocalDirectoryUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetricsLocalDirectoryUtil.kt\ncom/google/cloud/tools/intellij/analytics/MetricsLocalDirectoryUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1#2:93\n*E\n"})
public final class MetricsLocalDirectoryUtilKt {
    @NotNull
    private static final String METRICS_DIRECTORY = "metrics";
    @NotNull
    private static final String LOCAL_METRICS_FILENAME = "metrics.log";
    @NotNull
    private static final String UI_TEST_METRICS_FILENAME = "temp_ui_test_metrics.log";

    private static final String localMetricsDir() {
        String[] stringArray = new String[]{"cloud-code-metrics"};
        return ((Object)Paths.get(System.getProperty("user.home"), stringArray)).toString();
    }

    private static final String getLocalMetricsFileParentDirectory() {
        String string;
        String kokoroDirectory = System.getenv("KOKORO_ARTIFACTS_DIR");
        if (kokoroDirectory != null) {
            var2_1 = new String[]{METRICS_DIRECTORY};
            string = ((Object)Paths.get(kokoroDirectory, var2_1)).toString();
        } else {
            var2_1 = new String[]{METRICS_DIRECTORY};
            string = ((Object)Paths.get(MetricsLocalDirectoryUtilKt.localMetricsDir(), var2_1)).toString();
        }
        String directory = string;
        return directory;
    }

    @NotNull
    public static final File getLocalMetricsFileLocation(@NotNull MetricsFileType metricsFileType) {
        Intrinsics.checkNotNullParameter((Object)((Object)metricsFileType), (String)"metricsFileType");
        String metricsFileName = switch (WhenMappings.$EnumSwitchMapping$0[metricsFileType.ordinal()]) {
            case 1 -> LOCAL_METRICS_FILENAME;
            case 2 -> UI_TEST_METRICS_FILENAME;
            default -> throw new NoWhenBranchMatchedException();
        };
        File file = new File(MetricsLocalDirectoryUtilKt.getLocalMetricsFileParentDirectory(), metricsFileName);
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return file;
    }

    @NotNull
    public static final File getLocalTestMetricsFileLocation() {
        return MetricsLocalDirectoryUtilKt.getLocalMetricsFileLocation(MetricsFileType.LOCAL_TESTING);
    }

    @NotNull
    public static final File getUiTestMetricsFileLocation() {
        return MetricsLocalDirectoryUtilKt.getLocalMetricsFileLocation(MetricsFileType.UI_TEST);
    }

    @NotNull
    public static final List<MetricWithMetadata> getActualTestMetricsFromLocalFile() {
        List metricList = new ArrayList();
        File localMetricsFile = MetricsLocalDirectoryUtilKt.getUiTestMetricsFileLocation();
        FilesKt.forEachLine$default((File)localMetricsFile, null, arg_0 -> MetricsLocalDirectoryUtilKt.getActualTestMetricsFromLocalFile$lambda$1(metricList, arg_0), (int)1, null);
        return metricList;
    }

    private static final Unit getActualTestMetricsFromLocalFile$lambda$1(List $metricList, String metricString) {
        block2: {
            MetricWithMetadata metricWithMetadata;
            MetricWithMetadata metricWithMetadata2;
            Intrinsics.checkNotNullParameter((Object)metricString, (String)"metricString");
            try {
                metricWithMetadata2 = (MetricWithMetadata)new Gson().fromJson(metricString, MetricWithMetadata.class);
            }
            catch (Exception e) {
                metricWithMetadata2 = null;
            }
            MetricWithMetadata metricWithMetadata3 = metricWithMetadata = metricWithMetadata2;
            if (metricWithMetadata3 == null) break block2;
            MetricWithMetadata metric = metricWithMetadata3;
            boolean bl = false;
            $metricList.add(metric);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MetricsFileType.values().length];
            try {
                nArray[MetricsFileType.LOCAL_TESTING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricsFileType.UI_TEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

