/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.rag.lucene;

import com.google.aiplugin.rag.lucene.AllResultsCollectorManager;
import com.google.aiplugin.rag.lucene.IndexedDocument;
import com.google.aiplugin.rag.lucene.IndexedDocumentCollection;
import com.google.aiplugin.rag.lucene.LuceneIndexExtension;
import com.google.aiplugin.rag.lucene.LuceneIndexUtilsKt;
import com.google.aiplugin.rag.lucene.LuceneIndexWriterManagerService;
import com.google.aiplugin.rag.lucene.VirtualFileInScopeQuery;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import com.intellij.util.indexing.impl.ValueContainerProcessor;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000f*\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0002H\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J \u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\b\u0010\u0019\u001a\u00020\u0013H\u0016J.\u0010\u001a\u001a\u00020\u001b\"\b\b\u0000\u0010\u001c*\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00022\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u001c0\u001fH\u0016J*\u0010 \u001a\u00020\u001b2\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\b\u0010&\u001a\u00020\u0013H\u0016J\b\u0010'\u001a\u00020\u0013H\u0016J\b\u0010(\u001a\u00020\u001bH\u0016J\b\u0010+\u001a\u00020\u0013H\u0016J\b\u0010,\u001a\u00020\u001bH\u0016J\b\u0010-\u001a\u00020\u0002H\u0016J\u0018\u0010.\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0002H\u0002J\b\u0010/\u001a\u00020\u0013H\u0002J\"\u00100\u001a\u0002H1\"\u0004\b\u0000\u001012\f\u00102\u001a\b\u0012\u0004\u0012\u0002H103H\u0082\b\u00a2\u0006\u0002\u00104J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0002H\u0002J\u0010\u00108\u001a\u0002062\u0006\u00109\u001a\u00020\u0002H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/google/aiplugin/rag/lucene/LuceneIndexStorage;", "Lcom/intellij/util/indexing/VfsAwareIndexStorage;", "", "Lcom/google/aiplugin/rag/lucene/IndexedDocumentCollection;", "extension", "Lcom/google/aiplugin/rag/lucene/LuceneIndexExtension;", "<init>", "(Lcom/google/aiplugin/rag/lucene/LuceneIndexExtension;)V", "getExtension", "()Lcom/google/aiplugin/rag/lucene/LuceneIndexExtension;", "indexPath", "Ljava/nio/file/Path;", "indexWriter", "Lorg/apache/lucene/index/IndexWriter;", "toDocumentsForIndex", "", "Lorg/apache/lucene/index/IndexableField;", "inputId", "addValue", "", "key", "value", "removeAllValues", "updateValue", "newValue", "clear", "read", "", "E", "Ljava/lang/Exception;", "processor", "Lcom/intellij/util/indexing/impl/ValueContainerProcessor;", "processKeys", "Lcom/intellij/util/Processor;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "idFilter", "Lcom/intellij/util/indexing/IdFilter;", "clearCaches", "flush", "isDirty", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "close", "isClosed", "keysCountApproximately", "assertInputIdConsistent", "throwForTragicException", "handleLuceneExceptions", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getVfileIdField", "Lorg/apache/lucene/document/IntField;", "vfileId", "getSubDocumentIndexField", "index", "aiplugin.rag.indexer"})
@SourceDebugExtension(value={"SMAP\nLuceneIndexStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuceneIndexStorage.kt\ncom/google/aiplugin/rag/lucene/LuceneIndexStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,239:1\n225#1,5:245\n225#1,5:250\n225#1,5:255\n225#1,5:260\n225#1,3:265\n228#1,2:277\n225#1,5:279\n225#1,5:284\n225#1,5:289\n225#1,5:294\n1573#2:240\n1604#2,4:241\n1563#2:268\n1634#2,3:269\n1056#2:272\n1563#2:273\n1634#2,3:274\n1#3:299\n*S KotlinDebug\n*F\n+ 1 LuceneIndexStorage.kt\ncom/google/aiplugin/rag/lucene/LuceneIndexStorage\n*L\n59#1:245,5\n65#1:250,5\n73#1:255,5\n79#1:260,5\n93#1:265,3\n93#1:277,2\n138#1:279,5\n184#1:284,5\n187#1:289,5\n193#1:294,5\n52#1:240\n52#1:241,4\n105#1:268\n105#1:269,3\n114#1:272\n115#1:273\n115#1:274,3\n*E\n"})
public final class LuceneIndexStorage
implements VfsAwareIndexStorage<Integer, IndexedDocumentCollection> {
    @NotNull
    private final LuceneIndexExtension extension;
    @NotNull
    private final Path indexPath;
    @NotNull
    private final IndexWriter indexWriter;
    @NotNull
    private final AtomicBoolean closed;

    public LuceneIndexStorage(@NotNull LuceneIndexExtension extension) {
        Intrinsics.checkNotNullParameter((Object)((Object)extension), (String)"extension");
        this.extension = extension;
        this.indexPath = LuceneIndexUtilsKt.getIndexPath(this.extension.getName());
        this.indexWriter = LuceneIndexWriterManagerService.Companion.getInstance().getIndexWriter(this.indexPath, this.extension.createIndexWriterConfig());
        this.closed = new AtomicBoolean(false);
    }

    @NotNull
    public final LuceneIndexExtension getExtension() {
        return this.extension;
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<IndexableField>> toDocumentsForIndex(IndexedDocumentCollection $this$toDocumentsForIndex, int inputId) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = $this$toDocumentsForIndex.getDocuments();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void document2;
            void idx;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IndexedDocument indexedDocument = (IndexedDocument)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object[] objectArray = new IntField[]{this.getVfileIdField(inputId), this.getSubDocumentIndexField((int)idx)};
            collection.add(CollectionsKt.plus((Collection)document2.getFields(), (Iterable)CollectionsKt.listOf((Object[])objectArray)));
        }
        return (List)destination$iv$iv;
    }

    public void addValue(int key, int inputId, @NotNull IndexedDocumentCollection value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.assertInputIdConsistent(key, inputId);
        LuceneIndexStorage this_$iv = this;
        boolean $i$f$handleLuceneExceptions = false;
        this_$iv.throwForTragicException();
        try {
            boolean bl = false;
            long l2 = this.indexWriter.addDocuments((Iterable)this.toDocumentsForIndex(value, inputId));
        }
        catch (IOException e$iv) {
            throw new StorageException((Throwable)e$iv);
        }
    }

    public void removeAllValues(int key, int inputId) {
        this.assertInputIdConsistent(key, inputId);
        LuceneIndexStorage this_$iv = this;
        boolean $i$f$handleLuceneExceptions = false;
        this_$iv.throwForTragicException();
        try {
            boolean bl = false;
            Term[] termArray = new Term[]{LuceneIndexUtilsKt.asTerm(this.getVfileIdField(inputId))};
            long l2 = this.indexWriter.deleteDocuments(termArray);
        }
        catch (IOException e$iv) {
            throw new StorageException((Throwable)e$iv);
        }
    }

    public void updateValue(int key, int inputId, @NotNull IndexedDocumentCollection newValue) {
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        this.assertInputIdConsistent(key, inputId);
        IntField vfileField = this.getVfileIdField(inputId);
        LuceneIndexStorage this_$iv = this;
        boolean $i$f$handleLuceneExceptions = false;
        this_$iv.throwForTragicException();
        try {
            boolean bl = false;
            long l2 = this.indexWriter.updateDocuments(LuceneIndexUtilsKt.asTerm(vfileField), (Iterable)this.toDocumentsForIndex(newValue, inputId));
        }
        catch (IOException e$iv) {
            throw new StorageException((Throwable)e$iv);
        }
    }

    public void clear() {
        LuceneIndexStorage this_$iv = this;
        boolean $i$f$handleLuceneExceptions = false;
        this_$iv.throwForTragicException();
        try {
            boolean bl = false;
            this.indexWriter.deleteAll();
            long l2 = this.indexWriter.commit();
        }
        catch (IOException e$iv) {
            throw new StorageException((Throwable)e$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public <E extends Exception> boolean read(int key, @NotNull ValueContainerProcessor<IndexedDocumentCollection, E> processor) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        LuceneIndexStorage this_$iv = this;
        boolean $i$f$handleLuceneExceptions = false;
        this_$iv.throwForTragicException();
        try {
            boolean bl = false;
            Closeable closeable = (Closeable)LuceneIndexExtension.Companion.openIndexReader(this.extension.getName());
            Throwable throwable = null;
            try {
                Iterable $this$sortedBy$iv;
                Collection collection;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                IndexReader reader = (IndexReader)closeable;
                boolean bl2 = false;
                IndexSearcher searcher = new IndexSearcher(reader);
                Set documentIds = (Set)searcher.search(IntField.newExactQuery((String)"vfile.id", (int)key), (CollectorManager)AllResultsCollectorManager.INSTANCE);
                StoredFields storedFields = searcher.storedFields();
                Intrinsics.checkNotNull((Object)documentIds);
                Iterable iterable = documentIds;
                boolean $i$f$map = false;
                void var15_17 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Document document2;
                    int n = ((Number)item$iv$iv).intValue();
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    Document doc = document2 = storedFields.document((int)it);
                    boolean bl4 = false;
                    Intrinsics.checkNotNull((Object)doc);
                    Integer n2 = LuceneIndexUtilsKt.getVirtualFileId(doc);
                    int n3 = key;
                    if (!(n2 != null && n2 == n3)) {
                        boolean bl5 = false;
                        String string = "Returned an unexpected file " + LuceneIndexUtilsKt.getVirtualFileId(doc) + " from a search for " + key;
                        throw new IllegalStateException(string.toString());
                    }
                    collection.add(document2);
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Document it = (Document)a;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        Comparable comparable = LuceneIndexUtilsKt.getSubDocumentIndex(it);
                        it = (Document)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)LuceneIndexUtilsKt.getSubDocumentIndex(it));
                    }
                });
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Document it = (Document)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl6 = false;
                    List list = it.getFields();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFields(...)");
                    collection.add(new IndexedDocument(list));
                }
                List subDocuments = (List)destination$iv$iv;
                if (!((Collection)subDocuments).isEmpty()) {
                    ValueContainerImpl valueContainer = ValueContainerImpl.createNewValueContainer();
                    valueContainer.addValue(key, (Object)new IndexedDocumentCollection(subDocuments));
                    boolean bl7 = processor.process((ValueContainer)valueContainer);
                    return bl7;
                }
                boolean bl8 = true;
                return bl8;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e$iv) {
            throw new StorageException((Throwable)e$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processKeys(@NotNull Processor<? super Integer> processor, @NotNull GlobalSearchScope scope2, @Nullable IdFilter idFilter) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        LuceneIndexStorage this_$iv = this;
        boolean $i$f$handleLuceneExceptions = false;
        this_$iv.throwForTragicException();
        try {
            boolean bl = false;
            Closeable closeable = (Closeable)LuceneIndexExtension.Companion.openIndexReader(this.extension.getName());
            Throwable throwable = null;
            try {
                IndexReader reader = (IndexReader)closeable;
                boolean bl2 = false;
                IndexSearcher searcher = new IndexSearcher(reader);
                Ref.BooleanRef exited = new Ref.BooleanRef();
                Set processedFileIds = new LinkedHashSet();
                Collector collector2 = new Collector(exited, processedFileIds, processor){
                    final /* synthetic */ Ref.BooleanRef $exited;
                    final /* synthetic */ Set<Integer> $processedFileIds;
                    final /* synthetic */ Processor<? super Integer> $processor;
                    {
                        this.$exited = $exited;
                        this.$processedFileIds = $processedFileIds;
                        this.$processor = $processor;
                    }

                    public LeafCollector getLeafCollector(LeafReaderContext ctx) {
                        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                        if (this.$exited.element) {
                            throw new CollectionTerminatedException();
                        }
                        return new LeafCollector(ctx, this.$processedFileIds, this.$processor, this.$exited){
                            private final StoredFields storedFields;
                            final /* synthetic */ Set<Integer> $processedFileIds;
                            final /* synthetic */ Processor<? super Integer> $processor;
                            final /* synthetic */ Ref.BooleanRef $exited;
                            {
                                this.$processedFileIds = $processedFileIds;
                                this.$processor = $processor;
                                this.$exited = $exited;
                                StoredFields storedFields = $ctx.reader().storedFields();
                                Intrinsics.checkNotNull((Object)storedFields);
                                this.storedFields = storedFields;
                            }

                            public void collect(int doc) {
                                boolean result2;
                                Integer n = LuceneIndexUtilsKt.getVirtualFileIdForDoc(this.storedFields, doc);
                                if (n == null) {
                                    return;
                                }
                                int vfileId = n;
                                if (this.$processedFileIds.add(vfileId) && !(result2 = this.$processor.process((Object)vfileId))) {
                                    this.$exited.element = true;
                                    throw new CollectionTerminatedException();
                                }
                            }

                            public void setScorer(Scorable scorer) {
                                Intrinsics.checkNotNullParameter((Object)scorer, (String)"scorer");
                            }
                        };
                    }

                    public ScoreMode scoreMode() {
                        return ScoreMode.COMPLETE_NO_SCORES;
                    }
                };
                searcher.search((Query)new VirtualFileInScopeQuery(scope2, idFilter), collector2);
                boolean bl3 = !exited.element;
                return bl3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e$iv) {
            throw new StorageException((Throwable)e$iv);
        }
    }

    public void clearCaches() {
    }

    public void flush() {
        LuceneIndexStorage this_$iv = this;
        boolean $i$f$handleLuceneExceptions = false;
        this_$iv.throwForTragicException();
        try {
            boolean bl = false;
            long l2 = this.indexWriter.commit();
        }
        catch (IOException e$iv) {
            throw new StorageException((Throwable)e$iv);
        }
    }

    public boolean isDirty() {
        boolean bl;
        LuceneIndexStorage this_$iv = this;
        boolean $i$f$handleLuceneExceptions = false;
        this_$iv.throwForTragicException();
        try {
            boolean bl2 = false;
            bl = this.indexWriter.hasUncommittedChanges();
        }
        catch (IOException e$iv) {
            throw new StorageException((Throwable)e$iv);
        }
        return bl;
    }

    public void close() {
        if (!this.closed.getAndSet(true)) {
            LuceneIndexStorage this_$iv = this;
            boolean $i$f$handleLuceneExceptions = false;
            this_$iv.throwForTragicException();
            try {
                boolean bl = false;
                this.indexWriter.commit();
                LuceneIndexWriterManagerService.Companion.getInstance().releaseIndexWriter(this.indexPath, this.indexWriter);
                Unit unit = Unit.INSTANCE;
            }
            catch (IOException e$iv) {
                throw new StorageException((Throwable)e$iv);
            }
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public int keysCountApproximately() {
        int n;
        try {
            n = this.indexWriter.getDocStats().numDocs;
        }
        catch (Exception e) {
            n = -1;
        }
        return n;
    }

    private final void assertInputIdConsistent(int key, int inputId) {
        boolean bl;
        boolean bl2 = bl = key == inputId;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Key " + key + " does not match inputId " + inputId;
            throw new AssertionError((Object)string);
        }
    }

    private final void throwForTragicException() {
        Throwable tragedy = this.indexWriter.getTragicException();
        if (tragedy != null) {
            this.closed.set(true);
            throw new StorageException("IndexWriter internal error", tragedy);
        }
        if (!this.indexWriter.isOpen()) {
            throw new StorageException("IndexWriter closed while in use");
        }
    }

    private final <T> T handleLuceneExceptions(Function0<? extends T> block) throws StorageException {
        Object object;
        boolean $i$f$handleLuceneExceptions = false;
        this.throwForTragicException();
        try {
            object = block.invoke();
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
        return (T)object;
    }

    private final IntField getVfileIdField(int vfileId) {
        return new IntField("vfile.id", vfileId, Field.Store.YES);
    }

    private final IntField getSubDocumentIndexField(int index) {
        return new IntField("subdocument.index", index, Field.Store.YES);
    }
}

