/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.rag.internal;

import com.google.aiplugin.rag.internal.CrawlerBasedRagIndexer;
import com.google.aiplugin.rag.internal.FilesInProjectDirectoryPropertyPusherKt;
import com.google.aiplugin.rag.internal.RagIndexer;
import com.google.aiplugin.rag.internal.VirtualFileUtilsKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.IndexedFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0005\u001a\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0002\u001a\u0018\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007\u001a\u001a\u0010\r\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00022\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\b\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0002\u001a\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013\u001a\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0007\u00a8\u0006\u0017"}, d2={"shouldBeIndexedForRag", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "projectFileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "Lcom/intellij/util/indexing/IndexedFile;", "getRepositoryPath", "", "Lcom/intellij/openapi/project/Project;", "file", "getRelativePath", "basePath", "absolutePath", "getFilePathToIndex", "project", "unindexIfNecessary", "", "unindexFileIfNecessary", "fileId", "", "getPsiFileForAnalysis", "Lcom/intellij/psi/PsiFile;", "Lcom/intellij/util/indexing/FileContent;", "aiplugin.rag.indexer"})
@SourceDebugExtension(value={"SMAP\nRagIndexerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RagIndexerUtils.kt\ncom/google/aiplugin/rag/internal/RagIndexerUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1#2:120\n*E\n"})
public final class RagIndexerUtilsKt {
    public static final boolean shouldBeIndexedForRag(@NotNull VirtualFile $this$shouldBeIndexedForRag, @Nullable ProjectFileIndex projectFileIndex2) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeIndexedForRag, (String)"<this>");
        if (!VirtualFileUtil.isFile((VirtualFile)$this$shouldBeIndexedForRag)) {
            return false;
        }
        if (!FilesInProjectDirectoryPropertyPusherKt.isInProjectDirectory($this$shouldBeIndexedForRag)) {
            return false;
        }
        if (projectFileIndex2 == null) {
            return true;
        }
        if (projectFileIndex2.isExcluded($this$shouldBeIndexedForRag)) {
            return false;
        }
        if (projectFileIndex2.isInGeneratedSources($this$shouldBeIndexedForRag)) {
            return false;
        }
        return !projectFileIndex2.isInLibraryClasses($this$shouldBeIndexedForRag);
    }

    public static final boolean shouldBeIndexedForRag(@NotNull IndexedFile $this$shouldBeIndexedForRag) {
        ProjectFileIndex projectFileIndex2;
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeIndexedForRag, (String)"<this>");
        try {
            projectFileIndex2 = ProjectFileIndex.getInstance((Project)$this$shouldBeIndexedForRag.getProject());
        }
        catch (IllegalStateException e) {
            projectFileIndex2 = null;
        }
        ProjectFileIndex projectFileIndex3 = projectFileIndex2;
        VirtualFile virtualFile2 = $this$shouldBeIndexedForRag.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
        return RagIndexerUtilsKt.shouldBeIndexedForRag(virtualFile2, projectFileIndex3);
    }

    @Nullable
    public static final String getRepositoryPath(@NotNull Project $this$getRepositoryPath, @Nullable VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)$this$getRepositoryPath, (String)"<this>");
        VirtualFile virtualFile2 = file;
        if (virtualFile2 == null && (virtualFile2 = $this$getRepositoryPath.getWorkspaceFile()) == null) {
            return $this$getRepositoryPath.getBasePath();
        }
        VirtualFile workSpaceFile = virtualFile2;
        VirtualFile virtualFile3 = (VirtualFile)ActionsKt.runReadAction(() -> RagIndexerUtilsKt.getRepositoryPath$lambda$0($this$getRepositoryPath, workSpaceFile));
        return virtualFile3 != null ? virtualFile3.getPath() : null;
    }

    public static /* synthetic */ String getRepositoryPath$default(Project project2, VirtualFile virtualFile2, int n, Object object) {
        if ((n & 1) != 0) {
            virtualFile2 = null;
        }
        return RagIndexerUtilsKt.getRepositoryPath(project2, virtualFile2);
    }

    @Nullable
    public static final String getRelativePath(@NotNull String basePath2, @NotNull String absolutePath) {
        String string;
        Intrinsics.checkNotNullParameter((Object)basePath2, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)absolutePath, (String)"absolutePath");
        Path absolute = Paths.get(absolutePath, new String[0]);
        Path base = Paths.get(basePath2, new String[0]);
        try {
            string = ((Object)base.relativize(absolute)).toString();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            string = null;
        }
        return string;
    }

    @NotNull
    public static final String getFilePathToIndex(@NotNull VirtualFile file, @Nullable Project project2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Project project3 = project2;
        if (project3 == null && (project3 = VirtualFileUtilsKt.guessProject(file)) == null) {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }
        Project projectToUse = project3;
        String string = RagIndexerUtilsKt.getRepositoryPath(projectToUse, file);
        if (string == null) {
            String string2 = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            return string2;
        }
        String basePath2 = string;
        String string3 = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
        String string4 = RagIndexerUtilsKt.getRelativePath(basePath2, string3);
        if (string4 == null) {
            String string5 = file.getName();
            string4 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
        }
        return string4;
    }

    public static /* synthetic */ String getFilePathToIndex$default(VirtualFile virtualFile2, Project project2, int n, Object object) {
        if ((n & 2) != 0) {
            project2 = null;
        }
        return RagIndexerUtilsKt.getFilePathToIndex(virtualFile2, project2);
    }

    public static final void unindexIfNecessary(@NotNull VirtualFile $this$unindexIfNecessary) {
        Intrinsics.checkNotNullParameter((Object)$this$unindexIfNecessary, (String)"<this>");
        Integer n = VirtualFileUtilsKt.id($this$unindexIfNecessary);
        if (n == null) {
            return;
        }
        RagIndexerUtilsKt.unindexFileIfNecessary(n);
    }

    public static final void unindexFileIfNecessary(int fileId) {
        block0: {
            RagIndexer ragIndexer = RagIndexer.Companion.getInstance();
            CrawlerBasedRagIndexer crawlerBasedRagIndexer = ragIndexer instanceof CrawlerBasedRagIndexer ? (CrawlerBasedRagIndexer)ragIndexer : null;
            if (crawlerBasedRagIndexer == null) break block0;
            crawlerBasedRagIndexer.unindex(fileId);
        }
    }

    @RequiresReadLock
    @NotNull
    public static final PsiFile getPsiFileForAnalysis(@NotNull FileContent $this$getPsiFileForAnalysis) {
        Project project2;
        block5: {
            block4: {
                Project project3;
                Intrinsics.checkNotNullParameter((Object)$this$getPsiFileForAnalysis, (String)"<this>");
                Project project4 = $this$getPsiFileForAnalysis.getProject();
                if (project4 == null) {
                    VirtualFile virtualFile2 = $this$getPsiFileForAnalysis.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
                    project4 = VirtualFileUtilsKt.guessProject(virtualFile2);
                }
                if ((project2 = (project3 = project4)) == null) break block4;
                Project p0 = project2;
                boolean bl = false;
                PsiManager psiManager = PsiManager.getInstance((Project)p0);
                project2 = psiManager;
                if (psiManager != null && (project2 = project2.findFile($this$getPsiFileForAnalysis.getFile())) != null) break block5;
            }
            PsiFile psiFile2 = $this$getPsiFileForAnalysis.getPsiFile();
            project2 = psiFile2;
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getPsiFile(...)");
        }
        return project2;
    }

    private static final VirtualFile getRepositoryPath$lambda$0(Project $this_getRepositoryPath, VirtualFile $workSpaceFile) {
        return ProjectFileIndex.getInstance((Project)$this_getRepositoryPath).getContentRootForFile($workSpaceFile);
    }
}

