/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.rag.internal;

import com.google.aiplugin.rag.internal.RagIndexerUtilsKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/google/aiplugin/rag/internal/IndexableFilesCleaner;", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "<init>", "()V", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "unindex", "", "removedFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "aiplugin.rag.indexer"})
public final class IndexableFilesCleaner
implements AsyncFileListener {
    @Nullable
    public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        for (VFileEvent vFileEvent : events) {
            VirtualFile file;
            if (vFileEvent.getFile() == null || !(vFileEvent instanceof VFileDeleteEvent)) continue;
            this.unindex(file);
        }
        return null;
    }

    private final void unindex(VirtualFile removedFile) {
        VfsUtilCore.processFilesRecursively((VirtualFile)removedFile, arg_0 -> IndexableFilesCleaner.unindex$lambda$1(IndexableFilesCleaner::unindex$lambda$0, arg_0));
    }

    private static final boolean unindex$lambda$0(VirtualFile child) {
        ProgressManager.checkCanceled();
        if (!child.isDirectory()) {
            Intrinsics.checkNotNull((Object)child);
            RagIndexerUtilsKt.unindexIfNecessary(child);
        }
        return true;
    }

    private static final boolean unindex$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

