/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.mcp.config;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.aiplugin.mcp.McpHostBundle;
import com.google.aiplugin.mcp.config.GlobalMcpServerRegistry;
import com.google.aiplugin.mcp.config.McpServerConfig;
import com.google.aiplugin.mcp.config.McpServerRegistry;
import com.google.aiplugin.mcp.config.McpServers;
import com.google.aiplugin.mcp.config.McpServersConfigurable;
import com.intellij.ide.actions.ShowLogAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import io.modelcontextprotocol.kotlin.sdk.client.Client;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J\b\u0010\u0019\u001a\u00020\u0010H\u0016J\u0018\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0002H\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/google/aiplugin/mcp/config/GlobalMcpServerRegistryImpl;", "Lcom/google/aiplugin/mcp/config/GlobalMcpServerRegistry;", "Lcom/intellij/openapi/Disposable;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "registry", "Lcom/google/aiplugin/mcp/config/McpServerRegistry;", "getRegistry", "()Lcom/google/aiplugin/mcp/config/McpServerRegistry;", "setRegistry", "(Lcom/google/aiplugin/mcp/config/McpServerRegistry;)V", "refreshServers", "", "notifyInvalidConfiguration", "message", "", "getClients", "", "Lio/modelcontextprotocol/kotlin/sdk/client/Client;", "getClientByServerName", "serverName", "dispose", "addClientForTest", "client", "testDisposable", "aiplugin.mcp.client.sdkcompat"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGlobalMcpServerRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlobalMcpServerRegistry.kt\ncom/google/aiplugin/mcp/config/GlobalMcpServerRegistryImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,186:1\n14#2:187\n*S KotlinDebug\n*F\n+ 1 GlobalMcpServerRegistry.kt\ncom/google/aiplugin/mcp/config/GlobalMcpServerRegistryImpl\n*L\n75#1:187\n*E\n"})
public final class GlobalMcpServerRegistryImpl
implements GlobalMcpServerRegistry,
Disposable {
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private McpServerRegistry registry;
    public static final int $stable = 8;

    public GlobalMcpServerRegistryImpl(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.registry = new McpServerRegistry(MapsKt.emptyMap(), this.coroutineScope, CollectionsKt.emptyList(), null, null, 24, null);
        this.refreshServers();
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    @Override
    @NotNull
    public McpServerRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(@NotNull McpServerRegistry mcpServerRegistry) {
        Intrinsics.checkNotNullParameter((Object)mcpServerRegistry, (String)"<set-?>");
        this.registry = mcpServerRegistry;
    }

    @Override
    public void refreshServers() {
        McpServers mcpServers;
        Path config2 = McpServersConfigurable.Companion.getConfigFile();
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(config2, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && McpServersConfigurable.Companion.isMcpServersEnabled()) {
            McpServers mcpServers2;
            try {
                mcpServers2 = GlobalMcpServerRegistry.Companion.parseConfig(PathsKt.readText$default((Path)config2, null, (int)1, null));
            }
            catch (Exception e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(GlobalMcpServerRegistry.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Could not parse configuration file", (Throwable)e);
                String string = e.getMessage();
                if (string == null) {
                    string = e.toString();
                }
                this.notifyInvalidConfiguration(string);
                mcpServers2 = new McpServers(MapsKt.emptyMap(), null, 2, null);
            }
            mcpServers = mcpServers2;
        } else {
            mcpServers = new McpServers(MapsKt.emptyMap(), null, 2, null);
        }
        McpServers mcpServers3 = mcpServers;
        Map<String, McpServerConfig> servers = mcpServers3.component1();
        List<String> excludeTools = mcpServers3.component2();
        Disposer.dispose((Disposable)this.getRegistry());
        this.setRegistry(new McpServerRegistry(servers, this.coroutineScope, excludeTools, null, null, 24, null));
    }

    private final void notifyInvalidConfiguration(String message) {
        Object[] objectArray = new Object[]{"mcp.json", message};
        Notification notification = NotificationGroupManager.getInstance().getNotificationGroup("Mcp Host").createNotification(McpHostBundle.message("mcp.host.notifications.configuration.parse.error", objectArray), NotificationType.WARNING);
        notification.addAction((AnAction)ShowLogAction.notificationAction());
        notification.notify(null);
    }

    @Override
    @NotNull
    public List<Client> getClients() {
        return this.getRegistry().getClients();
    }

    @Override
    @Nullable
    public Client getClientByServerName(@NotNull String serverName) {
        Intrinsics.checkNotNullParameter((Object)serverName, (String)"serverName");
        return this.getRegistry().getClientByServerName(serverName);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.getRegistry());
    }

    @TestOnly
    public final void addClientForTest(@NotNull Client client2, @NotNull Disposable testDisposable) {
        Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
        Intrinsics.checkNotNullParameter((Object)testDisposable, (String)"testDisposable");
        this.getRegistry().addClientForTest(client2, testDisposable);
    }
}

