/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.mcp.auth;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.aiplugin.mcp.auth.AuthorizationCodeHolder;
import com.google.aiplugin.mcp.auth.OAuthServer;
import com.google.api.client.auth.oauth2.AuthorizationCodeTokenRequest;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/google/aiplugin/mcp/auth/GenericOAuthServer;", "Lcom/google/aiplugin/mcp/auth/OAuthServer;", "transport", "Lcom/google/api/client/http/HttpTransport;", "tokenEndpoint", "", "clientId", "clientSecret", "<init>", "(Lcom/google/api/client/http/HttpTransport;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getToken", "Lcom/google/api/client/auth/oauth2/TokenResponse;", "authorizationCodeHolder", "Lcom/google/aiplugin/mcp/auth/AuthorizationCodeHolder;", "aiplugin.mcp.client.sdkcompat"})
@StabilityInferred(parameters=0)
public final class GenericOAuthServer
implements OAuthServer {
    @NotNull
    private final HttpTransport transport;
    @NotNull
    private final String tokenEndpoint;
    @NotNull
    private final String clientId;
    @Nullable
    private final String clientSecret;
    public static final int $stable = 8;

    public GenericOAuthServer(@NotNull HttpTransport transport, @NotNull String tokenEndpoint, @NotNull String clientId, @Nullable String clientSecret) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        Intrinsics.checkNotNullParameter((Object)tokenEndpoint, (String)"tokenEndpoint");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        this.transport = transport;
        this.tokenEndpoint = tokenEndpoint;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    @Override
    @NotNull
    public TokenResponse getToken(@NotNull AuthorizationCodeHolder authorizationCodeHolder) throws IOException {
        Intrinsics.checkNotNullParameter((Object)authorizationCodeHolder, (String)"authorizationCodeHolder");
        TokenResponse tokenResponse = new AuthorizationCodeTokenRequest(this.transport, (JsonFactory)new GsonFactory(), new GenericUrl(this.tokenEndpoint), authorizationCodeHolder.getAuthorizationCode()).setRedirectUri(authorizationCodeHolder.getRedirectUrl()).setClientAuthentication((HttpExecuteInterceptor)new ClientParametersAuthentication(this.clientId, this.clientSecret)).set("code_verifier", (Object)authorizationCodeHolder.getCodeVerifier()).execute();
        Intrinsics.checkNotNullExpressionValue((Object)tokenResponse, (String)"execute(...)");
        return tokenResponse;
    }
}

