/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.tools.search;

import com.google.aiplugin.agents.BasicToolIcon;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolArgument;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.google.aiplugin.agents.tools.search.FindFilesArgs;
import com.google.aiplugin.agents.tools.search.FindFilesHandler;
import com.intellij.openapi.project.Project;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KParameter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ToolDescription(summary="Looks up the absolute path to files given only the file name or a part of the file path.", description="Searches for all files in the project whose names contain the specified string (case-insensitive).", instructions="The maximum number of results is 100. Attempt a more specific query if this limit is reached. If you do not know specific file paths, please use the `code_search` tool instead. Note: Only searches through files within the project, excluding libraries and external dependencies.", examples={})
@ToolResult(description="Returns a JSON array of objects containing the full paths that match the query.\n- path: Absolute path\n- type: Optional field, set to \"directory\" if the path corresponds to a directory.\nReturns an empty array ([]) if no matching files are found.")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/google/aiplugin/agents/tools/search/FindFilesTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/google/aiplugin/agents/tools/search/FindFilesArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "icon", "Lcom/google/aiplugin/agents/BasicToolIcon;", "getIcon", "()Lcom/google/aiplugin/agents/BasicToolIcon;", "createHandler", "Lcom/google/aiplugin/agents/tools/search/FindFilesHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "getRunningDisplayText", "getCompletedDisplayText", "Companion", "aiplugin.agents.agents-core"})
public final class FindFilesTool
implements Tool<FindFilesArgs> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final BasicToolIcon icon = BasicToolIcon.SEARCH;
    public static final int MAX_RESULTS = 100;

    public FindFilesTool() {
        this.name = "find_files";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public BasicToolIcon getIcon() {
        return this.icon;
    }

    @NotNull
    public FindFilesHandler createHandler(@NotNull ToolContext context2, @NotNull FindFilesArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new FindFilesHandler(context2, args, 100);
    }

    @Override
    @NotNull
    public String getRunningDisplayText(@NotNull FindFilesArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Searching for files matching " + args.getQuery();
    }

    @Override
    @NotNull
    public String getCompletedDisplayText(@NotNull FindFilesArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Searched for files matching " + args.getQuery();
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tool.super.getDescription();
    }

    @Override
    @Nullable
    public String getStatusMessage() {
        return Tool.super.getStatusMessage();
    }

    @Override
    @Nullable
    public ToolHandler restoreHandler(@NotNull Project project2, @NotNull FindFilesArgs args, @NotNull Response response2) {
        return Tool.super.restoreHandler(project2, args, response2);
    }

    @Override
    @NotNull
    public ToolDescription getToolDescription() {
        return Tool.super.getToolDescription();
    }

    @Override
    @Nullable
    public ToolResult getToolResult() {
        return Tool.super.getToolResult();
    }

    @Override
    @Nullable
    public Map<KParameter, ToolArgument> getToolArguments() {
        return Tool.super.getToolArguments();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/google/aiplugin/agents/tools/search/FindFilesTool$Companion;", "", "<init>", "()V", "MAX_RESULTS", "", "aiplugin.agents.agents-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

