/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.tools.plan;

import com.google.aiplugin.agents.tools.plan.Plan;
import com.google.aiplugin.agents.tools.plan.PlanStep;
import com.google.aiplugin.agents.tools.plan.PlanStepState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/google/aiplugin/agents/tools/plan/PlanManager;", "", "<init>", "()V", "Companion", "aiplugin.agents.agents-core"})
public final class PlanManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ConcurrentHashMap<String, Plan> planCache = new ConcurrentHashMap();

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001c\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/google/aiplugin/agents/tools/plan/PlanManager$Companion;", "", "<init>", "()V", "startPlan", "", "id", "", "plan", "Lcom/google/aiplugin/agents/tools/plan/Plan;", "getPlan", "clearPlan", "completeStep", "remainingSteps", "", "Lcom/google/aiplugin/agents/tools/plan/PlanStep;", "markActive", "markIdle", "planCache", "Ljava/util/concurrent/ConcurrentHashMap;", "aiplugin.agents.agents-core"})
    @SourceDebugExtension(value={"SMAP\nPlanManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlanManager.kt\ncom/google/aiplugin/agents/tools/plan/PlanManager$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n360#2,7:99\n295#2,2:106\n1563#2:108\n1634#2,3:109\n1563#2:112\n1634#2,3:113\n*S KotlinDebug\n*F\n+ 1 PlanManager.kt\ncom/google/aiplugin/agents/tools/plan/PlanManager$Companion\n*L\n47#1:99,7\n66#1:106,2\n70#1:108\n70#1:109,3\n85#1:112\n85#1:113,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void startPlan(@NotNull String id, @NotNull Plan plan) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)plan, (String)"plan");
            List steps = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)PlanStep.copy$default((PlanStep)CollectionsKt.first(plan.getSteps()), null, null, PlanStepState.ONGOING, 3, null)), (Iterable)CollectionsKt.drop((Iterable)plan.getSteps(), (int)1));
            ((Map)planCache).put(id, new Plan(steps));
        }

        @Nullable
        public final Plan getPlan(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return (Plan)planCache.get(id);
        }

        public final void clearPlan(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            planCache.remove(id);
        }

        public final void completeStep(@NotNull String id, @NotNull List<PlanStep> remainingSteps) {
            int n;
            Object currentSteps;
            block3: {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter(remainingSteps, (String)"remainingSteps");
                Object object = (Plan)planCache.get(id);
                if (object == null || (object = ((Plan)object).getSteps()) == null) {
                    throw new IllegalArgumentException();
                }
                Object $this$indexOfFirst$iv = currentSteps = object;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    Object item$iv = iterator.next();
                    PlanStep it = (PlanStep)item$iv;
                    boolean bl = false;
                    if (it.getStatus() == PlanStepState.ONGOING) {
                        n = index$iv;
                        break block3;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int activeStepIndex = n;
            List updatedSteps = CollectionsKt.plus((Collection)currentSteps.subList(0, activeStepIndex), (Object)PlanStep.copy$default((PlanStep)currentSteps.get(activeStepIndex), null, null, PlanStepState.DONE, 3, null));
            List toAppend = !((Collection)remainingSteps).isEmpty() ? CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)PlanStep.copy$default((PlanStep)CollectionsKt.first(remainingSteps), null, null, PlanStepState.ONGOING, 3, null)), (Iterable)CollectionsKt.drop((Iterable)remainingSteps, (int)1)) : CollectionsKt.emptyList();
            ((Map)planCache).put(id, new Plan(CollectionsKt.plus((Collection)updatedSteps, (Iterable)toAppend)));
        }

        /*
         * WARNING - void declaration
         */
        public final void markActive(@NotNull String id) {
            void $this$mapTo$iv$iv;
            Object v1;
            Plan plan;
            block4: {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Plan plan2 = (Plan)planCache.get(id);
                if (plan2 == null) {
                    return;
                }
                plan = plan2;
                Iterable $this$firstOrNull$iv = plan.getSteps();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PlanStep it = (PlanStep)element$iv;
                    boolean bl = false;
                    if (!(it.getStatus() == PlanStepState.PLANNED)) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            PlanStep planStep = v1;
            if (planStep == null) {
                return;
            }
            PlanStep firstPlannedStep = planStep;
            Map map2 = planCache;
            Iterable $this$map$iv = plan.getSteps();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void step2;
                PlanStep planStep2 = (PlanStep)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Intrinsics.areEqual((Object)step2, (Object)firstPlannedStep) ? PlanStep.copy$default((PlanStep)step2, null, null, PlanStepState.ONGOING, 3, null) : step2);
            }
            List list = (List)destination$iv$iv;
            Plan plan3 = new Plan(list);
            map2.put(id, plan3);
        }

        /*
         * WARNING - void declaration
         */
        public final void markIdle(@NotNull String id) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Plan plan = (Plan)planCache.get(id);
            if (plan == null) {
                return;
            }
            Plan plan2 = plan;
            Map map2 = planCache;
            Iterable $this$map$iv = plan2.getSteps();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void step2;
                PlanStep planStep = (PlanStep)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(switch (WhenMappings.$EnumSwitchMapping$0[step2.getStatus().ordinal()]) {
                    case 1, 2 -> step2;
                    case 3 -> PlanStep.copy$default((PlanStep)step2, null, null, PlanStepState.PLANNED, 3, null);
                    default -> throw new NoWhenBranchMatchedException();
                });
            }
            List list = (List)destination$iv$iv;
            Plan plan3 = new Plan(list);
            map2.put(id, plan3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[PlanStepState.values().length];
                try {
                    nArray[PlanStepState.PLANNED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PlanStepState.DONE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PlanStepState.ONGOING.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

