/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.tools.analyze;

import com.android.tools.idea.studiobot.AiExcludeService;
import com.google.aiplugin.agents.NoArgs;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.gson.Gson;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J,\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00102\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/google/aiplugin/agents/tools/analyze/AnalyzeCurrentFileToolHandler;", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "Lcom/google/aiplugin/agents/NoArgs;", "<init>", "(Lcom/google/aiplugin/agents/tools/ToolContext;Lcom/google/aiplugin/agents/NoArgs;)V", "getContext", "()Lcom/google/aiplugin/agents/tools/ToolContext;", "getArgs", "()Lcom/google/aiplugin/agents/NoArgs;", "handle", "Lcom/google/aiplugin/agents/Response;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getHighlightInfos", "", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "getAnalysisResults", "Lcom/google/aiplugin/agents/tools/analyze/AnalyzeCurrentFileToolHandler$AnalysisResult;", "highlightInfos", "filePath", "", "AnalysisResult", "aiplugin.agents.agents-core"})
@SourceDebugExtension(value={"SMAP\nAnalyzeCurrentFileTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyzeCurrentFileTool.kt\ncom/google/aiplugin/agents/tools/analyze/AnalyzeCurrentFileToolHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1563#2:148\n1634#2,3:149\n*S KotlinDebug\n*F\n+ 1 AnalyzeCurrentFileTool.kt\ncom/google/aiplugin/agents/tools/analyze/AnalyzeCurrentFileToolHandler\n*L\n137#1:148\n137#1:149,3\n*E\n"})
public final class AnalyzeCurrentFileToolHandler
implements ToolHandler {
    @NotNull
    private final ToolContext context;
    @NotNull
    private final NoArgs args;

    public AnalyzeCurrentFileToolHandler(@NotNull ToolContext context2, @NotNull NoArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.context = context2;
        this.args = args;
    }

    @NotNull
    public final ToolContext getContext() {
        return this.context;
    }

    @NotNull
    public final NoArgs getArgs() {
        return this.args;
    }

    @Override
    @Nullable
    public Object handle(@NotNull Continuation<? super Response> $completion) {
        Project project2 = this.context.getProject();
        return ActionsKt.runReadAction(() -> AnalyzeCurrentFileToolHandler.handle$lambda$0(project2, this));
    }

    private final List<HighlightInfo> getHighlightInfos(Project project2, Document document2) {
        List highlightInfos = new ArrayList();
        DaemonCodeAnalyzerEx.processHighlights((Document)document2, (Project)project2, (HighlightSeverity)HighlightSeverity.WEAK_WARNING, (int)0, (int)document2.getTextLength(), arg_0 -> AnalyzeCurrentFileToolHandler.getHighlightInfos$lambda$2(arg_0 -> AnalyzeCurrentFileToolHandler.getHighlightInfos$lambda$1(highlightInfos, arg_0), arg_0));
        return highlightInfos;
    }

    /*
     * WARNING - void declaration
     */
    private final List<AnalysisResult> getAnalysisResults(Document document2, List<? extends HighlightInfo> highlightInfos, String filePath) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = highlightInfos;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String lineContent;
            void info2;
            HighlightInfo highlightInfo = (HighlightInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int startLine = document2.getLineNumber(info2.startOffset);
            int lineStartOffset = document2.getLineStartOffset(startLine);
            int lineEndOffset = document2.getLineEndOffset(startLine);
            Intrinsics.checkNotNullExpressionValue((Object)document2.getText(new TextRange(lineStartOffset, lineEndOffset)), (String)"getText(...)");
            String string = info2.getSeverity().getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
            String string2 = info2.getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDescription(...)");
            collection.add(new AnalysisResult(filePath, string, string2, lineContent));
        }
        return (List)destination$iv$iv;
    }

    private static final Response handle$lambda$0(Project $project, AnalyzeCurrentFileToolHandler this$0) {
        Response response2;
        try {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)$project);
            Editor editor2 = fileEditorManager.getSelectedTextEditor();
            if (editor2 == null) {
                return new Response(null, "no file open", null, null, null, 29, null);
            }
            Editor editor3 = editor2;
            Document document2 = editor3.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
            Document document3 = document2;
            PsiFile psiFile2 = PsiDocumentManager.getInstance((Project)$project).getPsiFile(document3);
            if (psiFile2 == null) {
                return new Response(null, "could not get PSI file", null, null, null, 29, null);
            }
            PsiFile psiFile3 = psiFile2;
            AiExcludeService aiExcludeService2 = AiExcludeService.Companion.getInstance(this$0.context.getProject());
            VirtualFile virtualFile2 = psiFile3.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
            AiExcludeService.ExclusionStatus exclusionStatus = aiExcludeService2.getExclusionStatus(virtualFile2);
            switch (WhenMappings.$EnumSwitchMapping$0[exclusionStatus.ordinal()]) {
                case 1: {
                    return new Response(null, "file not in project or vcs roots", null, null, null, 29, null);
                }
                case 2: {
                    return new Response(null, "file blocked by aiexclude", null, null, null, 29, null);
                }
                case 3: {
                    return new Response(null, "file blocked by gitignore", null, null, null, 29, null);
                }
                case 4: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String string = psiFile3.getVirtualFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String filePath = string;
            List<HighlightInfo> highlightInfos = this$0.getHighlightInfos($project, document3);
            List<AnalysisResult> results = this$0.getAnalysisResults(document3, highlightInfos, filePath);
            String json = new Gson().toJson(results);
            response2 = new Response(json, null, null, null, null, 30, null);
        }
        catch (Exception e) {
            response2 = new Response(null, "Error analyzing file: " + e.getMessage(), null, null, null, 29, null);
        }
        return response2;
    }

    private static final boolean getHighlightInfos$lambda$1(List $highlightInfos, HighlightInfo highlightInfo) {
        Intrinsics.checkNotNull((Object)highlightInfo);
        $highlightInfos.add(highlightInfo);
        return true;
    }

    private static final boolean getHighlightInfos$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/google/aiplugin/agents/tools/analyze/AnalyzeCurrentFileToolHandler$AnalysisResult;", "", "filePath", "", "severity", "description", "lineContent", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getFilePath", "()Ljava/lang/String;", "getSeverity", "getDescription", "getLineContent", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "aiplugin.agents.agents-core"})
    public static final class AnalysisResult {
        @NotNull
        private final String filePath;
        @NotNull
        private final String severity;
        @NotNull
        private final String description;
        @NotNull
        private final String lineContent;

        public AnalysisResult(@NotNull String filePath, @NotNull String severity, @NotNull String description, @NotNull String lineContent) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)lineContent, (String)"lineContent");
            this.filePath = filePath;
            this.severity = severity;
            this.description = description;
            this.lineContent = lineContent;
        }

        @NotNull
        public final String getFilePath() {
            return this.filePath;
        }

        @NotNull
        public final String getSeverity() {
            return this.severity;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        @NotNull
        public final String getLineContent() {
            return this.lineContent;
        }

        @NotNull
        public final String component1() {
            return this.filePath;
        }

        @NotNull
        public final String component2() {
            return this.severity;
        }

        @NotNull
        public final String component3() {
            return this.description;
        }

        @NotNull
        public final String component4() {
            return this.lineContent;
        }

        @NotNull
        public final AnalysisResult copy(@NotNull String filePath, @NotNull String severity, @NotNull String description, @NotNull String lineContent) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)lineContent, (String)"lineContent");
            return new AnalysisResult(filePath, severity, description, lineContent);
        }

        public static /* synthetic */ AnalysisResult copy$default(AnalysisResult analysisResult, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = analysisResult.filePath;
            }
            if ((n & 2) != 0) {
                string2 = analysisResult.severity;
            }
            if ((n & 4) != 0) {
                string3 = analysisResult.description;
            }
            if ((n & 8) != 0) {
                string4 = analysisResult.lineContent;
            }
            return analysisResult.copy(string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "AnalysisResult(filePath=" + this.filePath + ", severity=" + this.severity + ", description=" + this.description + ", lineContent=" + this.lineContent + ")";
        }

        public int hashCode() {
            int result2 = this.filePath.hashCode();
            result2 = result2 * 31 + this.severity.hashCode();
            result2 = result2 * 31 + this.description.hashCode();
            result2 = result2 * 31 + this.lineContent.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnalysisResult)) {
                return false;
            }
            AnalysisResult analysisResult = (AnalysisResult)other;
            if (!Intrinsics.areEqual((Object)this.filePath, (Object)analysisResult.filePath)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.severity, (Object)analysisResult.severity)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.description, (Object)analysisResult.description)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.lineContent, (Object)analysisResult.lineContent);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AiExcludeService.ExclusionStatus.values().length];
            try {
                nArray[AiExcludeService.ExclusionStatus.NOT_IN_PROJECT_OR_VCS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AiExcludeService.ExclusionStatus.EXCLUDED_BY_AIEXCLUDE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AiExcludeService.ExclusionStatus.EXCLUDED_BY_GITIGNORE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AiExcludeService.ExclusionStatus.ALLOWED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

