/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.permissions;

import com.google.aiplugin.agents.permissions.CompositePermissionRequest;
import com.google.aiplugin.agents.permissions.Permission;
import com.google.aiplugin.agents.permissions.PermissionDecision;
import com.google.aiplugin.agents.permissions.PermissionPersistence;
import com.google.aiplugin.agents.permissions.PermissionRequest;
import com.google.aiplugin.agents.permissions.PermissionRequestKt;
import com.google.aiplugin.agents.permissions.PermissionState;
import com.google.aiplugin.agents.tools.ToolContext;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0016\u0018\u0000 %2\u00020\u0001:\u0001%B)\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u0004H\u0086\u0002J\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0086\u0002J\u001b\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0096\u0002J\u001b\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0096\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u0010\"\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010#\u001a\u00020\u0004H\u0016J\u0006\u0010$\u001a\u00020\u0014R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006&"}, d2={"Lcom/google/aiplugin/agents/permissions/PermissionSettings;", "", "idToState", "", "", "Lcom/google/aiplugin/agents/permissions/PermissionState;", "parent", "<init>", "(Ljava/util/Map;Lcom/google/aiplugin/agents/permissions/PermissionSettings;)V", "getIdToState", "()Ljava/util/Map;", "getParent", "()Lcom/google/aiplugin/agents/permissions/PermissionSettings;", "saveTarget", "getSaveTarget", "get", "permissionId", "permission", "Lcom/google/aiplugin/agents/permissions/Permission;", "set", "", "state", "getDecision", "Lcom/google/aiplugin/agents/permissions/PermissionDecision;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "request", "Lcom/google/aiplugin/agents/permissions/PermissionRequest;", "getMissing", "hashCode", "", "equals", "", "other", "getPermissionState", "toString", "store", "Companion", "aiplugin.agents.agents-core"})
@SourceDebugExtension(value={"SMAP\nPermissionSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PermissionSettings.kt\ncom/google/aiplugin/agents/permissions/PermissionSettings\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,189:1\n774#2:190\n865#2,2:191\n774#2:197\n865#2,2:198\n37#3:193\n36#3,3:194\n37#3:200\n36#3,3:201\n*S KotlinDebug\n*F\n+ 1 PermissionSettings.kt\ncom/google/aiplugin/agents/permissions/PermissionSettings\n*L\n132#1:190\n132#1:191,2\n142#1:197\n142#1:198,2\n136#1:193\n136#1:194,3\n146#1:200\n146#1:201,3\n*E\n"})
public class PermissionSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, PermissionState> idToState;
    @Nullable
    private final PermissionSettings parent;
    @NotNull
    private final PermissionSettings saveTarget;

    public PermissionSettings(@NotNull Map<String, PermissionState> idToState, @Nullable PermissionSettings parent) {
        Intrinsics.checkNotNullParameter(idToState, (String)"idToState");
        this.idToState = idToState;
        this.parent = parent;
        this.saveTarget = this;
    }

    public /* synthetic */ PermissionSettings(Map map2, PermissionSettings permissionSettings, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map2 = new LinkedHashMap();
        }
        if ((n & 2) != 0) {
            permissionSettings = null;
        }
        this(map2, permissionSettings);
    }

    @NotNull
    public final Map<String, PermissionState> getIdToState() {
        return this.idToState;
    }

    @Nullable
    public final PermissionSettings getParent() {
        return this.parent;
    }

    @NotNull
    public PermissionSettings getSaveTarget() {
        return this.saveTarget;
    }

    @Nullable
    public final PermissionState get(@NotNull String permissionId) {
        Intrinsics.checkNotNullParameter((Object)permissionId, (String)"permissionId");
        PermissionState permissionState = this.idToState.get(permissionId);
        if (permissionState == null) {
            PermissionSettings permissionSettings = this.parent;
            permissionState = permissionSettings != null ? permissionSettings.get(permissionId) : null;
        }
        return permissionState;
    }

    @Nullable
    public final PermissionState get(@NotNull Permission permission) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        PermissionState permissionState = this.idToState.get(permission.getId());
        if (permissionState == null) {
            PermissionSettings permissionSettings = this.parent;
            permissionState = permissionSettings != null ? permissionSettings.get(permission.getId()) : null;
        }
        return permissionState;
    }

    public void set(@NotNull String permissionId, @Nullable PermissionState state2) {
        Intrinsics.checkNotNullParameter((Object)permissionId, (String)"permissionId");
        if (state2 == null) {
            this.idToState.remove(permissionId);
        } else {
            this.idToState.put(permissionId, state2);
        }
    }

    public void set(@NotNull Permission permission, @Nullable PermissionState state2) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        if (state2 == null || Intrinsics.areEqual((Object)state2, (Object)permission.getDefaultState())) {
            this.idToState.remove(permission.getId());
        } else {
            this.idToState.put(permission.getId(), state2);
        }
    }

    @NotNull
    public final PermissionDecision getDecision(@NotNull ToolContext context2, @NotNull PermissionRequest request2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        if (request2 instanceof CompositePermissionRequest) {
            if (((CompositePermissionRequest)request2).getAllOf()) {
                for (PermissionRequest nestedRequest : ((CompositePermissionRequest)request2).getRequests()) {
                    PermissionDecision decision = this.getDecision(context2, nestedRequest);
                    if (decision != PermissionDecision.DENIED && decision != PermissionDecision.ASK) continue;
                    return decision;
                }
                return PermissionDecision.APPROVED;
            }
            PermissionDecision result2 = PermissionDecision.ASK;
            for (PermissionRequest nestedRequest : ((CompositePermissionRequest)request2).getRequests()) {
                PermissionDecision decision = this.getDecision(context2, nestedRequest);
                if (decision == PermissionDecision.APPROVED) {
                    result2 = decision;
                    continue;
                }
                if (decision != PermissionDecision.DENIED) continue;
                return decision;
            }
            return result2;
        }
        for (Permission permission : request2.associatedPermissions(context2)) {
            PermissionState state2;
            PermissionDecision match = permission.match(context2, request2, state2 = this.getPermissionState(permission));
            if (match == null || match == PermissionDecision.ASK) continue;
            return match;
        }
        return PermissionDecision.ASK;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final PermissionRequest getMissing(@NotNull ToolContext context2, @NotNull PermissionRequest request2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        if (this.getDecision(context2, request2) == PermissionDecision.APPROVED) {
            return null;
        }
        if (request2 instanceof CompositePermissionRequest) {
            PermissionRequest permissionRequest;
            void $this$filterTo$iv$iv;
            if (((CompositePermissionRequest)request2).getAllOf()) {
                PermissionRequest permissionRequest2;
                void $this$filterTo$iv$iv2;
                PermissionRequest[] $this$filter$iv = (PermissionRequest[])((CompositePermissionRequest)request2).getRequests();
                boolean $i$f$filter = false;
                PermissionRequest[] permissionRequestArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    PermissionRequest it = (PermissionRequest)element$iv$iv;
                    boolean bl = false;
                    if (!(this.getDecision(context2, it) != PermissionDecision.APPROVED)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List remaining = (List)destination$iv$iv;
                if (remaining.size() == 1) {
                    permissionRequest2 = (PermissionRequest)remaining.get(0);
                } else {
                    Collection $this$toTypedArray$iv = remaining;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    $this$filter$iv = thisCollection$iv.toArray(new PermissionRequest[0]);
                    permissionRequest2 = PermissionRequestKt.requestAllOf(Arrays.copyOf($this$filter$iv, $this$filter$iv.length));
                }
                return permissionRequest2;
            }
            Iterable $this$filter$iv = ((CompositePermissionRequest)request2).getRequests();
            boolean $i$f$filter = false;
            Iterable $i$f$toTypedArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PermissionRequest it = (PermissionRequest)element$iv$iv;
                boolean bl = false;
                if (!(this.getDecision(context2, it) != PermissionDecision.APPROVED)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List remaining = (List)destination$iv$iv;
            if (remaining.size() == 1) {
                permissionRequest = (PermissionRequest)remaining.get(0);
            } else {
                Collection $this$toTypedArray$iv = remaining;
                boolean $i$f$toTypedArray2 = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                PermissionRequest[] permissionRequestArray = thisCollection$iv.toArray(new PermissionRequest[0]);
                permissionRequest = PermissionRequestKt.requestAnyOf(Arrays.copyOf(permissionRequestArray, permissionRequestArray.length));
            }
            return permissionRequest;
        }
        return request2;
    }

    public int hashCode() {
        return ((Object)this.idToState).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PermissionSettings)) {
            return false;
        }
        return Intrinsics.areEqual(this.idToState, ((PermissionSettings)other).idToState) && Intrinsics.areEqual((Object)this.parent, (Object)((PermissionSettings)other).parent);
    }

    @NotNull
    public final PermissionState getPermissionState(@NotNull Permission permission) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        PermissionState permissionState = this.get(permission.getId());
        if (permissionState == null) {
            permissionState = permission.getDefaultState();
        }
        return permissionState;
    }

    @NotNull
    public String toString() {
        return this.idToState.toString();
    }

    public final void store() {
        PermissionPersistence.Companion.getInstance().storePermissionSettings(this);
    }

    public PermissionSettings() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lcom/google/aiplugin/agents/permissions/PermissionSettings$Companion;", "", "<init>", "()V", "getPermissionSettings", "Lcom/google/aiplugin/agents/permissions/PermissionSettings;", "project", "Lcom/intellij/openapi/project/Project;", "aiplugin.agents.agents-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PermissionSettings getPermissionSettings(@Nullable Project project2) {
            return PermissionPersistence.loadPermissionSettings$default(PermissionPersistence.Companion.getInstance(), null, 1, null);
        }

        public static /* synthetic */ PermissionSettings getPermissionSettings$default(Companion companion, Project project2, int n, Object object) {
            if ((n & 1) != 0) {
                project2 = null;
            }
            return companion.getPermissionSettings(project2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

