/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.permissions;

import com.google.aiplugin.agents.permissions.FilePermission;
import com.google.aiplugin.agents.permissions.FilePermissionState;
import com.google.aiplugin.agents.permissions.Permission;
import com.google.aiplugin.agents.permissions.PermissionChecker;
import com.google.aiplugin.agents.permissions.PermissionDecision;
import com.google.aiplugin.agents.permissions.PermissionRequest;
import com.google.aiplugin.agents.permissions.PermissionState;
import com.google.aiplugin.agents.permissions.ProjectFilePermission;
import com.google.aiplugin.agents.permissions.SharedPermissions;
import com.google.aiplugin.agents.tools.ToolContext;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0015J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006$"}, d2={"Lcom/google/aiplugin/agents/permissions/FilePermissionRequest;", "Lcom/google/aiplugin/agents/permissions/PermissionRequest;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "file", "Ljava/io/File;", "operation", "Lcom/google/aiplugin/agents/permissions/FilePermission$FileOperation;", "type", "Lcom/google/aiplugin/agents/permissions/FilePermission$FileType;", "<init>", "(Lcom/google/aiplugin/agents/tools/ToolContext;Ljava/io/File;Lcom/google/aiplugin/agents/permissions/FilePermission$FileOperation;Lcom/google/aiplugin/agents/permissions/FilePermission$FileType;)V", "getContext", "()Lcom/google/aiplugin/agents/tools/ToolContext;", "getFile", "()Ljava/io/File;", "getOperation", "()Lcom/google/aiplugin/agents/permissions/FilePermission$FileOperation;", "getType", "()Lcom/google/aiplugin/agents/permissions/FilePermission$FileType;", "displayName", "", "displayPath", "associatedPermissions", "", "Lcom/google/aiplugin/agents/permissions/Permission;", "getApprovalOptions", "Lcom/google/aiplugin/agents/permissions/PermissionRequest$ApprovalOptions;", "suggestFileTypes", "Lcom/google/aiplugin/agents/permissions/FilePermission$FileTypes;", "suggestFilePermission", "fileTypes", "inProject", "", "createRequestRationale", "Companion", "aiplugin.agents.agents-core"})
@SourceDebugExtension(value={"SMAP\nFilePermission.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilePermission.kt\ncom/google/aiplugin/agents/permissions/FilePermissionRequest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,679:1\n1#2:680\n774#3:681\n865#3,2:682\n*S KotlinDebug\n*F\n+ 1 FilePermission.kt\ncom/google/aiplugin/agents/permissions/FilePermissionRequest\n*L\n567#1:681\n567#1:682,2\n*E\n"})
public final class FilePermissionRequest
extends PermissionRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ToolContext context;
    @NotNull
    private final File file;
    @NotNull
    private final FilePermission.FileOperation operation;
    @NotNull
    private final FilePermission.FileType type;

    public FilePermissionRequest(@NotNull ToolContext context2, @NotNull File file, @NotNull FilePermission.FileOperation operation, @NotNull FilePermission.FileType type2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        this.context = context2;
        this.file = file;
        this.operation = operation;
        this.type = type2;
    }

    @NotNull
    public final ToolContext getContext() {
        return this.context;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final FilePermission.FileOperation getOperation() {
        return this.operation;
    }

    @NotNull
    public final FilePermission.FileType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public String displayName() {
        StringBuilder stringBuilder;
        StringBuilder $this$displayName_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$displayName_u24lambda_u240.append("Permission to " + this.operation.getVerb() + " " + this.displayPath());
        return stringBuilder.toString();
    }

    @NotNull
    public final String displayPath() {
        return Companion.getDisplayPath(this.context, this.file);
    }

    @Override
    @NotNull
    public List<Permission> associatedPermissions(@NotNull ToolContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return SharedPermissions.INSTANCE.getALL_FILE_PERMISSIONS();
    }

    @Override
    @NotNull
    public PermissionRequest.ApprovalOptions getApprovalOptions(@NotNull ToolContext context2) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        boolean inProject = ProjectFilePermission.Companion.isInProject(this.file, context2.getProject());
        FilePermission.FileTypes fileTypes = this.suggestFileTypes();
        String string = this.displayName();
        String string2 = "Allow " + this.operation.getGerund() + " " + this.file.getName() + "?";
        String string3 = this.createRequestRationale(context2);
        Object[] objectArray = new Pair[5];
        objectArray[0] = TuplesKt.to((Object)"Allow this time", FilePermissionRequest::getApprovalOptions$lambda$1);
        objectArray[1] = TuplesKt.to((Object)"Reject", FilePermissionRequest::getApprovalOptions$lambda$2);
        if (inProject) {
            pair = TuplesKt.to((Object)("Allow " + this.operation.getGerund() + " files in the project"), () -> FilePermissionRequest.getApprovalOptions$lambda$4(this, fileTypes, context2));
        } else {
            File file = this.file.getParentFile();
            if (file == null) {
                file = File.listRoots()[0];
            }
            File folder = file;
            pair = TuplesKt.to((Object)("Allow " + this.operation.getGerund() + " " + (this.operation == FilePermission.FileOperation.READ ? "files" : fileTypes.displayName()) + " in " + folder), () -> FilePermissionRequest.getApprovalOptions$lambda$7(this, fileTypes, context2, folder));
        }
        objectArray[2] = pair;
        objectArray[3] = TuplesKt.to((Object)("Allow " + this.operation.getGerund() + " all files"), () -> FilePermissionRequest.getApprovalOptions$lambda$9(this, fileTypes, context2));
        objectArray[4] = TuplesKt.to((Object)("Never allow " + this.operation.getGerund() + " files"), () -> FilePermissionRequest.getApprovalOptions$lambda$11(this, fileTypes, inProject, context2));
        return new PermissionRequest.ApprovalOptions(string, string2, string3, CollectionsKt.listOfNotNull((Object[])objectArray));
    }

    private final FilePermission.FileTypes suggestFileTypes() {
        FilePermission.FileTypes fileTypes = new FilePermission.FileTypes(FilePermission.FileType.Companion.getFileType(this.file, this.operation), true);
        if (fileTypes.contains(FilePermission.FileType.SENSITIVE)) {
            return fileTypes;
        }
        return this.operation == FilePermission.FileOperation.READ || this.operation == FilePermission.FileOperation.LIST ? FilePermission.FileTypes.Companion.getNON_SENSITIVE() : fileTypes;
    }

    private final Permission suggestFilePermission(FilePermission.FileTypes fileTypes, boolean inProject) {
        FilePermission.FileOperations operations = switch (WhenMappings.$EnumSwitchMapping$0[this.operation.ordinal()]) {
            case 1, 2 -> FilePermission.FileOperations.Companion.getREAD_AND_LIST();
            case 3, 4 -> FilePermission.FileOperations.Companion.getDELETE_AND_RENAME();
            default -> new FilePermission.FileOperations(this.operation);
        };
        return inProject ? (Permission)ProjectFilePermission.Companion.create$default(ProjectFilePermission.Companion, operations, fileTypes, PermissionState.Companion.getSTATE_ASK(), null, null, 24, null) : (Permission)FilePermission.Companion.create$default(FilePermission.Companion, operations, fileTypes, null, null, 12, null);
    }

    @Override
    @Nullable
    public String createRequestRationale(@NotNull ToolContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return super.createRequestRationale(context2);
    }

    private static final PermissionDecision getApprovalOptions$lambda$1() {
        return PermissionDecision.APPROVED;
    }

    private static final PermissionDecision getApprovalOptions$lambda$2() {
        return PermissionDecision.DENIED;
    }

    private static final PermissionState getApprovalOptions$lambda$4$lambda$3(PermissionState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return PermissionState.Companion.getSTATE_APPROVED();
    }

    private static final PermissionDecision getApprovalOptions$lambda$4(FilePermissionRequest this$0, FilePermission.FileTypes $fileTypes, ToolContext $context) {
        Permission permission = this$0.suggestFilePermission($fileTypes, true);
        PermissionChecker.updateState$default($context.getPermissions(), permission, false, FilePermissionRequest::getApprovalOptions$lambda$4$lambda$3, 2, null);
        return PermissionDecision.APPROVED;
    }

    /*
     * WARNING - void declaration
     */
    private static final PermissionState getApprovalOptions$lambda$7$lambda$6(File $folder, PermissionState state2) {
        PermissionState permissionState;
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        if (state2 instanceof FilePermissionState) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = ((FilePermissionState)state2).getIncluded();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                File file = (File)element$iv$iv;
                boolean bl = false;
                if (!(!FileUtil.isAncestor((File)$folder, (File)file, (boolean)true))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List mergedFolders = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)$folder);
            permissionState = ((FilePermissionState)state2).copy(mergedFolders, ((FilePermissionState)state2).getExcluded());
        } else {
            permissionState = new FilePermissionState(CollectionsKt.listOf((Object)$folder), null, 2, null);
        }
        return permissionState;
    }

    private static final PermissionDecision getApprovalOptions$lambda$7(FilePermissionRequest this$0, FilePermission.FileTypes $fileTypes, ToolContext $context, File $folder) {
        Permission permission = this$0.suggestFilePermission($fileTypes, false);
        PermissionChecker.updateState$default($context.getPermissions(), permission, false, arg_0 -> FilePermissionRequest.getApprovalOptions$lambda$7$lambda$6($folder, arg_0), 2, null);
        return PermissionDecision.APPROVED;
    }

    private static final PermissionState getApprovalOptions$lambda$9$lambda$8(PermissionState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        return state2 instanceof FilePermissionState ? (PermissionState)((FilePermissionState)state2).copy(CollectionsKt.listOf((Object)new File("*")), CollectionsKt.emptyList()) : (PermissionState)new FilePermissionState(CollectionsKt.listOf((Object)new File("*")), CollectionsKt.emptyList());
    }

    private static final PermissionDecision getApprovalOptions$lambda$9(FilePermissionRequest this$0, FilePermission.FileTypes $fileTypes, ToolContext $context) {
        Permission permission = this$0.suggestFilePermission($fileTypes, false);
        PermissionChecker.updateState$default($context.getPermissions(), permission, false, FilePermissionRequest::getApprovalOptions$lambda$9$lambda$8, 2, null);
        return PermissionDecision.APPROVED;
    }

    private static final PermissionState getApprovalOptions$lambda$11$lambda$10(boolean $inProject, PermissionState state2) {
        PermissionState permissionState;
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        if ($inProject) {
            permissionState = PermissionState.Companion.getSTATE_DENIED();
        } else if (state2 instanceof FilePermissionState) {
            FilePermissionState filePermissionState = (FilePermissionState)state2;
            List list = CollectionsKt.listOf((Object)new File("*"));
            permissionState = filePermissionState.copy(CollectionsKt.emptyList(), list);
        } else {
            List list = CollectionsKt.listOf((Object)new File("*"));
            List list2 = CollectionsKt.emptyList();
            permissionState = new FilePermissionState(list2, list);
        }
        return permissionState;
    }

    private static final PermissionDecision getApprovalOptions$lambda$11(FilePermissionRequest this$0, FilePermission.FileTypes $fileTypes, boolean $inProject, ToolContext $context) {
        Permission permission = this$0.suggestFilePermission($fileTypes, $inProject);
        PermissionChecker.updateState$default($context.getPermissions(), permission, false, arg_0 -> FilePermissionRequest.getApprovalOptions$lambda$11$lambda$10($inProject, arg_0), 2, null);
        return PermissionDecision.DENIED;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0010"}, d2={"Lcom/google/aiplugin/agents/permissions/FilePermissionRequest$Companion;", "", "<init>", "()V", "requestRead", "Lcom/google/aiplugin/agents/permissions/FilePermissionRequest;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "file", "Ljava/io/File;", "requestWrite", "request", "operation", "Lcom/google/aiplugin/agents/permissions/FilePermission$FileOperation;", "getDisplayPath", "", "aiplugin.agents.agents-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FilePermissionRequest requestRead(@NotNull ToolContext context2, @NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return this.request(context2, file, FilePermission.FileOperation.READ);
        }

        @NotNull
        public final FilePermissionRequest requestWrite(@NotNull ToolContext context2, @NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return this.request(context2, file, FilePermission.FileOperation.WRITE);
        }

        @NotNull
        public final FilePermissionRequest request(@NotNull ToolContext context2, @NotNull File file, @NotNull FilePermission.FileOperation operation) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
            FilePermission.FileType type2 = FilePermission.FileType.Companion.getFileType(file, operation);
            return new FilePermissionRequest(context2, file, operation, type2);
        }

        @NotNull
        public final String getDisplayPath(@NotNull ToolContext context2, @NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String path2 = file.getPath();
            String projectPath = context2.getProject().getBasePath();
            if (projectPath != null) {
                Intrinsics.checkNotNull((Object)path2);
                if (StringsKt.startsWith$default((String)path2, (String)projectPath, (boolean)false, (int)2, null) && path2.length() > projectPath.length() && (path2.charAt(projectPath.length()) == '/' || path2.charAt(projectPath.length()) == '\\')) {
                    String string = path2.substring(projectPath.length() + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    return string;
                }
            }
            String string = FileUtil.getLocationRelativeToUserHome((String)path2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocationRelativeToUserHome(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FilePermission.FileOperation.values().length];
            try {
                nArray[FilePermission.FileOperation.READ.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilePermission.FileOperation.LIST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilePermission.FileOperation.DELETE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilePermission.FileOperation.RENAME.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

