/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.studiobot.ads.notification;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.AdvertiserNotificationEvent;
import com.android.studio.ml.MetricsReporter;
import com.android.studio.ml.SmlBundle;
import com.android.studio.ml.bot.ResponseMode;
import com.android.tools.idea.studiobot.ads.notification.AdvertisementType;
import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/studiobot/ads/notification/AgentModeAdvertiser;", "Lcom/intellij/openapi/startup/ProjectActivity;", "()V", "notifications", "", "Lcom/intellij/notification/Notification;", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logMetricsEvent", "dialogAction", "Lcom/android/studio/ml/AdvertiserNotificationEvent$DialogAction;", "showAgentModeNotification", "Companion", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
public final class AgentModeAdvertiser
implements ProjectActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<Notification> notifications = new LinkedHashSet();
    public static final int $stable = 8;
    @NotNull
    private static final String IGNORE_AGENT_MODE = "ignore.agent.mode";
    @NotNull
    private static final String STUDIO_BOT_SHOWN = "studio.bot.shown";
    @NotNull
    private static final String NOTIFICATION_GROUP_ID = "Agent Mode";
    @NotNull
    private static final String AGENT_MODE_URL = "https://developer.android.com/studio/gemini/agent-mode/?utm_source=android-studio&utm_medium=embedded_marketing&utm_campaign=notif-cta&utm_content=agent-mode";
    private static final long NOTIFICATION_DELAY_MINUTES = 2L;

    @Nullable
    public Object execute(@NotNull Project project2, @NotNull Continuation<? super Unit> $completion) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return Unit.INSTANCE;
        }
        if (PropertiesComponent.getInstance().getBoolean(STUDIO_BOT_SHOWN)) {
            return Unit.INSTANCE;
        }
        JobScheduler.getScheduler().schedule(() -> AgentModeAdvertiser.execute$lambda$0(this, project2), 2L, TimeUnit.MINUTES);
        MessageBusConnection connection = project2.getMessageBus().connect();
        Disposer.register((Disposable)((Disposable)project2), (Disposable)((Disposable)connection));
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new ToolWindowManagerListener(this, connection){
            final /* synthetic */ AgentModeAdvertiser this$0;
            final /* synthetic */ MessageBusConnection $connection;
            {
                this.this$0 = $receiver;
                this.$connection = $connection;
            }

            public void toolWindowShown(ToolWindow toolWindow) {
                Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
                if (Intrinsics.areEqual((Object)toolWindow.getId(), (Object)"StudioBot")) {
                    PropertiesComponent.getInstance().setValue("studio.bot.shown", true);
                    Iterable $this$forEach$iv = AgentModeAdvertiser.access$getNotifications$p(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Notification it = (Notification)element$iv;
                        boolean bl = false;
                        it.expire();
                    }
                    AgentModeAdvertiser.access$getNotifications$p(this.this$0).clear();
                    this.$connection.disconnect();
                    Disposer.dispose((Disposable)((Disposable)this.$connection));
                }
            }
        });
        return Unit.INSTANCE;
    }

    private final void showAgentModeNotification(Project project2) {
        ToolWindow toolWindow;
        if (PropertiesComponent.getInstance().getBoolean(IGNORE_AGENT_MODE)) {
            return;
        }
        if (PropertiesComponent.getInstance().getBoolean(STUDIO_BOT_SHOWN)) {
            return;
        }
        ToolWindow toolWindow2 = toolWindow = ToolWindowManager.Companion.getInstance(project2).getToolWindow("StudioBot");
        boolean bl = toolWindow2 != null ? toolWindow2.isVisible() : false;
        if (bl) {
            Content content2 = toolWindow.getContentManager().getSelectedContent();
            if (Intrinsics.areEqual((Object)(content2 != null ? content2.getDisplayName() : null), (Object)ResponseMode.Agent.getDisplayName())) {
                PropertiesComponent.getInstance().setValue(STUDIO_BOT_SHOWN, true);
                return;
            }
        }
        Notification notification = new Notification(NotificationGroupManager.getInstance().getNotificationGroup(NOTIFICATION_GROUP_ID).getDisplayId(), SmlBundle.message("sml.studiobot.advertiser.agent.mode.title", new Object[0]), SmlBundle.message("sml.studiobot.advertiser.agent.mode.description", new Object[0]), NotificationType.INFORMATION);
        String string = SmlBundle.message("sml.studiobot.advertiser.agent.mode.open", new Object[0]);
        notification.addAction((AnAction)new NotificationAction(project2, this, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ AgentModeAdvertiser this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e, Notification notification) {
                ToolWindow toolWindow;
                ToolWindow toolWindow2;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                ToolWindow toolWindow3 = toolWindow2 = ToolWindowManager.Companion.getInstance(this.$project).getToolWindow("StudioBot");
                if (toolWindow3 != null) {
                    toolWindow3.show();
                }
                if (Intrinsics.areEqual((toolWindow = toolWindow2) != null && (toolWindow = toolWindow.getContentManager()) != null && (toolWindow = toolWindow.getSelectedContent()) != null ? toolWindow.getDisplayName() : null, (Object)ResponseMode.Chat.getDisplayName())) {
                    toolWindow2.getContentManager().selectPreviousContent();
                }
                PropertiesComponent.getInstance().setValue("studio.bot.shown", true);
                Iterable $this$forEach$iv = AgentModeAdvertiser.access$getNotifications$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Notification it = (Notification)element$iv;
                    boolean bl = false;
                    it.expire();
                }
                AgentModeAdvertiser.access$getNotifications$p(this.this$0).clear();
                AgentModeAdvertiser.access$logMetricsEvent(this.this$0, AdvertiserNotificationEvent.DialogAction.OPEN);
            }
        });
        string = SmlBundle.message("sml.studiobot.advertiser.agent.learn.more", new Object[0]);
        notification.addAction((AnAction)new NotificationAction(this, string){
            final /* synthetic */ AgentModeAdvertiser this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e, Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                BrowserUtil.browse((String)"https://developer.android.com/studio/gemini/agent-mode/?utm_source=android-studio&utm_medium=embedded_marketing&utm_campaign=notif-cta&utm_content=agent-mode");
                AgentModeAdvertiser.access$logMetricsEvent(this.this$0, AdvertiserNotificationEvent.DialogAction.LEARN_MORE);
            }
        });
        string = IdeBundle.message((String)"action.Anonymous.text.do.not.show.again", (Object[])new Object[0]);
        notification.addAction((AnAction)new NotificationAction(this, string){
            final /* synthetic */ AgentModeAdvertiser this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e, Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                PropertiesComponent.getInstance().setValue("ignore.agent.mode", true);
                Iterable $this$forEach$iv = AgentModeAdvertiser.access$getNotifications$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Notification it = (Notification)element$iv;
                    boolean bl = false;
                    it.expire();
                }
                AgentModeAdvertiser.access$getNotifications$p(this.this$0).clear();
                AgentModeAdvertiser.access$logMetricsEvent(this.this$0, AdvertiserNotificationEvent.DialogAction.DO_NOT_SHOW_AGAIN);
            }
        });
        this.logMetricsEvent(AdvertiserNotificationEvent.DialogAction.SHOWN);
        notification.notify(project2);
        this.notifications.add(notification);
    }

    private final void logMetricsEvent(AdvertiserNotificationEvent.DialogAction dialogAction) {
        MetricsReporter.Companion.getInstance().logAdvertiserNotificationEvent(new AdvertiserNotificationEvent(AdvertisementType.AGENT_MODE_AVAILABLE, dialogAction));
    }

    private static final void execute$lambda$0(AgentModeAdvertiser this$0, Project $project) {
        this$0.showAgentModeNotification($project);
    }

    public static final /* synthetic */ Set access$getNotifications$p(AgentModeAdvertiser $this) {
        return $this.notifications;
    }

    public static final /* synthetic */ void access$logMetricsEvent(AgentModeAdvertiser $this, AdvertiserNotificationEvent.DialogAction dialogAction) {
        $this.logMetricsEvent(dialogAction);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/studiobot/ads/notification/AgentModeAdvertiser$Companion;", "", "()V", "AGENT_MODE_URL", "", "IGNORE_AGENT_MODE", "NOTIFICATION_DELAY_MINUTES", "", "NOTIFICATION_GROUP_ID", "STUDIO_BOT_SHOWN", "aiplugin.core.aicore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

