/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.templates.modelproviders;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.SmlBundle;
import com.android.studio.ml.bot.ModelId;
import com.android.studio.ml.templates.modelproviders.ModelProviderSettingsComponent;
import com.android.studio.ml.templates.modelproviders.OpenProviderSettings;
import com.android.studio.ml.templates.modelproviders.data.DataValidator;
import com.android.studio.ml.templates.modelproviders.data.ModelDataStateManager;
import com.android.studio.ml.templates.modelproviders.data.ProviderDetails;
import com.android.studio.ml.templates.modelproviders.data.ProviderType;
import com.android.studio.ml.templates.modelproviders.data.ValidationDetails;
import com.android.studio.ml.templates.modelproviders.data.ValidationError;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableWithId;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 &2\u00020\u00012\u00020\u0002:\u0001&B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0018H\u0016J\r\u0010\u001c\u001a\u00070\u001d\u00a2\u0006\u0002\b\u001eH\u0016J\r\u0010\u001f\u001a\u00070\u001d\u00a2\u0006\u0002\b H\u0016J\r\u0010!\u001a\u00070\u001d\u00a2\u0006\u0002\b H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0016J\b\u0010%\u001a\u00020\u0018H\u0016R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006'"}, d2={"Lcom/android/studio/ml/templates/modelproviders/ModelProviderConfigurable;", "Lcom/intellij/openapi/options/ConfigurableWithId;", "Lcom/intellij/openapi/options/Configurable$VariableProjectAppLevel;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "disposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "openWithProviderSettings", "Lcom/android/studio/ml/templates/modelproviders/OpenProviderSettings;", "getOpenWithProviderSettings$aiplugin_core_aicore", "()Lcom/android/studio/ml/templates/modelproviders/OpenProviderSettings;", "setOpenWithProviderSettings$aiplugin_core_aicore", "(Lcom/android/studio/ml/templates/modelproviders/OpenProviderSettings;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "settingsComponent", "Lcom/android/studio/ml/templates/modelproviders/ModelProviderSettingsComponent;", "getSettingsComponent$aiplugin_core_aicore", "()Lcom/android/studio/ml/templates/modelproviders/ModelProviderSettingsComponent;", "setSettingsComponent$aiplugin_core_aicore", "(Lcom/android/studio/ml/templates/modelproviders/ModelProviderSettingsComponent;)V", "apply", "", "createComponent", "Ljavax/swing/JComponent;", "disposeUIResources", "getDisplayName", "", "Lcom/intellij/openapi/util/NlsContexts$ConfigurableName;", "getHelpTopic", "Lorg/jetbrains/annotations/NonNls;", "getId", "isModified", "", "isProjectLevel", "reset", "Companion", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nModelProviderConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelProviderConfigurable.kt\ncom/android/studio/ml/templates/modelproviders/ModelProviderConfigurable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,147:1\n1#2:148\n40#3,3:149\n40#3,3:152\n40#3,3:155\n*S KotlinDebug\n*F\n+ 1 ModelProviderConfigurable.kt\ncom/android/studio/ml/templates/modelproviders/ModelProviderConfigurable\n*L\n66#1:149,3\n78#1:152,3\n84#1:155,3\n*E\n"})
public final class ModelProviderConfigurable
implements ConfigurableWithId,
Configurable.VariableProjectAppLevel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private ModelProviderSettingsComponent settingsComponent;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private OpenProviderSettings openWithProviderSettings;
    public static final int $stable = 8;

    public ModelProviderConfigurable(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        Disposable disposable = Disposer.newDisposable((String)"ModelProviderConfigurable");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
        this.openWithProviderSettings = OpenProviderSettings.Companion.getNone();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final ModelProviderSettingsComponent getSettingsComponent$aiplugin_core_aicore() {
        return this.settingsComponent;
    }

    public final void setSettingsComponent$aiplugin_core_aicore(@Nullable ModelProviderSettingsComponent modelProviderSettingsComponent) {
        this.settingsComponent = modelProviderSettingsComponent;
    }

    @NotNull
    public final OpenProviderSettings getOpenWithProviderSettings$aiplugin_core_aicore() {
        return this.openWithProviderSettings;
    }

    public final void setOpenWithProviderSettings$aiplugin_core_aicore(@NotNull OpenProviderSettings openProviderSettings) {
        Intrinsics.checkNotNullParameter((Object)openProviderSettings, (String)"<set-?>");
        this.openWithProviderSettings = openProviderSettings;
    }

    @NotNull
    public JComponent createComponent() {
        ModelProviderSettingsComponent modelProviderSettingsComponent;
        ModelProviderSettingsComponent it = modelProviderSettingsComponent = new ModelProviderSettingsComponent(this.disposable, this.project);
        boolean bl = false;
        this.settingsComponent = it;
        return modelProviderSettingsComponent.getPanel();
    }

    public boolean isProjectLevel() {
        return false;
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.disposable);
        this.settingsComponent = null;
    }

    @NotNull
    public String getId() {
        return "templates.modelproviders.configurable";
    }

    @NotNull
    public String getDisplayName() {
        return SmlBundle.message("sml.studiobot.settings.modelProviders.display.name", new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isModified() {
        boolean $i$f$service = false;
        Class<ModelDataStateManager> serviceClass$iv = ModelDataStateManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        List<ProviderDetails> persistedState = ((ModelDataStateManager)((Object)object)).loadState();
        ModelProviderSettingsComponent modelProviderSettingsComponent = this.settingsComponent;
        List<ProviderDetails> uiState = modelProviderSettingsComponent != null ? modelProviderSettingsComponent.getState() : null;
        if (!Intrinsics.areEqual(uiState, persistedState)) return true;
        ModelProviderSettingsComponent modelProviderSettingsComponent2 = this.settingsComponent;
        if (modelProviderSettingsComponent2 == null) return false;
        if (!modelProviderSettingsComponent2.isModified()) return false;
        return true;
    }

    public void apply() {
        block4: {
            Object object = this.settingsComponent;
            if (object != null && (object = ((ModelProviderSettingsComponent)object).getState()) != null) {
                Object it = object;
                boolean bl = false;
                ValidationDetails validationResult = DataValidator.INSTANCE.execute((List<ProviderDetails>)it);
                if (!Intrinsics.areEqual((Object)validationResult.getValidationError(), (Object)ValidationError.NoError.INSTANCE)) {
                    ModelProviderSettingsComponent modelProviderSettingsComponent = this.settingsComponent;
                    if (modelProviderSettingsComponent != null) {
                        modelProviderSettingsComponent.handleValidationErrors(validationResult);
                    }
                    throw new ConfigurationException(validationResult.getValidationError().getErrorMessage());
                }
                boolean $i$f$service = false;
                Class<ModelDataStateManager> serviceClass$iv = ModelDataStateManager.class;
                Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object2 == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                ((ModelDataStateManager)((Object)object2)).saveState((List<ProviderDetails>)it);
            }
            ModelProviderSettingsComponent modelProviderSettingsComponent = this.settingsComponent;
            if (modelProviderSettingsComponent == null) break block4;
            modelProviderSettingsComponent.apply();
        }
    }

    public void reset() {
        boolean $i$f$service = false;
        Class<ModelDataStateManager> serviceClass$iv = ModelDataStateManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        List<ProviderDetails> persistedState = ((ModelDataStateManager)((Object)object)).loadState();
        ModelProviderSettingsComponent modelProviderSettingsComponent = this.settingsComponent;
        if (modelProviderSettingsComponent != null) {
            modelProviderSettingsComponent.reset(persistedState);
        }
        if (!Intrinsics.areEqual((Object)this.openWithProviderSettings, (Object)OpenProviderSettings.Companion.getNone())) {
            OpenProviderSettings openProviderSettings = this.openWithProviderSettings;
            if (openProviderSettings instanceof OpenProviderSettings.WithProviderType) {
                OpenProviderSettings openProviderSettings2 = this.openWithProviderSettings;
                Intrinsics.checkNotNull((Object)openProviderSettings2, (String)"null cannot be cast to non-null type com.android.studio.ml.templates.modelproviders.OpenProviderSettings.WithProviderType");
                ProviderType providerType = ((OpenProviderSettings.WithProviderType)openProviderSettings2).getProviderType();
                this.openWithProviderSettings = OpenProviderSettings.Companion.getNone();
                SwingUtilities.invokeLater(() -> ModelProviderConfigurable.reset$lambda$2(this, providerType));
            } else if (openProviderSettings instanceof OpenProviderSettings.WithModelId) {
                OpenProviderSettings openProviderSettings3 = this.openWithProviderSettings;
                Intrinsics.checkNotNull((Object)openProviderSettings3, (String)"null cannot be cast to non-null type com.android.studio.ml.templates.modelproviders.OpenProviderSettings.WithModelId");
                ModelId modelId = ((OpenProviderSettings.WithModelId)openProviderSettings3).getModelId();
                Object object2 = modelId instanceof ModelId.Custom ? (ModelId.Custom)modelId : null;
                if (object2 == null || (object2 = ((ModelId.Custom)object2).getProviderName()) == null) {
                    ModelId modelId2 = modelId;
                    object2 = modelId2 != null ? modelId2.getProviderClass() : null;
                }
                Object providerDescription = object2;
                this.openWithProviderSettings = OpenProviderSettings.Companion.getNone();
                SwingUtilities.invokeLater(() -> ModelProviderConfigurable.reset$lambda$3(this, (String)providerDescription));
            }
        }
    }

    @NotNull
    public String getHelpTopic() {
        return "org.jetbrains.android.studio/gemini/use-a-local-llm";
    }

    private static final void reset$lambda$2(ModelProviderConfigurable this$0, ProviderType $providerType) {
        block0: {
            ModelProviderSettingsComponent modelProviderSettingsComponent = this$0.settingsComponent;
            if (modelProviderSettingsComponent == null) break block0;
            modelProviderSettingsComponent.selectOrAddProvider($providerType);
        }
    }

    private static final void reset$lambda$3(ModelProviderConfigurable this$0, String $providerDescription) {
        block0: {
            ModelProviderSettingsComponent modelProviderSettingsComponent = this$0.settingsComponent;
            if (modelProviderSettingsComponent == null) break block0;
            modelProviderSettingsComponent.selectProviderWithGivenDescription($providerDescription);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/android/studio/ml/templates/modelproviders/ModelProviderConfigurable$Companion;", "", "()V", "openSettings", "", "project", "Lcom/intellij/openapi/project/Project;", "providerSettings", "Lcom/android/studio/ml/templates/modelproviders/OpenProviderSettings;", "aiplugin.core.aicore"})
    public static final class Companion {
        private Companion() {
        }

        public final void openSettings(@Nullable Project project2, @NotNull OpenProviderSettings providerSettings) {
            Intrinsics.checkNotNullParameter((Object)providerSettings, (String)"providerSettings");
            ShowSettingsUtil.getInstance().showSettingsDialog(project2, ModelProviderConfigurable.class, arg_0 -> Companion.openSettings$lambda$0((Function1)new Function1<ModelProviderConfigurable, Unit>(providerSettings){
                final /* synthetic */ OpenProviderSettings $providerSettings;
                {
                    this.$providerSettings = $providerSettings;
                    super(1);
                }

                public final void invoke(ModelProviderConfigurable it) {
                    it.setOpenWithProviderSettings$aiplugin_core_aicore(this.$providerSettings);
                }
            }, arg_0));
        }

        public static /* synthetic */ void openSettings$default(Companion companion, Project project2, OpenProviderSettings openProviderSettings, int n, Object object) {
            if ((n & 2) != 0) {
                openProviderSettings = OpenProviderSettings.Companion.getNone();
            }
            companion.openSettings(project2, openProviderSettings);
        }

        private static final void openSettings$lambda$0(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

