/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.releasenotes;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.lint.detector.api.TextFormat;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\f\u0010\t\u001a\u00020\u0005*\u00020\u0005H\u0002J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\rJ.\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00162\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\r2\b\b\u0002\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u0019"}, d2={"Lcom/android/studio/ml/releasenotes/ReleaseNotesUtils;", "", "<init>", "()V", "convertToMarkdown", "", "cleanHtml", "stripDacHtmlJunk", "html", "stripAospLinks", "stripMarkdownJunk", "string", "isEscapeChar", "", "", "getWords", "", "s", "requireEscape", "addWords", "", "into", "", "minLength", "", "aiplugin.android"})
@StabilityInferred(parameters=1)
public final class ReleaseNotesUtils {
    @NotNull
    public static final ReleaseNotesUtils INSTANCE = new ReleaseNotesUtils();
    public static final int $stable;

    private ReleaseNotesUtils() {
    }

    @NotNull
    public final String convertToMarkdown(@NotNull String cleanHtml) {
        Intrinsics.checkNotNullParameter((Object)cleanHtml, (String)"cleanHtml");
        return TextFormat.HTML.convertTo(cleanHtml, TextFormat.RAW);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final String stripDacHtmlJunk(@NotNull String html) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        sb = new StringBuilder(html.length());
        lines = StringsKt.lines((CharSequence)html);
        lineno = 0;
        lineCount = lines.size();
        block15: while (lineno < lineCount) {
            block37: {
                if (StringsKt.isBlank((CharSequence)(line = StringsKt.trim((CharSequence)(original = (String)lines.get(lineno++))).toString()))) {
                    sb.append(line).append('\n');
                    continue;
                }
                if (StringsKt.startsWith$default((String)line, (String)"<h3", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)line, (CharSequence)"Version", (boolean)false, (int)2, null)) {
                    if (((CharSequence)sb).length() > 0) {
                        for (curr = sb.length() - 1; curr > 0 && CharsKt.isWhitespace((char)(c = sb.charAt(curr))); --curr) {
                        }
                        while (true) {
                            c = sb.charAt(curr);
                            if (curr == 0 || c == '\n') {
                                if (c == '\n') {
                                    ++curr;
                                }
                                if (!StringsKt.startsWith$default((CharSequence)sb, (CharSequence)"<h3", (int)curr, (boolean)false, (int)4, null)) break;
                                sb.setLength(curr);
                                break;
                            }
                            --curr;
                        }
                    }
                    if (lineno < lineCount - 4 && StringsKt.isBlank((CharSequence)((CharSequence)lines.get(lineno))) && StringsKt.isBlank((CharSequence)((CharSequence)lines.get(lineno + 2))) && StringsKt.startsWith$default((String)((String)lines.get(lineno + 3)), (String)"<p><code translate", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)((CharSequence)lines.get(lineno + 3)), (CharSequence)"Version", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)((CharSequence)lines.get(lineno + 3)), (CharSequence)"contains", (boolean)false, (int)2, null)) {
                        sb.append(line).append('\n');
                        lineno += 4;
                        continue;
                    }
                }
                if (!StringsKt.startsWith$default((String)line, (String)"<p>", (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)line, (String)"</p>", (boolean)false, (int)2, null) || !StringsKt.startsWith$default((String)line, (String)"<p><strong>", (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)line, (String)"</strong></p>", (boolean)false, (int)2, null)) break block37;
                Intrinsics.checkNotNullExpressionValue((Object)StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)line, (String)"<strong>", null, (int)2, null), (String)"</strong>", null, (int)2, null).toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                switch (section.hashCode()) {
                    case -1339468050: {
                        if (!section.equals("dependency changes")) {
                            break;
                        }
                        ** GOTO lbl83
                    }
                    case -1688022459: {
                        if (!section.equals("external contribution")) {
                            break;
                        }
                        ** GOTO lbl83
                    }
                    case 1549677591: {
                        if (!section.equals("known bug")) {
                            break;
                        }
                        ** GOTO lbl83
                    }
                    case -1054354729: {
                        if (!section.equals("bug fixes")) {
                            break;
                        }
                        ** GOTO lbl83
                    }
                    case 300805821: {
                        if (!section.equals("new features")) {
                            break;
                        }
                        ** GOTO lbl83
                    }
                    case 1982125301: {
                        if (!section.equals("dependency updates")) {
                            break;
                        }
                        ** GOTO lbl83
                    }
                    case -74607810: {
                        if (!section.equals("dependency update")) {
                            break;
                        }
                        ** GOTO lbl83
                    }
                    case 795365180: {
                        if (!section.equals("known bugs")) {
                            break;
                        }
                        ** GOTO lbl83
                    }
                    case -1115322531: {
                        if (!section.equals("documentation changes")) {
                            break;
                        }
                        ** GOTO lbl83
                    }
                    case -789088562: {
                        if (!section.equals("external contributions")) {
                            break;
                        }
                        ** GOTO lbl83
                    }
                    case 40678967: {
                        if (!section.equals("known issues")) {
                            break;
                        }
                        ** GOTO lbl83
                    }
                    case 995631910: {
                        if (!section.equals("packaging changes")) {
                            break;
                        }
                        ** GOTO lbl83
                    }
                    case -1107066436: {
                        if (!section.equals("known issue")) break;
lbl83:
                        // 14 sources

                        while (lineno < lineCount) {
                            if (!StringsKt.startsWith$default((String)(peek = (String)lines.get(lineno++)), (String)"<h", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)peek, (String)"<p><strong>", (boolean)false, (int)2, null)) continue;
                            --lineno;
                            continue block15;
                        }
                        continue block15;
                    }
                }
            }
            sb.append(this.stripAospLinks(line)).append('\n');
        }
        v0 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"toString(...)");
        return StringsKt.trimEnd((CharSequence)v0).toString();
    }

    private final String stripAospLinks(String $this$stripAospLinks) {
        if (StringsKt.contains$default((CharSequence)$this$stripAospLinks, (CharSequence)"<a href=", (boolean)false, (int)2, null)) {
            Object l2 = $this$stripAospLinks;
            while (true) {
                int start2;
                int endIndex;
                int index;
                if ((index = StringsKt.indexOf$default((CharSequence)((CharSequence)l2), (String)"<a href=\"https://android-review.googlesource.com", (int)0, (boolean)false, (int)6, null)) == -1) {
                    index = StringsKt.indexOf$default((CharSequence)((CharSequence)l2), (String)"<a href=\"https://issuetracker.google.com", (int)0, (boolean)false, (int)6, null);
                }
                if (index == -1 || (endIndex = StringsKt.indexOf$default((CharSequence)((CharSequence)l2), (String)"</a>", (int)index, (boolean)false, (int)4, null)) == -1) break;
                String string = ((String)l2).substring(0, index);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String string2 = ((String)l2).substring(endIndex + 4);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                l2 = string + string2;
                if (index > 3 && index < ((String)l2).length() - 1 && StringsKt.startsWith$default((String)l2, (String)"(, )", (int)(index - 3), (boolean)false, (int)4, null)) {
                    for (start2 = index - 3; start2 > 0 && CharsKt.isWhitespace((char)((String)l2).charAt(start2 - 1)); --start2) {
                    }
                    String string3 = ((String)l2).substring(0, start2);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    String string4 = ((String)l2).substring(index + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    l2 = string3 + string4;
                    continue;
                }
                if (index <= 1 || index >= ((String)l2).length() - 1 || !StringsKt.startsWith$default((String)l2, (String)"()", (int)(index - 1), (boolean)false, (int)4, null)) continue;
                for (start2 = index - 1; start2 > 0 && CharsKt.isWhitespace((char)((String)l2).charAt(start2 - 1)); --start2) {
                }
                String string5 = ((String)l2).substring(0, start2);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                String string6 = ((String)l2).substring(index + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                l2 = string5 + string6;
            }
            return l2;
        }
        return $this$stripAospLinks;
    }

    @NotNull
    public final String stripMarkdownJunk(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Object[] objectArray = new RegexOption[]{RegexOption.DOT_MATCHES_ALL, RegexOption.MULTILINE, RegexOption.UNIX_LINES};
        Regex pattern = new Regex("(\\s*\\(aosp/\\d+\\))|(\\s*aosp/\\d+)|(\\s*\\(b/\\d+\\))|((, )?\\bb/\\d+)|(\\s*\\([0-9a-fA-F]{6}\\s*\\))|(\\s*Version\\s+[0-9A-Za-z.-]+\\s+contains\\s+these\\s+commits.)|((January|February|March|April|May|June|July|August|September|October|November|December)\\s+\\d{1,2},\\s+\\d{4})", SetsKt.setOf((Object[])objectArray));
        StringBuilder sb = new StringBuilder(string.length());
        int start2 = 0;
        while (pattern.find((CharSequence)string, start2) != null) {
            MatchResult result2;
            IntRange range = result2.getRange();
            int startIndex = range.getStart();
            int endIndex = range.getEndInclusive() + 1;
            String string2 = string.substring(start2, startIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            sb.append(string2);
            start2 = endIndex;
        }
        String string3 = string.substring(start2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        sb.append(string3);
        String string4 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        String s = string4;
        s = CollectionsKt.joinToString$default((Iterable)StringsKt.lines((CharSequence)s), (CharSequence)"\n", null, null, (int)0, null, ReleaseNotesUtils::stripMarkdownJunk$lambda$0, (int)30, null);
        StringsKt.clear((StringBuilder)sb);
        String prev = "";
        boolean prevWasVersion = false;
        for (String line : StringsKt.lines((CharSequence)s)) {
            if (StringsKt.isBlank((CharSequence)line)) continue;
            if (ReleaseNotesUtils.stripMarkdownJunk$isVersionLine(line)) {
                if (!prevWasVersion) {
                    sb.append(prev).append('\n');
                }
                if (!StringsKt.endsWith$default((CharSequence)sb, (CharSequence)"\n\n", (boolean)false, (int)2, null)) {
                    sb.append('\n');
                }
                prevWasVersion = true;
            } else {
                sb.append(prev).append('\n');
                prevWasVersion = false;
            }
            prev = line;
        }
        sb.append(prev);
        String string5 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
        s = string5;
        return ((Object)StringsKt.trim((CharSequence)s)).toString();
    }

    private final boolean isEscapeChar(char $this$isEscapeChar) {
        return $this$isEscapeChar == '\'' || $this$isEscapeChar == '`' || $this$isEscapeChar == '\"';
    }

    @NotNull
    public final Collection<String> getWords(@NotNull String s, boolean requireEscape) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Set words = new LinkedHashSet();
        ReleaseNotesUtils.addWords$default(this, words, s, requireEscape, 0, 8, null);
        return SequencesKt.toList((Sequence)SequencesKt.sorted((Sequence)CollectionsKt.asSequence((Iterable)words)));
    }

    public final void addWords(@NotNull Set<String> into, @NotNull String s, boolean requireEscape, int minLength) {
        Intrinsics.checkNotNullParameter(into, (String)"into");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        int offset2 = 0;
        int length = s.length();
        while (offset2 < length) {
            char d;
            char c;
            if (!Character.isJavaIdentifierPart(c = s.charAt(offset2++)) || requireEscape && (offset2 <= 1 || !this.isEscapeChar(s.charAt(offset2 - 2)))) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(c);
            while (offset2 < length && Character.isLetter(d = s.charAt(offset2++))) {
                sb.append(d);
            }
            if (requireEscape && !this.isEscapeChar(s.charAt(offset2 - 1)) || sb.length() < minLength) continue;
            into.add(sb.toString());
        }
    }

    public static /* synthetic */ void addWords$default(ReleaseNotesUtils releaseNotesUtils, Set set, String string, boolean bl, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = bl ? 0 : 4;
        }
        releaseNotesUtils.addWords(set, string, bl, n);
    }

    private static final CharSequence stripMarkdownJunk$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trimEnd((CharSequence)StringsKt.replace$default((String)StringsKt.replace$default((String)it, (String)"(, )", (String)"", (boolean)false, (int)4, null), (String)", )", (String)"", (boolean)false, (int)4, null))).toString();
    }

    private static final boolean stripMarkdownJunk$isVersionLine(String $this$stripMarkdownJunk_u24isVersionLine) {
        if (StringsKt.startsWith$default((String)$this$stripMarkdownJunk_u24isVersionLine, (String)"Version ", (boolean)false, (int)2, null)) {
            int n = $this$stripMarkdownJunk_u24isVersionLine.length();
            for (int i2 = 8; i2 < n; ++i2) {
                char c = $this$stripMarkdownJunk_u24isVersionLine.charAt(i2);
                if (Character.isLetterOrDigit(c) || c == '-' || c == '.') continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

