/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.npa.logs;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.npa.logs.AgentLoggerImpl;
import com.google.aiplugin.agents.logs.AgentLogger;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/studio/ml/npa/logs/SessionLogger;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "sessionId", "", "baseLogPath", "Ljava/nio/file/Path;", "<init>", "(Ljava/lang/String;Ljava/nio/file/Path;)V", "agentLoggers", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/google/aiplugin/agents/logs/AgentLogger;", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "getAgentLogger", "agentName", "close", "", "aiplugin.android"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSessionLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionLogger.kt\ncom/android/studio/ml/npa/logs/SessionLogger\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n24#2:70\n24#2:73\n1869#3,2:71\n*S KotlinDebug\n*F\n+ 1 SessionLogger.kt\ncom/android/studio/ml/npa/logs/SessionLogger\n*L\n60#1:70\n65#1:73\n63#1:71,2\n*E\n"})
public final class SessionLogger
implements AutoCloseable {
    @NotNull
    private final String sessionId;
    @NotNull
    private final Path baseLogPath;
    @NotNull
    private final ConcurrentHashMap<String, AgentLogger> agentLoggers;
    private final ExecutorService executor;
    public static final int $stable = 8;

    public SessionLogger(@NotNull String sessionId, @NotNull Path baseLogPath) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)baseLogPath, (String)"baseLogPath");
        this.sessionId = sessionId;
        this.baseLogPath = baseLogPath;
        this.agentLoggers = new ConcurrentHashMap();
        this.executor = Executors.newSingleThreadExecutor();
    }

    public /* synthetic */ SessionLogger(String string, Path path2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Path path3 = Paths.get(PathManager.getLogPath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
            path2 = path3;
        }
        this(string, path2);
    }

    @NotNull
    public final AgentLogger getAgentLogger(@NotNull String agentName) {
        Intrinsics.checkNotNullParameter((Object)agentName, (String)"agentName");
        AgentLogger agentLogger = this.agentLoggers.computeIfAbsent(agentName, arg_0 -> SessionLogger.getAgentLogger$lambda$1(arg_0 -> SessionLogger.getAgentLogger$lambda$0(this, agentName, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)agentLogger, (String)"computeIfAbsent(...)");
        return agentLogger;
    }

    @Override
    public void close() {
        try {
            this.executor.shutdown();
            if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                SessionLogger $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(SessionLogger.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Session logger failed to terminate gracefully, some logs may be lost.");
                this.executor.shutdownNow();
            }
            Collection<AgentLogger> collection = this.agentLoggers.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AgentLogger it = (AgentLogger)element$iv;
                boolean bl = false;
                it.close();
            }
        }
        catch (Throwable t) {
            SessionLogger $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SessionLogger.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Error closing session logger: " + t, t);
        }
    }

    private static final AgentLogger getAgentLogger$lambda$0(SessionLogger this$0, String $agentName, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = this$0.sessionId;
        ExecutorService executorService = this$0.executor;
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"executor");
        return new AgentLoggerImpl(string, $agentName, executorService, this$0.baseLogPath);
    }

    private static final AgentLogger getAgentLogger$lambda$1(Function1 $tmp0, Object p0) {
        return (AgentLogger)$tmp0.invoke(p0);
    }
}

