/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.npa.logs;

import com.android.tools.idea.studiobot.mimetype.MimeTypeUtilsKt;
import com.android.tools.idea.studiobot.prompts.Prompt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0003H\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0004H\u0000\u00a8\u0006\u0005"}, d2={"formatAsPrettyString", "", "", "Lcom/android/tools/idea/studiobot/prompts/Prompt$Message;", "Lcom/android/tools/idea/studiobot/prompts/Prompt$Chunk;", "aiplugin.android"})
@SourceDebugExtension(value={"SMAP\nPromptUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PromptUtils.kt\ncom/android/studio/ml/npa/logs/PromptUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1869#2,2:101\n*S KotlinDebug\n*F\n+ 1 PromptUtils.kt\ncom/android/studio/ml/npa/logs/PromptUtilsKt\n*L\n43#1:101,2\n*E\n"})
public final class PromptUtilsKt {
    @NotNull
    public static final String formatAsPrettyString(@NotNull List<? extends Prompt.Message> $this$formatAsPrettyString) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$formatAsPrettyString, (String)"<this>");
        StringBuilder $this$formatAsPrettyString_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = $this$formatAsPrettyString;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            Prompt.Message message = (Prompt.Message)element$iv;
            boolean bl2 = false;
            Prompt.Message message2 = message;
            if (message2 instanceof Prompt.SystemMessage) {
                string = "SYSTEM";
            } else if (message2 instanceof Prompt.ModelMessage) {
                string = "MODEL";
            } else if (message2 instanceof Prompt.UserMessage) {
                string = "USER";
            } else if (message2 instanceof Prompt.ContextMessage) {
                string = "CONTEXT";
            } else if (message2 instanceof Prompt.FunctionCallMessage) {
                string = "FUNCTION_CALL";
            } else if (message2 instanceof Prompt.FunctionResponseMessage) {
                string = "FUNCTION_RESPONSE";
            } else if (message2 instanceof Prompt.RuleMessage) {
                string = "RULE";
            } else if (message2 instanceof Prompt.MemoryMessage) {
                string = "MEMORY";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            $this$formatAsPrettyString_u24lambda_u241.append(string);
            $this$formatAsPrettyString_u24lambda_u241.append("\n");
            $this$formatAsPrettyString_u24lambda_u241.append(PromptUtilsKt.formatAsPrettyString(message));
            $this$formatAsPrettyString_u24lambda_u241.append("\n\n");
        }
        return ((Object)StringsKt.trimEnd((CharSequence)stringBuilder.toString())).toString();
    }

    @NotNull
    public static final String formatAsPrettyString(@NotNull Prompt.Message $this$formatAsPrettyString) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$formatAsPrettyString, (String)"<this>");
        Prompt.Message message = $this$formatAsPrettyString;
        if (message instanceof Prompt.SystemMessage || message instanceof Prompt.UserMessage || message instanceof Prompt.RuleMessage || message instanceof Prompt.MemoryMessage || message instanceof Prompt.ModelMessage) {
            object = CollectionsKt.joinToString$default((Iterable)$this$formatAsPrettyString.getChunks(), (CharSequence)"", null, null, (int)0, null, PromptUtilsKt::formatAsPrettyString$lambda$2, (int)30, null);
        } else if (message instanceof Prompt.ContextMessage) {
            object = CollectionsKt.joinToString$default((Iterable)((Prompt.ContextMessage)$this$formatAsPrettyString).getChunks(), (CharSequence)"", null, null, (int)0, null, PromptUtilsKt::formatAsPrettyString$lambda$3, (int)30, null) + "\n\n" + CollectionsKt.joinToString$default((Iterable)((Prompt.ContextMessage)$this$formatAsPrettyString).getFiles(), (CharSequence)"\n", null, null, (int)0, null, PromptUtilsKt::formatAsPrettyString$lambda$4, (int)30, null);
        } else if (message instanceof Prompt.FunctionCallMessage) {
            String argsString = CollectionsKt.joinToString$default((Iterable)((Prompt.FunctionCallMessage)$this$formatAsPrettyString).getArgs().entrySet(), (CharSequence)", ", null, null, (int)0, null, PromptUtilsKt::formatAsPrettyString$lambda$5, (int)30, null);
            object = ((Prompt.FunctionCallMessage)$this$formatAsPrettyString).getName() + "(" + argsString + ")";
        } else if (message instanceof Prompt.FunctionResponseMessage) {
            object = ((Prompt.FunctionResponseMessage)$this$formatAsPrettyString).getName() + ": " + ((Prompt.FunctionResponseMessage)$this$formatAsPrettyString).getResponse();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
    }

    @NotNull
    public static final String formatAsPrettyString(@NotNull Prompt.Chunk $this$formatAsPrettyString) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$formatAsPrettyString, (String)"<this>");
        Prompt.Chunk chunk = $this$formatAsPrettyString;
        if (chunk instanceof Prompt.TextChunk) {
            object = ((Prompt.TextChunk)$this$formatAsPrettyString).getText();
        } else if (chunk instanceof Prompt.CodeChunk) {
            String string = ((Prompt.CodeChunk)$this$formatAsPrettyString).getLanguage-_TXXkdE();
            if (string == null || (string = MimeTypeUtilsKt.markdownLanguageName-qru2Y28(string)) == null) {
                string = "";
            }
            object = "\n```" + string + "\n" + ((Prompt.CodeChunk)$this$formatAsPrettyString).getText() + "\n```\n";
        } else if (chunk instanceof Prompt.BlobChunk) {
            object = "\nblob(type = " + MimeTypeUtilsKt.displayName-qru2Y28(((Prompt.BlobChunk)$this$formatAsPrettyString).getMimeType-i_3W7CY()) + ", length = " + ((Prompt.BlobChunk)$this$formatAsPrettyString).getData().length + ")\n";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private static final CharSequence formatAsPrettyString$lambda$2(Prompt.Chunk it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return PromptUtilsKt.formatAsPrettyString(it);
    }

    private static final CharSequence formatAsPrettyString$lambda$3(Prompt.Chunk it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return PromptUtilsKt.formatAsPrettyString(it);
    }

    private static final CharSequence formatAsPrettyString$lambda$4(Prompt.ContextFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toString();
    }

    private static final CharSequence formatAsPrettyString$lambda$5(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getKey() + " = " + it.getValue();
    }
}

