/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.journeys.gradle.runconfiguration;

import com.android.studio.ml.SmlBundle;
import com.android.studio.ml.bot.StudioBotFlags;
import com.android.studio.ml.journeys.gradle.runconfiguration.GeminiEnabledTestSuiteRunConfigurationExtension;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.login.GoogleLoginCredentialProvider;
import com.android.tools.idea.studiobot.StudioBot;
import com.android.tools.idea.studiobot.ads.GeminiAdvertiser;
import com.android.tools.idea.studiobot.ads.GeminiFeature;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManagerExtension;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/android/studio/ml/journeys/gradle/runconfiguration/GeminiEnabledTestSuiteTaskManager;", "Lorg/jetbrains/plugins/gradle/service/task/GradleTaskManagerExtension;", "<init>", "()V", "configureTasks", "", "projectPath", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "settings", "Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "getGeminiAccessToken", "project", "Lcom/intellij/openapi/project/Project;", "writeAccessTokenToFile", "Ljava/io/File;", "credential", "aiplugin.android.journeys.gradle"})
@SourceDebugExtension(value={"SMAP\nGeminiEnabledTestSuiteTaskManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeminiEnabledTestSuiteTaskManager.kt\ncom/android/studio/ml/journeys/gradle/runconfiguration/GeminiEnabledTestSuiteTaskManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n24#2:170\n1#3:171\n*S KotlinDebug\n*F\n+ 1 GeminiEnabledTestSuiteTaskManager.kt\ncom/android/studio/ml/journeys/gradle/runconfiguration/GeminiEnabledTestSuiteTaskManager\n*L\n67#1:170\n*E\n"})
public final class GeminiEnabledTestSuiteTaskManager
implements GradleTaskManagerExtension {
    public void configureTasks(@NotNull String projectPath, @NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings, @Nullable GradleVersion gradleVersion) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (!((Boolean)StudioFlags.AGP_TEST_SUITES_ENABLED.get()).booleanValue() || !Intrinsics.areEqual((Object)settings.getUserData(GeminiEnabledTestSuiteRunConfigurationExtension.BooleanOptions.FORWARD_STUDIO_GEMINI_ACCESS_TOKEN.getUserDataKey()), (Object)true)) {
            return;
        }
        if (settings.getEnv().get("GEMINI_ACCESS_TOKEN_PATH") != null) {
            GeminiEnabledTestSuiteTaskManager $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(GeminiEnabledTestSuiteTaskManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("The GEMINI_ACCESS_TOKEN_PATH environment variable is already set. Skipping adding it.");
        } else {
            Project project2 = id.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            Project project3 = project2;
            String string = this.getGeminiAccessToken(project3);
            if (string == null) {
                throw new ProcessCanceledException();
            }
            String accessToken = string;
            File accessTokenFile = this.writeAccessTokenToFile(accessToken);
            settings.addEnvironmentVariable("GEMINI_ACCESS_TOKEN_PATH", accessTokenFile.getAbsolutePath());
        }
    }

    private final String getGeminiAccessToken(Project project2) {
        if (StudioBot.Companion.getInstance().isAvailable()) {
            return GoogleLoginCredentialProvider.Companion.getGeminiAccessTokenAsJson();
        }
        if (!StudioBotFlags.Companion.getInstance().isAdvertiserEnabled()) {
            ApplicationManager.getApplication().invokeLater(() -> GeminiEnabledTestSuiteTaskManager.getGeminiAccessToken$lambda$0(project2));
        } else {
            GeminiAdvertiser.DialogInfo dialogInfo = new GeminiAdvertiser.DialogInfo(SmlBundle.INSTANCE.getMessage("sml.studiobot.advertiser.description.journeys", new Object[0]), null, null, 6, null);
            ApplicationManager.getApplication().invokeLater(() -> GeminiEnabledTestSuiteTaskManager.getGeminiAccessToken$lambda$1(project2, dialogInfo));
        }
        return null;
    }

    private final File writeAccessTokenToFile(String credential) {
        Object object;
        Object object2;
        String[] stringArray = new String[]{".AndroidStudioTestSuiteRunConfiguration"};
        Path secureDir = Path.of(System.getProperty("user.home"), stringArray);
        try {
            object2 = new PosixFilePermission[]{PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE};
            Set dirPerms = SetsKt.setOf((Object[])object2);
            object2 = new FileAttribute[]{PosixFilePermissions.asFileAttribute(dirPerms)};
            Files.createDirectories(secureDir, object2);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Files.createDirectories(secureDir, new FileAttribute[0]);
        }
        try {
            object = new PosixFilePermission[]{PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE};
            Set filePerms = SetsKt.setOf((Object[])object);
            FileAttribute<Set<PosixFilePermission>> attributes = PosixFilePermissions.asFileAttribute(filePerms);
            FileAttribute[] fileAttributeArray = new FileAttribute[]{attributes};
            object2 = Files.createTempFile(secureDir, "access_token", ".json", fileAttributeArray);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            object2 = Files.createTempFile(secureDir, "access_token", ".json", new FileAttribute[0]);
        }
        PosixFilePermission[] tempFilePath = object2;
        Files.writeString((Path)tempFilePath, (CharSequence)credential, new OpenOption[0]);
        Object $this$writeAccessTokenToFile_u24lambda_u242 = object = tempFilePath.toFile();
        boolean bl = false;
        ((File)$this$writeAccessTokenToFile_u24lambda_u242).deleteOnExit();
        Object object3 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"apply(...)");
        return object3;
    }

    private static final void getGeminiAccessToken$lambda$0(Project $project) {
        ToolWindow toolWindow;
        String[] stringArray = new String[]{Messages.getCancelButton(), "Enable Gemini"};
        String[] options = stringArray;
        int result2 = Messages.showIdeaMessageDialog(null, (String)"To use Journeys with Gemini, you must enable Gemini in Android Studio by following the prompts in the Gemini tool window.", (String)"Enable Gemini", (String[])options, (int)1, (Icon)AllIcons.General.Warning, null);
        if (result2 == 1 && (toolWindow = ToolWindowManager.Companion.getInstance($project).getToolWindow("StudioBot")) != null) {
            toolWindow.show();
        }
    }

    private static final void getGeminiAccessToken$lambda$1(Project $project, GeminiAdvertiser.DialogInfo $dialogInfo) {
        GeminiAdvertiser.Companion.advertiseAndSignIn($project, GeminiFeature.JOURNEYS, $dialogInfo);
    }
}

