/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.gradle.buildsystem;

import com.android.studio.ml.gradle.buildsystem.GetTopLevelSubProjectsKt;
import com.android.studio.ml.gradle.buildsystem.GradleTool;
import com.android.studio.ml.gradle.buildsystem.GradleToolsUtilsKt;
import com.android.studio.ml.gradle.buildsystem.ProjectData;
import com.android.studio.ml.icons.AndroidToolIcon;
import com.google.aiplugin.agents.NoArgs;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolArgument;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KParameter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ToolDescription(summary="Returns the main artifacts of the top level sub-projects", instructions="Top level sub-projects means that they are not consumed by other projects. This includes apps and libraries with no consumers.", examples={})
@ToolResult(description="Returns a JSON array of objects containing the following information:\n- subproject_path: Gradle path of the sub-project\n- artifact_name: Name of the artifact in this sub-project\nReturns an empty array ([]) if no artifacts are found.")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0002\u0015\u0016B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/android/studio/ml/gradle/buildsystem/GetTopLevelSubProjects;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/google/aiplugin/agents/NoArgs;", "Lcom/android/studio/ml/gradle/buildsystem/GradleTool;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "icon", "Lcom/android/studio/ml/icons/AndroidToolIcon;", "getIcon", "()Lcom/android/studio/ml/icons/AndroidToolIcon;", "getRunningDisplayText", "args", "getCompletedDisplayText", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "Companion", "Handler", "aiplugin.android.gradle"})
public final class GetTopLevelSubProjects
implements Tool<NoArgs>,
GradleTool<NoArgs> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AndroidToolIcon icon = AndroidToolIcon.GRADLE_SUBPROJECT;
    @NotNull
    public static final String NAME = "get_top_level_sub_projects";

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    @NotNull
    public AndroidToolIcon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public String getRunningDisplayText(@NotNull NoArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Finding top level sub-project artifacts";
    }

    @Override
    @NotNull
    public String getCompletedDisplayText(@NotNull NoArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Found top level sub-project artifacts";
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull NoArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new Handler(context2, args);
    }

    @Override
    @Nullable
    public String getStatusMessage() {
        return Tool.super.getStatusMessage();
    }

    @Override
    @Nullable
    public Map<KParameter, ToolArgument> getToolArguments() {
        return Tool.super.getToolArguments();
    }

    @Override
    @NotNull
    public ToolDescription getToolDescription() {
        return Tool.super.getToolDescription();
    }

    @Override
    @Nullable
    public ToolResult getToolResult() {
        return Tool.super.getToolResult();
    }

    @Override
    @Nullable
    public ToolHandler restoreHandler(@NotNull Project project2, @NotNull NoArgs args, @NotNull Response response2) {
        return Tool.super.restoreHandler(project2, args, response2);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tool.super.getDescription();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/studio/ml/gradle/buildsystem/GetTopLevelSubProjects$Companion;", "", "<init>", "()V", "NAME", "", "aiplugin.android.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/studio/ml/gradle/buildsystem/GetTopLevelSubProjects$Handler;", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "Lcom/google/aiplugin/agents/NoArgs;", "<init>", "(Lcom/google/aiplugin/agents/tools/ToolContext;Lcom/google/aiplugin/agents/NoArgs;)V", "handle", "Lcom/google/aiplugin/agents/Response;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "aiplugin.android.gradle"})
    private static final class Handler
    implements ToolHandler {
        @NotNull
        private final ToolContext context;
        @NotNull
        private final NoArgs args;

        public Handler(@NotNull ToolContext context2, @NotNull NoArgs args) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.context = context2;
            this.args = args;
        }

        @Override
        @Nullable
        public Object handle(@NotNull Continuation<? super Response> $completion) {
            return CoroutinesKt.readAction(() -> Handler.handle$lambda$1(this), $completion);
        }

        private static final Response handle$lambda$1$lambda$0(Project $project) {
            Map<String, ProjectData> modulesByGradlePath = GradleToolsUtilsKt.buildModulesMap($project);
            if (modulesByGradlePath.isEmpty()) {
                return GradleToolsUtilsKt.errorNoModules();
            }
            List matchingArtifacts = GetTopLevelSubProjectsKt.topLevelArtifacts$default($project, modulesByGradlePath, null, 4, null);
            String resultJson = GradleToolsUtilsKt.createGson().toJson((Object)matchingArtifacts);
            return new Response(resultJson, null, null, null, null, 30, null);
        }

        private static final Response handle$lambda$1(Handler this$0) {
            Project project2 = this$0.context.getProject();
            return GradleToolsUtilsKt.handleCheckingSyncState(project2, (Function0<Response>)((Function0)() -> Handler.handle$lambda$1$lambda$0(project2)));
        }
    }
}

