/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.gradle.buildsystem;

import com.android.studio.ml.gradle.buildsystem.ArtifactCoordinate;
import com.android.studio.ml.gradle.buildsystem.GetTopLevelSubProjectsKt;
import com.android.studio.ml.gradle.buildsystem.GradleTool;
import com.android.studio.ml.gradle.buildsystem.GradleToolsUtilsKt;
import com.android.studio.ml.gradle.buildsystem.ProjectData;
import com.android.studio.ml.gradle.buildsystem.SourceSetModuleData;
import com.android.studio.ml.icons.AndroidToolIcon;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolArgument;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.graph.Graph;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KParameter;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ToolDescription(summary="Returns the top-level artifacts consuming the given artifact", instructions="The arguments are generally obtained via get_gradle_artifact_from_file.", examples={})
@ToolResult(description="Returns a JSON array of objects, each representing an artifact and containing the following information:\n- subproject_path: Gradle path of the sub-project\n- artifact_name: Name of the artifact in this sub-project\nReturns an empty array ([]) if no artifacts are found.")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0002\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/android/studio/ml/gradle/buildsystem/GetArtifactConsumers;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/android/studio/ml/gradle/buildsystem/ArtifactCoordinate;", "Lcom/android/studio/ml/gradle/buildsystem/GradleTool;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "getRunningDisplayText", "args", "getCompletedDisplayText", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "Companion", "Handler", "aiplugin.android.gradle"})
public final class GetArtifactConsumers
implements Tool<ArtifactCoordinate>,
GradleTool<ArtifactCoordinate> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "get_artifact_consumers";

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    @NotNull
    public String getRunningDisplayText(@NotNull ArtifactCoordinate args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Finding consumers for " + args.getSubproject_path() + ":" + args.getArtifact_name();
    }

    @Override
    @NotNull
    public String getCompletedDisplayText(@NotNull ArtifactCoordinate args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Found consumers for " + args.getSubproject_path() + ":" + args.getArtifact_name();
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull ArtifactCoordinate args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new Handler(context2, args);
    }

    @Override
    @Nullable
    public String getStatusMessage() {
        return Tool.super.getStatusMessage();
    }

    @Override
    @Nullable
    public Map<KParameter, ToolArgument> getToolArguments() {
        return Tool.super.getToolArguments();
    }

    @Override
    @NotNull
    public ToolDescription getToolDescription() {
        return Tool.super.getToolDescription();
    }

    @Override
    @Nullable
    public ToolResult getToolResult() {
        return Tool.super.getToolResult();
    }

    @Override
    @Nullable
    public ToolHandler restoreHandler(@NotNull Project project2, @NotNull ArtifactCoordinate args, @NotNull Response response2) {
        return Tool.super.restoreHandler(project2, args, response2);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tool.super.getDescription();
    }

    @Override
    @NotNull
    public AndroidToolIcon getIcon() {
        return GradleTool.super.getIcon();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/studio/ml/gradle/buildsystem/GetArtifactConsumers$Companion;", "", "<init>", "()V", "NAME", "", "aiplugin.android.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/studio/ml/gradle/buildsystem/GetArtifactConsumers$Handler;", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "Lcom/android/studio/ml/gradle/buildsystem/ArtifactCoordinate;", "<init>", "(Lcom/google/aiplugin/agents/tools/ToolContext;Lcom/android/studio/ml/gradle/buildsystem/ArtifactCoordinate;)V", "handle", "Lcom/google/aiplugin/agents/Response;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "aiplugin.android.gradle"})
    @SourceDebugExtension(value={"SMAP\nGetArtifactConsumers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GetArtifactConsumers.kt\ncom/android/studio/ml/gradle/buildsystem/GetArtifactConsumers$Handler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,136:1\n295#2,2:137\n1056#2:141\n1321#3,2:139\n*S KotlinDebug\n*F\n+ 1 GetArtifactConsumers.kt\ncom/android/studio/ml/gradle/buildsystem/GetArtifactConsumers$Handler\n*L\n95#1:137,2\n128#1:141\n114#1:139,2\n*E\n"})
    private static final class Handler
    implements ToolHandler {
        @NotNull
        private final ToolContext context;
        @NotNull
        private final ArtifactCoordinate args;

        public Handler(@NotNull ToolContext context2, @NotNull ArtifactCoordinate args) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.context = context2;
            this.args = args;
        }

        @Override
        @Nullable
        public Object handle(@NotNull Continuation<? super Response> $completion) {
            return CoroutinesKt.readAction(() -> Handler.handle$lambda$5(this), $completion);
        }

        private static final boolean handle$lambda$5$lambda$4$lambda$2(Set $allDependentModules, SourceSetModuleData it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return $allDependentModules.contains(it.getModule());
        }

        /*
         * WARNING - void declaration
         */
        private static final Response handle$lambda$5$lambda$4(Project $project, Handler this$0) {
            void $this$sortedBy$iv;
            Module requestedModule;
            Object v1;
            Object element$iv2;
            Map<String, ProjectData> modulesByGradlePath;
            block6: {
                void $this$firstOrNull$iv;
                modulesByGradlePath = GradleToolsUtilsKt.buildModulesMap($project);
                if (modulesByGradlePath.isEmpty()) {
                    return GradleToolsUtilsKt.errorNoModules();
                }
                ProjectData projectData = modulesByGradlePath.get(this$0.args.getSubproject_path());
                if (projectData == null) {
                    return GradleToolsUtilsKt.errorModuleNotFound(this$0.args.getSubproject_path());
                }
                ProjectData projectData2 = projectData;
                Iterable iterable = projectData2.getSourceSetModules();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    SourceSetModuleData it = (SourceSetModuleData)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getSourceSetName(), (Object)this$0.args.getArtifact_name())) continue;
                    v1 = element$iv2;
                    break block6;
                }
                v1 = null;
            }
            SourceSetModuleData sourceSetModuleData = v1;
            Module module2 = requestedModule = sourceSetModuleData != null ? sourceSetModuleData.getModule() : null;
            if (requestedModule == null) {
                return GradleToolsUtilsKt.errorArtifactNotFoundInProject(this$0.args.getArtifact_name(), this$0.args.getSubproject_path());
            }
            ModuleManager moduleManager = ModuleManager.Companion.getInstance($project);
            Graph moduleGraph = moduleManager.moduleGraph(true);
            Set allDependentModules = new LinkedHashSet();
            element$iv2 = new Module[]{requestedModule};
            Set modulesSeen = SetsKt.mutableSetOf(element$iv2);
            ArrayDeque queue = new ArrayDeque((Collection)modulesSeen);
            while (!((Collection)queue).isEmpty()) {
                Module current2 = (Module)queue.removeFirst();
                Iterator iterator = moduleGraph.getOut((Object)current2);
                Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"getOut(...)");
                Sequence $this$forEach$iv = SequencesKt.asSequence((Iterator)iterator);
                boolean $i$f$forEach = false;
                for (Object element$iv3 : $this$forEach$iv) {
                    Module it = (Module)element$iv3;
                    boolean bl = false;
                    if (modulesSeen.contains(it)) continue;
                    Intrinsics.checkNotNull((Object)it);
                    queue.add((Object)it);
                    modulesSeen.add(it);
                }
                allDependentModules.add(current2);
            }
            allDependentModules.remove(requestedModule);
            Iterable $this$forEach$iv = GetTopLevelSubProjectsKt.topLevelArtifacts($project, modulesByGradlePath, (Function1<? super SourceSetModuleData, Boolean>)((Function1)arg_0 -> Handler.handle$lambda$5$lambda$4$lambda$2(allDependentModules, arg_0)));
            boolean $i$f$sortedBy = false;
            List matchingArtifacts = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ArtifactCoordinate it = (ArtifactCoordinate)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)(it.getSubproject_path() + it.getArtifact_name()));
                    it = (ArtifactCoordinate)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)(it.getSubproject_path() + it.getArtifact_name()))));
                }
            });
            return new Response(GradleToolsUtilsKt.createGson().toJson((Object)matchingArtifacts), null, null, null, null, 30, null);
        }

        private static final Response handle$lambda$5(Handler this$0) {
            Project project2 = this$0.context.getProject();
            return GradleToolsUtilsKt.handleCheckingSyncState(project2, (Function0<Response>)((Function0)() -> Handler.handle$lambda$5$lambda$4(project2, this$0)));
        }
    }
}

