/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.gradle;

import com.android.studio.ml.gradle.VersionLookupArgs;
import com.android.studio.ml.gradle.VersionLookupHandlerImpl;
import com.google.aiplugin.agents.BasicToolIcon;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@ToolDescription(summary="Looks up the latest available versions on the internet of maven artifacts, Android versions, and more.", examples={"version_lookup(\"androidx.window:window\")"})
@ToolResult(description="A JSON document mapping from the artifact identifiers back to the current stable and preview versions")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/android/studio/ml/gradle/VersionLookupTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/android/studio/ml/gradle/VersionLookupArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "icon", "Lcom/google/aiplugin/agents/BasicToolIcon;", "getIcon", "()Lcom/google/aiplugin/agents/BasicToolIcon;", "getRunningDisplayText", "args", "getCompletedDisplayText", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "aiplugin.android.gradle"})
public class VersionLookupTool
implements Tool<VersionLookupArgs> {
    @NotNull
    private final String name;
    @NotNull
    private final BasicToolIcon icon = BasicToolIcon.WEB;

    public VersionLookupTool() {
        this.name = "version_lookup";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public BasicToolIcon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public String getRunningDisplayText(@NotNull VersionLookupArgs args) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        List<String> artifacts = args.getArtifacts();
        if (artifacts.size() == 1) {
            if (Intrinsics.areEqual((Object)artifacts.get(0), (Object)"--help")) {
                return "Querying available version lookup types";
            }
            object = artifacts.get(0);
        } else {
            object = artifacts.size() <= 4 ? CollectionsKt.joinToString$default((Iterable)artifacts, null, null, null, (int)0, null, VersionLookupTool::getRunningDisplayText$lambda$0, (int)31, null) : artifacts.get(0) + " and " + (artifacts.size() - 1) + " others";
        }
        String list = object;
        return "Looking up the latest versions of " + list;
    }

    @Override
    @NotNull
    public String getCompletedDisplayText(@NotNull VersionLookupArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)this.getRunningDisplayText(args), (String)"Looking", (String)"Looked", (boolean)false, (int)4, null), (String)"Querying", (String)"Queried", (boolean)false, (int)4, null);
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull VersionLookupArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new VersionLookupHandlerImpl(context2, args);
    }

    private static final CharSequence getRunningDisplayText$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.substringAfterLast$default((String)it, (String)":", null, (int)2, null);
    }
}

