/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.device;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.adblib.ConnectedDevice;
import com.android.adblib.ConnectedDeviceKt;
import com.android.sdklib.deviceprovisioner.DeviceActionException;
import com.android.sdklib.deviceprovisioner.DeviceHandle;
import com.android.sdklib.deviceprovisioner.DeviceState;
import com.android.sdklib.deviceprovisioner.DeviceStateKt;
import com.android.sdklib.deviceprovisioner.DeviceTemplate;
import com.android.sdklib.deviceprovisioner.TemplateActivationAction;
import com.android.studio.ml.device.ConnectDeviceArgs;
import com.android.studio.ml.device.ConnectDeviceTool;
import com.android.studio.ml.device.DeviceIdStringsKt;
import com.android.studio.ml.icons.AndroidToolIcon;
import com.android.tools.idea.deviceprovisioner.DeviceProvisionerService;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolArgument;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KParameter;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ToolDescription(summary="Connects to a device", description="Attempts to make a device available for use, e.g. by starting an emulator or reserving a remote device", examples={})
@ToolResult(description="The ADB serial number of the connected device if successful.")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/android/studio/ml/device/ConnectDeviceTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/android/studio/ml/device/ConnectDeviceArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "icon", "Lcom/android/studio/ml/icons/AndroidToolIcon;", "getIcon", "()Lcom/android/studio/ml/icons/AndroidToolIcon;", "getRunningDisplayText", "args", "getCompletedDisplayText", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "aiplugin.android"})
@StabilityInferred(parameters=1)
public final class ConnectDeviceTool
implements Tool<ConnectDeviceArgs> {
    @NotNull
    public static final ConnectDeviceTool INSTANCE = new ConnectDeviceTool();
    @NotNull
    private static final String name = "connect_device";
    @NotNull
    private static final AndroidToolIcon icon = AndroidToolIcon.CONNECTION;
    public static final int $stable;

    private ConnectDeviceTool() {
    }

    @Override
    @NotNull
    public String getName() {
        return name;
    }

    @Override
    @NotNull
    public AndroidToolIcon getIcon() {
        return icon;
    }

    @Override
    @NotNull
    public String getRunningDisplayText(@NotNull ConnectDeviceArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Connecting to device with id: " + args.getId();
    }

    @Override
    @NotNull
    public String getCompletedDisplayText(@NotNull ConnectDeviceArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Connected to device with id: " + args.getId();
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull ConnectDeviceArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new ToolHandler(context2, args){
            final /* synthetic */ ToolContext $context;
            final /* synthetic */ ConnectDeviceArgs $args;
            {
                this.$context = $context;
                this.$args = $args;
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public Object handle(Continuation<? super Response> $completion) {
                block25: {
                    if (!($completion instanceof createHandler.handle.1)) ** GOTO lbl-1000
                    var14_2 = $completion;
                    if ((var14_2.label & -2147483648) != 0) {
                        var14_2.label -= -2147483648;
                    } else lbl-1000:
                    // 2 sources

                    {
                        $continuation = new ContinuationImpl(this, $completion){
                            Object L$0;
                            /* synthetic */ Object result;
                            final /* synthetic */ createHandler.1 this$0;
                            int label;
                            {
                                this.this$0 = this$0;
                                super($completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                this.result = $result;
                                this.label |= Integer.MIN_VALUE;
                                return this.this$0.handle((Continuation<? super Response>)((Continuation)this));
                            }
                        };
                    }
                    $result = $continuation.result;
                    var15_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch ($continuation.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            $this$service$iv = (ComponentManager)this.$context.getProject();
                            $i$f$service = false;
                            serviceClass$iv = DeviceProvisionerService.class;
                            v0 = $this$service$iv.getService(serviceClass$iv);
                            if (v0 == null) {
                                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                            }
                            deviceProvisioner = ((DeviceProvisionerService)v0).getDeviceProvisioner();
                            v1 = DeviceIdStringsKt.parseIdString(this.$args.getId());
                            if (v1 == null) {
                                return new Response(null, "Invalid device ID", null, null, null, 29, null);
                            }
                            id = v1;
                            if (!id.isTemplate()) break;
                            var8_10 = (Iterable)deviceProvisioner.getTemplates().getValue();
                            for (T var10_14 : var8_10) {
                                it = (DeviceTemplate)var10_14;
                                $i$a$-find-ConnectDeviceTool$createHandler$1$handle$template$1 = false;
                                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                                v2 = var10_14;
                                ** GOTO lbl33
                            }
                            v2 = null;
lbl33:
                            // 2 sources

                            v3 = v2;
                            if (v3 == null) {
                                return new Response(null, "Unknown device ID", null, null, null, 29, null);
                            }
                            template = v3;
                            $continuation.label = 1;
                            v4 = TemplateActivationAction.activate$default((TemplateActivationAction)template.getActivationAction(), null, (Continuation)$continuation, (int)1, null);
                            if (v4 == var15_4) {
                                return var15_4;
                            }
                            ** GOTO lbl45
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v4 = $result;
lbl45:
                            // 2 sources

                            handle = (DeviceHandle)v4;
                            ** GOTO lbl92
                        }
                    }
                    var7_19 = (Iterable)deviceProvisioner.getDevices().getValue();
                    for (T var9_13 : var7_19) {
                        it = (DeviceHandle)var9_13;
                        $i$a$-find-ConnectDeviceTool$createHandler$1$handle$2 = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                        v5 = var9_13;
                        break block25;
                    }
                    v5 = null;
                }
                v6 = v5;
                if (v6 == null) {
                    return new Response(null, "Unknown device ID", null, null, null, 29, null);
                }
                handle = v6;
                $continuation.L$0 = handle;
                $continuation.label = 2;
                v7 = FlowKt.collect((Flow)FlowKt.takeWhile((Flow)((Flow)handle.getStateFlow()), (Function2)((Function2)new Function2<DeviceState, Continuation<? super Boolean>, Object>(null){
                    int label;
                    /* synthetic */ Object L$0;

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                DeviceState it = (DeviceState)this.L$0;
                                return Boxing.boxBoolean((boolean)it.isTransitioning());
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(DeviceState p1, Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                })), (Continuation)$continuation);
                if (v7 == var15_4) {
                    return var15_4;
                }
                ** GOTO lbl70
                {
                    case 2: {
                        handle = (DeviceHandle)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = $result;
lbl70:
                        // 2 sources

                        if (!(handle.getState() instanceof DeviceState.Connected)) {
                            v8 = handle.getActivationAction();
                            if (v8 == null) {
                                return new Response(null, "Unable to activate device", null, null, null, 29, null);
                            }
                            activationAction = v8;
                            $continuation.L$0 = handle;
                            $continuation.label = 3;
                            v9 = activationAction.activate((Continuation)$continuation);
                            ** if (v9 != var15_4) goto lbl82
lbl81:
                            // 1 sources

                            return var15_4;
                        }
lbl82:
                        // 3 sources

                        ** GOTO lbl92
                    }
                    case 3: {
                        handle = (DeviceHandle)$continuation.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v9 = $result;
                        }
                        catch (DeviceActionException e) {
                            return new Response(null, e.getMessage(), null, null, null, 29, null);
                        }
lbl92:
                        // 3 sources

                        $continuation.L$0 = handle;
                        $continuation.label = 4;
                        v10 = DeviceStateKt.awaitReady((DeviceHandle)handle, (Continuation)$continuation);
                        if (v10 == var15_4) {
                            return var15_4;
                        }
                        ** GOTO lbl102
                    }
                    case 4: {
                        handle = (DeviceHandle)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v10 = $result;
lbl102:
                        // 2 sources

                        if ((v11 /* !! */  = handle.getState().getConnectedDevice()) == null || (v11 /* !! */  = ConnectedDeviceKt.getSerialNumber((ConnectedDevice)v11 /* !! */ )) == null) {
                            return new Response(null, "Device suddenly disconnected", null, null, null, 29, null);
                        }
                        serialNumber /* !! */  = v11 /* !! */ ;
                        properties = handle.getState().getProperties();
                        deviceClass = Intrinsics.areEqual((Object)properties.isVirtual(), (Object)Boxing.boxBoolean((boolean)true)) != false ? "emulator" : "device";
                        return new Response("Connected to " + deviceClass + " \"" + properties.getTitle() + "\" with serial number: " + (String)serialNumber /* !! */ , null, null, null, null, 30, null);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
        };
    }

    @Override
    @Nullable
    public String getStatusMessage() {
        return Tool.super.getStatusMessage();
    }

    @Override
    @Nullable
    public Map<KParameter, ToolArgument> getToolArguments() {
        return Tool.super.getToolArguments();
    }

    @Override
    @NotNull
    public ToolDescription getToolDescription() {
        return Tool.super.getToolDescription();
    }

    @Override
    @Nullable
    public ToolResult getToolResult() {
        return Tool.super.getToolResult();
    }

    @Override
    @Nullable
    public ToolHandler restoreHandler(@NotNull Project project2, @NotNull ConnectDeviceArgs args, @NotNull Response response2) {
        return Tool.super.restoreHandler(project2, args, response2);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Tool.super.getDescription();
    }
}

