/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.parse;

import com.android.studio.ml.bot.parse.Visibility;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.elements.KtLightElement;
import org.jetbrains.kotlin.j2k.UtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"isFileName", "", "", "isFullyQualified", "getVisibility", "Lcom/android/studio/ml/bot/parse/Visibility;", "element", "Lcom/intellij/psi/PsiElement;", "getEffectiveVisibility", "aiplugin.android"})
public final class AndroidUtilsKt {
    public static final boolean isFileName(@NotNull String $this$isFileName) {
        Intrinsics.checkNotNullParameter((Object)$this$isFileName, (String)"<this>");
        int dotIndex = StringsKt.indexOf$default((CharSequence)$this$isFileName, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (dotIndex == -1) {
            return false;
        }
        int secondDotIndex = StringsKt.indexOf$default((CharSequence)$this$isFileName, (char)'.', (int)(dotIndex + 1), (boolean)false, (int)4, null);
        if (secondDotIndex != -1) {
            return StringsKt.endsWith$default((String)$this$isFileName, (String)".9.png", (boolean)false, (int)2, null);
        }
        String extension = StringsKt.substringAfter$default((String)$this$isFileName, (char)'.', null, (int)2, null);
        FileType fileType = FileTypeRegistry.getInstance().getFileTypeByExtension(extension);
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileTypeByExtension(...)");
        FileType type2 = fileType;
        return !Intrinsics.areEqual((Object)type2, (Object)UnknownFileType.INSTANCE);
    }

    public static final boolean isFullyQualified(@NotNull String $this$isFullyQualified) {
        Intrinsics.checkNotNullParameter((Object)$this$isFullyQualified, (String)"<this>");
        return StringsKt.contains$default((CharSequence)$this$isFullyQualified, (char)'.', (boolean)false, (int)2, null);
    }

    @Nullable
    public static final Visibility getVisibility(@NotNull PsiElement element) {
        Visibility visibility;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element;
        if (psiElement instanceof PsiModifierListOwner) {
            PsiModifierList psiModifierList = ((PsiModifierListOwner)element).getModifierList();
            if (psiModifierList == null) {
                return Visibility.PACKAGE_PRIVATE;
            }
            PsiModifierList modifierList = psiModifierList;
            visibility = modifierList.hasExplicitModifier("public") ? Visibility.PUBLIC : (modifierList.hasExplicitModifier("protected") ? Visibility.PROTECTED : (modifierList.hasExplicitModifier("private") ? Visibility.PRIVATE : (modifierList.hasExplicitModifier("default") ? Visibility.PACKAGE_PRIVATE : Visibility.PACKAGE_PRIVATE)));
        } else if (psiElement instanceof KtModifierListOwner) {
            KtModifierList ktModifierList = ((KtModifierListOwner)element).getModifierList();
            if (ktModifierList == null) {
                return Visibility.PUBLIC;
            }
            KtModifierList modifierList = ktModifierList;
            visibility = modifierList.hasModifier(KtTokens.PUBLIC_KEYWORD) ? Visibility.PUBLIC : (modifierList.hasModifier(KtTokens.INTERNAL_KEYWORD) ? Visibility.INTERNAL : (modifierList.hasModifier(KtTokens.PROTECTED_KEYWORD) ? Visibility.PROTECTED : (modifierList.hasModifier(KtTokens.PRIVATE_KEYWORD) ? Visibility.PRIVATE : Visibility.PUBLIC)));
        } else {
            visibility = null;
        }
        return visibility;
    }

    @NotNull
    public static final Visibility getEffectiveVisibility(@NotNull PsiElement element) {
        Visibility visibility;
        Integer n;
        PsiElement parent;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtLightElement ktLightElement = element instanceof KtLightElement ? (KtLightElement)element : null;
        PsiElement originalElement = ktLightElement != null && (ktLightElement = ktLightElement.getKotlinOrigin()) != null ? (PsiElement)ktLightElement : element;
        Visibility elementVisibility = AndroidUtilsKt.getVisibility(originalElement);
        PsiElement psiElement = parent = originalElement instanceof KtElement ? (PsiElement)KtPsiUtilKt.containingClass((KtElement)((KtElement)originalElement)) : (PsiElement)UtilsKt.getContainingClass((PsiElement)originalElement);
        Visibility parentVisibility = psiElement != null ? AndroidUtilsKt.getVisibility(psiElement) : null;
        Object[] objectArray = new Integer[2];
        Visibility visibility2 = elementVisibility;
        objectArray[0] = visibility2 != null ? Integer.valueOf(visibility2.ordinal()) : null;
        Visibility visibility3 = parentVisibility;
        objectArray[1] = visibility3 != null ? Integer.valueOf(visibility3.ordinal()) : null;
        Integer n2 = n = (Integer)CollectionsKt.minOrNull((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
        if (n2 != null && n2 == 0) {
            visibility = Visibility.PRIVATE;
        } else {
            Integer n3 = n;
            int n4 = 2;
            if (n3 != null && n3 == n4) {
                visibility = Visibility.PACKAGE_PRIVATE;
            } else {
                Integer n5 = n;
                n4 = 1;
                if (n5 != null && n5 == n4) {
                    visibility = Visibility.PROTECTED;
                } else {
                    Integer n6 = n;
                    n4 = 3;
                    if (n6 != null && n6 == n4) {
                        visibility = Visibility.INTERNAL;
                    } else {
                        Integer n7 = n;
                        n4 = 4;
                        visibility = n7 != null && n7 == n4 ? Visibility.PUBLIC : Visibility.PUBLIC;
                    }
                }
            }
        }
        return visibility;
    }
}

