/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.context;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.SmlBundle;
import com.android.studio.ml.bot.StudioBotFlags;
import com.android.studio.ml.bot.configuration.StudioBotAppSettings;
import com.android.studio.ml.bot.configuration.StudioBotAppSettingsKt;
import com.android.studio.ml.bot.context.AgentsMdContextProviderKt;
import com.android.studio.ml.bot.context.ChatContextProvider;
import com.android.studio.ml.bot.context.ContextDrawerDisplayInfo;
import com.android.studio.ml.bot.ui.compose.timeline.Attachment;
import com.android.studio.ml.util.FileUtilsKt;
import com.android.tools.idea.studiobot.AiExcludeService;
import com.android.tools.idea.studiobot.StudioBot;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.project.ProjectKt;
import icons.SmlIconsCompose;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jewel.ui.icon.IntelliJIconKey;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0007H\u0002J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0002J&\u0010\u000f\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0002J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\u0015J&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0002J\u001e\u0010\u001b\u001a\u0014 \u001d*\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\u001c0\u0007\u00a2\u0006\u0002\b\u001c*\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/studio/ml/bot/context/AgentsMdContextProvider;", "Lcom/android/studio/ml/bot/context/ChatContextProvider;", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "collectAgentsMds", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "startFile", "collectAgentsMdsFromRoot", "", "agentsMds", "", "collectAgentsMdsInCurrentFileHierarchy", "findReferencedFiles", "file", "getContext", "", "Lcom/android/studio/ml/bot/ui/compose/timeline/Attachment;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getContextDrawerDisplayInfo", "Lcom/android/studio/ml/bot/context/ContextDrawerDisplayInfo;", "processAgentsMdFile", "", "agentsMd", "findProjectBaseDir", "Lorg/jetbrains/annotations/Nullable;", "kotlin.jvm.PlatformType", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAgentsMdContextProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgentsMdContextProvider.kt\ncom/android/studio/ml/bot/context/AgentsMdContextProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,242:1\n24#2:243\n40#3,3:244\n827#4:247\n855#4,2:248\n1563#4:250\n1634#4,3:251\n1#5:254\n648#6,5:255\n*S KotlinDebug\n*F\n+ 1 AgentsMdContextProvider.kt\ncom/android/studio/ml/bot/context/AgentsMdContextProvider\n*L\n44#1:243\n64#1:244,3\n74#1:247\n74#1:248,2\n78#1:250\n78#1:251,3\n201#1:255,5\n*E\n"})
public final class AgentsMdContextProvider
implements ChatContextProvider {
    @NotNull
    private final Logger logger;
    public static final int $stable = 8;

    public AgentsMdContextProvider() {
        AgentsMdContextProvider $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(AgentsMdContextProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @Override
    @Nullable
    public Object getContextDrawerDisplayInfo(@NotNull Project project2, @NotNull Continuation<? super ContextDrawerDisplayInfo> $completion) {
        ContextDrawerDisplayInfo contextDrawerDisplayInfo;
        if (StudioBotFlags.Companion.getInstance().useAgentsMdContext()) {
            String string = SmlBundle.message("sml.studiobot.context.provider.agents.md.files", new Object[0]);
            IntelliJIconKey intelliJIconKey = SmlIconsCompose.INSTANCE.getAgentContext();
            String string2 = SmlBundle.message("sml.studiobot.context.provider.agents.md.tooltip", new Object[0]);
            contextDrawerDisplayInfo = new ContextDrawerDisplayInfo(string, null, intelliJIconKey, 0, true, string2);
        } else {
            contextDrawerDisplayInfo = null;
        }
        return contextDrawerDisplayInfo;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object getContext(@NotNull Project project2, @NotNull Continuation<? super Collection<? extends Attachment>> $completion) {
        void $this$mapTo$iv$iv;
        VirtualFile virtualFile2;
        Iterable $this$filterNotTo$iv$iv;
        block7: {
            block6: {
                if (!StudioBotFlags.Companion.getInstance().useAgentsMdContext()) break block6;
                boolean $i$f$service = false;
                Class<StudioBotAppSettings> serviceClass$iv = StudioBotAppSettings.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                if (StudioBotAppSettingsKt.isContextSharingEnabled((StudioBotAppSettings)object, project2)) break block7;
            }
            return CollectionsKt.emptyList();
        }
        FileEditorManager manager = FileEditorManager.getInstance((Project)project2);
        FileEditor fileEditor = manager.getSelectedEditor();
        VirtualFile currentEditorFile = fileEditor != null ? fileEditor.getFile() : null;
        AiExcludeService aiExcludeService2 = StudioBot.Companion.getInstance().aiExcludeService(project2);
        Iterable $this$filterNot$iv = this.collectAgentsMds(project2, currentEditorFile);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            virtualFile2 = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (aiExcludeService2.isFileExcluded(virtualFile2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List agentsMds = (List)destination$iv$iv;
        Iterable $this$map$iv = agentsMds;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            virtualFile2 = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path path2 = virtualFile2.toNioPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toNioPath(...)");
            collection.add(new Attachment.TextFile(path2, false, FileUtilsKt.projectRelativePath(virtualFile2, project2), false, true, false, null, null, 232, null));
        }
        return (List)destination$iv$iv;
    }

    private final List<VirtualFile> collectAgentsMds(Project project2, VirtualFile startFile) {
        Set agentsMds = new LinkedHashSet();
        VirtualFile virtualFile2 = startFile;
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl = false;
            this.collectAgentsMdsInCurrentFileHierarchy(project2, startFile, agentsMds);
        }
        this.collectAgentsMdsFromRoot(project2, agentsMds);
        return CollectionsKt.toList((Iterable)agentsMds);
    }

    private final void collectAgentsMdsInCurrentFileHierarchy(Project project2, VirtualFile startFile, Set<VirtualFile> agentsMds) {
        Ref.ObjectRef currentDirectory = new Ref.ObjectRef();
        VirtualFile virtualFile2 = startFile.isDirectory() ? startFile : startFile.getParent();
        currentDirectory.element = virtualFile2 != null ? virtualFile2.getCanonicalFile() : null;
        ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>((Ref.ObjectRef<VirtualFile>)currentDirectory, project2, this, agentsMds){
            final /* synthetic */ Ref.ObjectRef<VirtualFile> $currentDirectory;
            final /* synthetic */ Project $project;
            final /* synthetic */ AgentsMdContextProvider this$0;
            final /* synthetic */ Set<VirtualFile> $agentsMds;
            {
                this.$currentDirectory = $currentDirectory;
                this.$project = $project;
                this.this$0 = $receiver;
                this.$agentsMds = $agentsMds;
                super(0);
            }

            public final void invoke() {
                while (this.$currentDirectory.element != null) {
                    VirtualFile agentsMd;
                    block3: {
                        VirtualFile virtualFile2;
                        ProjectFileIndex projectFileIndex2 = ProjectFileIndex.getInstance((Project)this.$project);
                        Object object = this.$currentDirectory.element;
                        Intrinsics.checkNotNull((Object)object);
                        if (!projectFileIndex2.isInProject((VirtualFile)object)) break;
                        Iterable iterable = AgentsMdContextProviderKt.getAGENT_FILE_NAMES();
                        Ref.ObjectRef<VirtualFile> objectRef = this.$currentDirectory;
                        for (String it : iterable) {
                            boolean bl = false;
                            VirtualFile virtualFile3 = (VirtualFile)objectRef.element;
                            Object object2 = virtualFile3 != null ? virtualFile3.findChild(it) : null;
                            if (object2 == null) continue;
                            virtualFile2 = object2;
                            break block3;
                        }
                        virtualFile2 = agentsMd = null;
                    }
                    if (agentsMd == null) {
                        VirtualFile virtualFile4 = (VirtualFile)this.$currentDirectory.element;
                        this.$currentDirectory.element = virtualFile4 != null && (virtualFile4 = virtualFile4.getParent()) != null ? virtualFile4.getCanonicalFile() : null;
                        continue;
                    }
                    if (!AgentsMdContextProvider.access$processAgentsMdFile(this.this$0, this.$project, agentsMd, this.$agentsMds)) break;
                    VirtualFile virtualFile5 = (VirtualFile)this.$currentDirectory.element;
                    this.$currentDirectory.element = virtualFile5 != null && (virtualFile5 = virtualFile5.getParent()) != null ? virtualFile5.getCanonicalFile() : null;
                }
            }
        }));
    }

    private final void collectAgentsMdsFromRoot(Project project2, Set<VirtualFile> agentsMds) {
        VirtualFile virtualFile2 = this.findProjectBaseDir(project2);
        VirtualFile projectDir = virtualFile2 != null ? virtualFile2.getCanonicalFile() : null;
        ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>(projectDir, project2, this, agentsMds){
            final /* synthetic */ VirtualFile $projectDir;
            final /* synthetic */ Project $project;
            final /* synthetic */ AgentsMdContextProvider this$0;
            final /* synthetic */ Set<VirtualFile> $agentsMds;
            {
                this.$projectDir = $projectDir;
                this.$project = $project;
                this.this$0 = $receiver;
                this.$agentsMds = $agentsMds;
                super(0);
            }

            public final void invoke() {
                block3: {
                    VirtualFile agentsMd;
                    VirtualFile virtualFile2;
                    Object object;
                    Object object2;
                    Iterable iterable;
                    block2: {
                        if (this.$projectDir == null || !ProjectFileIndex.getInstance((Project)this.$project).isInProject(this.$projectDir)) break block3;
                        iterable = AgentsMdContextProviderKt.getAGENT_FILE_NAMES();
                        object2 = this.$projectDir;
                        for (String it : iterable) {
                            boolean bl = false;
                            object = object2.findChild(it);
                            if (object == null) continue;
                            virtualFile2 = object;
                            break block2;
                        }
                        virtualFile2 = null;
                    }
                    VirtualFile virtualFile3 = agentsMd = virtualFile2;
                    if (virtualFile3 != null) {
                        iterable = virtualFile3;
                        object2 = this.this$0;
                        Project project2 = this.$project;
                        object = this.$agentsMds;
                        Iterable it = iterable;
                        boolean bl = false;
                        AgentsMdContextProvider.access$processAgentsMdFile((AgentsMdContextProvider)object2, project2, agentsMd, (Set)object);
                    }
                }
            }
        }));
    }

    private final boolean processAgentsMdFile(Project project2, VirtualFile agentsMd, Set<VirtualFile> agentsMds) {
        VirtualFile virtualFile2 = agentsMd.getCanonicalFile();
        if (virtualFile2 == null) {
            virtualFile2 = agentsMd;
        }
        VirtualFile virtualFile3 = virtualFile2;
        Intrinsics.checkNotNull((Object)virtualFile3);
        VirtualFile nonSymbolicLinkAgentsMd = virtualFile3;
        if (!nonSymbolicLinkAgentsMd.isDirectory()) {
            if (!agentsMds.add(nonSymbolicLinkAgentsMd)) {
                return false;
            }
            List<VirtualFile> referencedFiles = this.findReferencedFiles(project2, nonSymbolicLinkAgentsMd);
            agentsMds.addAll((Collection<VirtualFile>)referencedFiles);
        }
        return true;
    }

    private final List<VirtualFile> findReferencedFiles(Project project2, VirtualFile file) {
        int atIndex;
        String string;
        try {
            string = (String)ActionsKt.runReadAction((Function0)((Function0)new Function0<String>(file){
                final /* synthetic */ VirtualFile $file;
                {
                    this.$file = $file;
                    super(0);
                }

                public final String invoke() {
                    Document document2 = FileDocumentManager.getInstance().getDocument(this.$file);
                    return document2 != null ? document2.getText() : null;
                }
            }));
        }
        catch (IOException e) {
            this.logger.warn("Could not read " + file.getPath(), (Throwable)e);
            return CollectionsKt.emptyList();
        }
        String string2 = string;
        if (string2 == null) {
            return CollectionsKt.emptyList();
        }
        String content2 = string2;
        List referencedFiles = new ArrayList();
        int currentIndex = 0;
        while (currentIndex < content2.length() && (atIndex = StringsKt.indexOf$default((CharSequence)content2, (char)'@', (int)currentIndex, (boolean)false, (int)4, null)) != -1) {
            Path exp2;
            Path $i$f$takeWhile2;
            String string3;
            block10: {
                String $this$takeWhile$iv = StringsKt.drop((String)content2, (int)(atIndex + 1));
                boolean $i$f$takeWhile2 = false;
                int n = $this$takeWhile$iv.length();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    char it = $this$takeWhile$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!CharsKt.isWhitespace((char)it)) continue;
                    String string4 = $this$takeWhile$iv;
                    int n2 = 0;
                    String string5 = string4.substring(n2, index$iv);
                    string3 = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                    break block10;
                }
                string3 = $this$takeWhile$iv;
            }
            String path2 = string3;
            currentIndex = atIndex + path2.length() + 1;
            if (((CharSequence)path2).length() == 0) continue;
            try {
                Intrinsics.checkNotNullExpressionValue((Object)Paths.get(path2, new String[0]), (String)"get(...)");
            }
            catch (InvalidPathException exp2) {
                this.logger.warn("Failed to parse file path", (Throwable)exp2);
                continue;
            }
            Path pathFile = $i$f$takeWhile2;
            try {
                exp2 = file.getParent().toNioPath().resolve(pathFile);
            }
            catch (Exception exp3) {
                this.logger.warn("Failed to resolve absolute path", (Throwable)exp3);
                continue;
            }
            Path absPath = exp2;
            VirtualFile referencedFile = VfsUtil.findFileByIoFile((File)absPath.toFile(), (boolean)true);
            if (referencedFile == null || !VirtualFileUtil.isFile((VirtualFile)referencedFile) || !Intrinsics.areEqual((Object)referencedFile.getExtension(), (Object)"md") || !ProjectFileIndex.getInstance((Project)project2).isInProject(referencedFile)) continue;
            VirtualFile virtualFile2 = referencedFile.getCanonicalFile();
            if (virtualFile2 == null) {
                virtualFile2 = referencedFile;
            }
            referencedFiles.add(virtualFile2);
        }
        return referencedFiles;
    }

    private final VirtualFile findProjectBaseDir(Project $this$findProjectBaseDir) {
        VirtualFile virtualFile2 = VfsUtil.findFileByIoFile((File)ProjectKt.getStateStore((Project)$this$findProjectBaseDir).getProjectBasePath().toFile(), (boolean)true);
        if (virtualFile2 == null) {
            virtualFile2 = $this$findProjectBaseDir.getBaseDir();
        }
        return virtualFile2;
    }

    public static final /* synthetic */ boolean access$processAgentsMdFile(AgentsMdContextProvider $this, Project project2, VirtualFile agentsMd, Set agentsMds) {
        return $this.processAgentsMdFile(project2, agentsMd, agentsMds);
    }
}

