/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.configuration;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.Authenticator;
import com.android.studio.ml.SmlBundle;
import com.android.studio.ml.bot.ui.AvatarType;
import com.android.studio.ml.bot.ui.ProfilePicture;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001c\u001a\u00020\u0016J\u000e\u0010\u001d\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lcom/android/studio/ml/bot/configuration/UserAccountPanel;", "Ljavax/swing/JPanel;", "disposable", "Lcom/intellij/openapi/Disposable;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/Disposable;Lkotlinx/coroutines/CoroutineScope;)V", "accountSettingsLabel", "Lcom/intellij/ui/HoverHyperlinkLabel;", "authState", "Lcom/android/studio/ml/Authenticator$AuthState;", "label", "Lcom/intellij/ui/components/JBLabel;", "labelCtaGap", "Ljava/awt/Component;", "kotlin.jvm.PlatformType", "pictureLabelGap", "profilePicture", "Lcom/android/studio/ml/bot/ui/ProfilePicture;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "addNotify", "", "navigateToGoogleAccountConfigurable", "showAuthorized", "userInfo", "Lcom/android/studio/ml/Authenticator$UserInfo;", "showLoggedIn", "showLoggedOut", "updateState", "Companion", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nUserAccountPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserAccountPanel.kt\ncom/android/studio/ml/bot/configuration/UserAccountPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n1#2:145\n*E\n"})
public final class UserAccountPanel
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private Authenticator.AuthState authState;
    @NotNull
    private final ProfilePicture profilePicture;
    private final Component pictureLabelGap;
    @NotNull
    private final JBLabel label;
    private final Component labelCtaGap;
    @NotNull
    private final HoverHyperlinkLabel accountSettingsLabel;
    public static final int $stable = 8;
    @NotNull
    private static final String GOOGLE_LOGIN_CONFIGURABLE_ID = "com.google.gct.login2.settings.GoogleLoginApplicationSettingsConfigurableProvider";

    /*
     * WARNING - void declaration
     */
    public UserAccountPanel(@NotNull Disposable disposable, @NotNull CoroutineScope scope2) {
        void $this$label_u24lambda_u241;
        ProfilePicture $this$profilePicture_u24lambda_u240;
        ProfilePicture profilePicture;
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.scope = scope2;
        this.authState = Authenticator.AuthState.LoggedOut.INSTANCE;
        ProfilePicture profilePicture2 = profilePicture = new ProfilePicture(16, disposable, this.scope, null, 8, null);
        UserAccountPanel userAccountPanel = this;
        boolean bl = false;
        $this$profilePicture_u24lambda_u240.setVisible(false);
        userAccountPanel.profilePicture = profilePicture;
        this.pictureLabelGap = Box.createHorizontalStrut(6);
        $this$profilePicture_u24lambda_u240 = profilePicture = new JBLabel();
        userAccountPanel = this;
        boolean bl2 = false;
        $this$label_u24lambda_u241.setIconTextGap(JBUIScale.scale((int)6));
        userAccountPanel.label = profilePicture;
        this.labelCtaGap = Box.createHorizontalStrut(10);
        this.accountSettingsLabel = new HoverHyperlinkLabel(SmlBundle.message("sml.studiobot.settings.userAccount.label.cta.logIn", new Object[0]));
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.profilePicture);
        this.add(this.pictureLabelGap);
        this.add((Component)this.label);
        this.add(this.labelCtaGap);
        this.add((Component)this.accountSettingsLabel);
        this.accountSettingsLabel.addHyperlinkListener(arg_0 -> UserAccountPanel._init_$lambda$2(this, arg_0));
        this.showLoggedOut();
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!Authenticator.Companion.current().isLoggedIn()) {
            Settings allSettings;
            DataContext dataContext2 = DataManager.getInstance().getDataContext((Component)this);
            Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
            Settings settings = allSettings = (Settings)Settings.KEY.getData(dataContext2);
            this.accountSettingsLabel.setVisible((settings != null ? settings.find(GOOGLE_LOGIN_CONFIGURABLE_ID) : null) != null);
        }
    }

    private final void navigateToGoogleAccountConfigurable() {
        Configurable configurable;
        DataContext dataContext2 = DataManager.getInstance().getDataContext((Component)this);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        Settings allSettings = (Settings)Settings.KEY.getData(dataContext2);
        if (allSettings != null && (configurable = allSettings.find(GOOGLE_LOGIN_CONFIGURABLE_ID)) != null) {
            allSettings.select(configurable);
        }
    }

    public final void showLoggedOut() {
        this.authState = Authenticator.AuthState.LoggedOut.INSTANCE;
        this.profilePicture.setVisible(false);
        this.pictureLabelGap.setVisible(false);
        this.label.setIcon(null);
        this.label.setText(SmlBundle.message("sml.studiobot.settings.userAccount.label.loggedOut", new Object[0]));
        this.labelCtaGap.setVisible(true);
        this.accountSettingsLabel.setText(SmlBundle.message("sml.studiobot.settings.userAccount.label.cta.logIn", new Object[0]));
        this.accountSettingsLabel.setVisible(true);
    }

    public final void showLoggedIn(@NotNull Authenticator.UserInfo userInfo) {
        Intrinsics.checkNotNullParameter((Object)userInfo, (String)"userInfo");
        this.authState = new Authenticator.AuthState.LoggedIn(userInfo);
        this.profilePicture.setAvatarType(AvatarType.User);
        this.profilePicture.setVisible(true);
        this.pictureLabelGap.setVisible(true);
        this.label.setIcon(null);
        Object[] objectArray = new Object[]{userInfo.getEmail()};
        this.label.setText(SmlBundle.message("sml.studiobot.settings.userAccount.label.loggedIn", objectArray));
        this.labelCtaGap.setVisible(true);
        this.accountSettingsLabel.setText(SmlBundle.message("sml.studiobot.settings.userAccount.label.cta.authorize", new Object[0]));
        this.accountSettingsLabel.setVisible(true);
    }

    public final void showAuthorized(@NotNull Authenticator.UserInfo userInfo) {
        Intrinsics.checkNotNullParameter((Object)userInfo, (String)"userInfo");
        this.authState = new Authenticator.AuthState.Authorized(userInfo);
        this.profilePicture.setAvatarType(AvatarType.User);
        this.profilePicture.setVisible(true);
        this.pictureLabelGap.setVisible(true);
        this.label.setIcon(null);
        Object[] objectArray = new Object[]{userInfo.getEmail()};
        this.label.setText(SmlBundle.message("sml.studiobot.settings.userAccount.label.authorized", objectArray));
        this.labelCtaGap.setVisible(false);
        this.accountSettingsLabel.setVisible(false);
    }

    public final void updateState(@NotNull Authenticator.AuthState authState) {
        Intrinsics.checkNotNullParameter((Object)authState, (String)"authState");
        Authenticator.AuthState authState2 = authState;
        if ((authState2 instanceof Authenticator.AuthState.LoggedOut ? true : authState2 instanceof Authenticator.AuthState.Initializing) ? true : authState2 instanceof Authenticator.AuthState.LoggingIn) {
            this.showLoggedOut();
        } else if (authState2 instanceof Authenticator.AuthState.LoggedIn) {
            this.showLoggedIn(((Authenticator.AuthState.LoggedIn)authState).getProfileInfo());
        } else if (authState2 instanceof Authenticator.AuthState.Authorized) {
            this.showAuthorized(((Authenticator.AuthState.Authorized)authState).getProfileInfo());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final void _init_$lambda$2(UserAccountPanel this$0, HyperlinkEvent e) {
        if (Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            this$0.navigateToGoogleAccountConfigurable();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/studio/ml/bot/configuration/UserAccountPanel$Companion;", "", "()V", "GOOGLE_LOGIN_CONFIGURABLE_ID", "", "aiplugin.core.aicore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

