/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.commands;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.bot.UtilsKt;
import com.android.studio.ml.bot.commands.Commands;
import com.android.studio.ml.bot.commands.Environment;
import com.android.studio.ml.bot.commands.Result;
import com.android.studio.ml.bot.parse.resolve.ProjectSearcherUtils;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testIntegration.GotoTestOrCodeHandler;
import com.intellij.testIntegration.TestFinderHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0016\u0010\n\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\bH\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\b2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u001c\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u001c\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ;\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0015J\"\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0002J&\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\u0019\u001a\u00020\u001a\u00a8\u0006\u001b"}, d2={"Lcom/android/studio/ml/bot/commands/ExecutionCommands;", "Lcom/android/studio/ml/bot/commands/Commands;", "()V", "build", "Lcom/android/studio/ml/bot/commands/Result;", "environment", "Lcom/android/studio/ml/bot/commands/Environment;", "arguments", "", "", "elementsToStrings", "elements", "Lcom/intellij/psi/PsiElement;", "findEditorTests", "findTests", "selectedElement", "profile", "run", "executorName", "label", "actionId", "run$aiplugin_core_aicore", "runConfiguration", "targetName", "test", "debug", "", "aiplugin.core.aicore"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nExecutionCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecutionCommands.kt\ncom/android/studio/ml/bot/commands/ExecutionCommands\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,172:1\n1617#2,9:173\n1869#2:182\n1870#2:184\n1626#2:185\n1#3:183\n1#3:186\n*S KotlinDebug\n*F\n+ 1 ExecutionCommands.kt\ncom/android/studio/ml/bot/commands/ExecutionCommands\n*L\n133#1:173,9\n133#1:182\n133#1:184\n133#1:185\n133#1:183\n*E\n"})
public final class ExecutionCommands
implements Commands {
    @NotNull
    public static final ExecutionCommands INSTANCE = new ExecutionCommands();
    public static final int $stable;

    private ExecutionCommands() {
    }

    @NotNull
    public final Result build(@NotNull Environment environment2, @NotNull List<String> arguments) {
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        return this.runAction(environment2, "MakeModule", "Building Project");
    }

    @NotNull
    public final Result run(@NotNull Environment environment2, @NotNull List<String> arguments) {
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        return this.run$aiplugin_core_aicore(environment2, arguments, "Run", "Running", "Run");
    }

    @NotNull
    public final Result profile(@NotNull Environment environment2, @NotNull List<String> arguments) {
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        return this.run$aiplugin_core_aicore(environment2, arguments, "Profile", "Profiling", "Profile");
    }

    @NotNull
    public final Result run$aiplugin_core_aicore(@NotNull Environment environment2, @NotNull List<String> arguments, @NotNull String executorName, @NotNull String label, @NotNull String actionId2) {
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)executorName, (String)"executorName");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)actionId2, (String)"actionId");
        if (!((Collection)arguments).isEmpty()) {
            if (arguments.size() > 1) {
                return new Result("Only one target is supported", false);
            }
            String target = arguments.get(0);
            if (Intrinsics.areEqual((Object)target, (Object)"test") || Intrinsics.areEqual((Object)target, (Object)"tests")) {
                return this.test(environment2, CollectionsKt.emptyList(), Intrinsics.areEqual((Object)executorName, (Object)"Debug"));
            }
            String string = this.runConfiguration(environment2, executorName, target);
            if (string == null) {
                return new Result(label + " " + target, null, 2, null);
            }
            String error = string;
            return new Result(error, false);
        }
        return this.runAction(environment2, actionId2, "Started " + label);
    }

    private final List<PsiElement> findEditorTests(Environment environment2) {
        PsiFile psiFile2;
        VirtualFile file;
        Project project2 = environment2.getProject();
        Editor editor2 = UtilsKt.getTextEditor(project2);
        if (editor2 != null && (file = FileDocumentManager.getInstance().getFile(editor2.getDocument())) != null && (psiFile2 = PsiManager.getInstance((Project)project2).findFile(file)) != null) {
            PsiElement psiElement = GotoTestOrCodeHandler.getSelectedElement((Editor)editor2, (PsiFile)psiFile2);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getSelectedElement(...)");
            PsiElement selectedElement = psiElement;
            return this.findTests(selectedElement);
        }
        return CollectionsKt.emptyList();
    }

    private final List<PsiElement> findTests(PsiElement selectedElement) {
        if (TestFinderHelper.isTest((PsiElement)selectedElement)) {
            return CollectionsKt.listOf((Object)selectedElement);
        }
        Collection tests = TestFinderHelper.findTestsForClass((PsiElement)selectedElement);
        if (tests != null && !tests.isEmpty()) {
            return CollectionsKt.toList((Iterable)tests);
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public final Result test(@NotNull Environment environment2, @NotNull List<String> arguments, boolean debug2) {
        Result result2;
        List<PsiElement> list;
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        if (arguments.isEmpty()) {
            list = this.findEditorTests(environment2);
        } else {
            String target = arguments.get(0);
            PsiElement element = ProjectSearcherUtils.findElement$default(ProjectSearcherUtils.INSTANCE, environment2.getProject(), target, false, false, 8, null);
            if (element != null) {
                list = this.findTests(element);
            } else {
                return new Result("Couldn't find " + target, false);
            }
        }
        List<PsiElement> tests = list;
        if (tests.isEmpty()) {
            result2 = new Result("Can't find any associated tests", false);
        } else {
            String name = this.elementsToStrings(tests);
            String[] stringArray = new String[]{" "};
            List args = StringsKt.split$default((CharSequence)name, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            result2 = debug2 ? this.run$aiplugin_core_aicore(environment2, args, "Debug", "Debugging", "Debug") : this.run$aiplugin_core_aicore(environment2, args, "Run", "Running", "Run");
        }
        return result2;
    }

    public static /* synthetic */ Result test$default(ExecutionCommands executionCommands, Environment environment2, List list, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return executionCommands.test(environment2, list, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final String elementsToStrings(List<? extends PsiElement> elements) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = elements;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PsiElement it = (PsiElement)element$iv$iv;
            boolean bl2 = false;
            if ((it instanceof PsiFile ? ((PsiFile)it).getName() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    private final String runConfiguration(Environment environment2, String executorName, String targetName) {
        Object v1;
        Executor executor;
        Project project2;
        block5: {
            project2 = environment2.getProject();
            Executor executor2 = ExecutorRegistry.getInstance().getExecutorById(executorName);
            if (executor2 == null) {
                return "Couldn't find executor";
            }
            executor = executor2;
            Iterable iterable = RunManager.Companion.getInstance(project2).getAllSettings();
            for (Object t : iterable) {
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)targetName)) continue;
                v1 = t;
                break block5;
            }
            v1 = null;
        }
        RunnerAndConfigurationSettings settings = v1;
        if (settings == null) {
            PsiElement psiElement = ProjectSearcherUtils.findElement$default(ProjectSearcherUtils.INSTANCE, project2, targetName, false, false, 12, null);
            if (psiElement == null) {
                return "Can't find " + targetName;
            }
            PsiElement psiElement2 = psiElement;
            ConfigurationContext configurationContext = new ConfigurationContext(psiElement2);
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = configurationContext.getConfiguration();
            if (runnerAndConfigurationSettings == null) {
                return "Can't create configuration for an element";
            }
            settings = runnerAndConfigurationSettings;
        }
        ExecutionEnvironment env = ExecutionEnvironmentBuilder.build$default((ExecutionEnvironmentBuilder)ExecutionEnvironmentBuilder.Companion.create(executor, settings), null, (int)1, null);
        ProgramRunnerUtil.executeConfiguration((ExecutionEnvironment)env, (boolean)false, (boolean)true);
        return null;
    }

    @Override
    @NotNull
    public Result runAction(@NotNull Environment environment2, @NotNull String id, @NotNull String description) {
        return Commands.super.runAction(environment2, id, description);
    }

    @Override
    @NotNull
    public Result runAction(@NotNull Environment environment2, @NotNull AnAction action, @NotNull String description) {
        return Commands.super.runAction(environment2, action, description);
    }

    @Override
    @NotNull
    public DataContext createDataContext(@NotNull Project project2) {
        return Commands.super.createDataContext(project2);
    }

    @Override
    @NotNull
    public DataContext createDataContext(@NotNull Project project2, @Nullable Editor textEditor, @Nullable FileEditor fileEditor) {
        return Commands.super.createDataContext(project2, textEditor, fileEditor);
    }
}

