/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.action;

import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.ui.ComponentUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\b\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0010H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/studio/ml/bot/action/PopupCloseHandler;", "Ljava/awt/event/AWTEventListener;", "ownerWindow", "Ljava/awt/Window;", "closePopupCallback", "Lkotlin/Function0;", "", "(Ljava/awt/Window;Lkotlin/jvm/functions/Function0;)V", "eventDispatched", "event", "Ljava/awt/AWTEvent;", "inPopupOrBalloon", "", "component", "Ljava/awt/Component;", "isWithinOriginalWindow", "Ljava/awt/event/MouseEvent;", "aiplugin.core.aicore"})
final class PopupCloseHandler
implements AWTEventListener {
    @NotNull
    private final Window ownerWindow;
    @NotNull
    private final Function0<Unit> closePopupCallback;

    public PopupCloseHandler(@NotNull Window ownerWindow, @NotNull Function0<Unit> closePopupCallback) {
        Intrinsics.checkNotNullParameter((Object)ownerWindow, (String)"ownerWindow");
        Intrinsics.checkNotNullParameter(closePopupCallback, (String)"closePopupCallback");
        this.ownerWindow = ownerWindow;
        this.closePopupCallback = closePopupCallback;
    }

    @Override
    public void eventDispatched(@Nullable AWTEvent event) {
        if (event instanceof MouseEvent) {
            if (((MouseEvent)event).getID() != 501) {
                return;
            }
            Component component2 = ((MouseEvent)event).getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"getComponent(...)");
            if (!this.inPopupOrBalloon(component2) && !this.isWithinOriginalWindow((MouseEvent)event)) {
                this.closePopupCallback.invoke();
            }
        }
    }

    private final boolean isWithinOriginalWindow(MouseEvent event) {
        Component owner = this.ownerWindow;
        Component child = ComponentUtil.getWindow((Component)event.getComponent());
        if (child != owner) {
            while (child != null) {
                if (child == owner) {
                    return true;
                }
                child = child.getParent();
            }
        }
        return false;
    }

    private final boolean inPopupOrBalloon(Component component2) {
        Component parent = component2;
        while (parent instanceof JComponent) {
            if (parent instanceof JPopupMenu || ((JComponent)parent).getClientProperty("Balloon.property") instanceof Balloon) {
                return true;
            }
            Container container = ((JComponent)parent).getParent();
            Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getParent(...)");
            parent = container;
        }
        return false;
    }
}

