/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.backends;

import com.android.tools.idea.studiobot.prompts.Prompt;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0002\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a\u0014\u0010\u0006\u001a\u00020\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0004\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"SYSTEM_MESSAGE", "", "fileContext", "files", "", "Lcom/android/tools/idea/studiobot/prompts/Prompt$ContextFile;", "chunksToString", "chunks", "Lcom/android/tools/idea/studiobot/prompts/Prompt$Chunk;", "aiplugin.backends.third-party"})
public final class PromptsKt {
    @NotNull
    public static final String SYSTEM_MESSAGE = "\nThe assistant is embedded inside Android Studio, the IDE for developing\nAndroid applications.\n\nIt should give concise answers to very simple questions, but provide thorough responses\nto more complex and open ended questions. It adopts a tone used in the official\nAndroid developer documentation at developer.android.com.\n\nIt provides relevant code snippets where applicable. Unless otherwise requested by\nthe user, code snippets are offered in Kotlin and use the modern Jetpack libraries\nand patterns, following modern Android development practices.\n\nWhile the assistant is embedded inside the IDE, it cannot actually see the user's\ncode unless users explicitly share it with the assistant. The IDE provides settings\nthat allow the user to control whether source code is visible to the assistant.\nThe IDE also allows more fine grained privacy controls via the use of a .aiexclude\nfile.\n";

    @NotNull
    public static final String fileContext(@NotNull List<Prompt.ContextFile> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        return CollectionsKt.joinToString$default((Iterable)files2, null, null, null, (int)0, null, PromptsKt::fileContext$lambda$0, (int)31, null);
    }

    @NotNull
    public static final String chunksToString(@NotNull List<? extends Prompt.Chunk> chunks) {
        Intrinsics.checkNotNullParameter(chunks, (String)"chunks");
        return CollectionsKt.joinToString$default((Iterable)chunks, (CharSequence)"\n", null, null, (int)0, null, PromptsKt::chunksToString$lambda$1, (int)30, null);
    }

    private static final CharSequence fileContext$lambda$0(Prompt.ContextFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.trimMargin$default((String)("\n      |Consider the queries below in the context of the following files.\n      |\n      |File path: " + it.getVirtualFile().getPath() + "\n      |File Contents:\n      |```\n      |" + it.getFileText() + "\n      |```\n      |\n    "), null, (int)1, null);
    }

    private static final CharSequence chunksToString$lambda$1(Prompt.Chunk it) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Prompt.Chunk chunk = it;
        if (chunk instanceof Prompt.TextChunk) {
            charSequence = ((Prompt.TextChunk)it).getText();
        } else if (chunk instanceof Prompt.CodeChunk) {
            charSequence = "\n```" + ((Prompt.CodeChunk)it).getText() + "\n```";
        } else {
            if (chunk instanceof Prompt.BlobChunk) {
                throw new UnsupportedOperationException();
            }
            throw new NoWhenBranchMatchedException();
        }
        return charSequence;
    }
}

