/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.analysis;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.flags.Flag;
import com.android.studio.ml.SingleSelectionStudioBotAction;
import com.android.studio.ml.SingleSelectionStudioBotActionKt;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.studiobot.ChatService;
import com.android.tools.idea.studiobot.StudioBot;
import com.android.tools.idea.studiobot.prompts.Prompt;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0006H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0094@\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/android/studio/ml/analysis/AnalyzeThreadSafetyAction;", "Lcom/android/studio/ml/SingleSelectionStudioBotAction;", "<init>", "()V", "mapToFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "isEnabled", "", "project", "Lcom/intellij/openapi/project/Project;", "sendAndProcessResponse", "", "filteredFiles", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "aiplugin.android"})
@StabilityInferred(parameters=0)
public final class AnalyzeThreadSafetyAction
extends SingleSelectionStudioBotAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable = 8;
    @NotNull
    private static final String preamble = "You are a software engineer with extensive experience in the Java and Kotlin programming languages.\nYou are an expert in Android application development.\nYou are an excellent technical writer, with decades of experience writing documentation for code.\nYou are an expert in the English language.\nAnalyze the given files for race conditions, but do not regurgitate the contents of the files unless when pointing to a specific issue or code.\nAnalyze call sequences to private functions within each given class to ensure that multi-threaded invocation is thread-safe.\nCheck thread safety by analyzing interleaving of operations and method calls of potential multi-threaded invocation of methods.\nAnalyze all non-private methods potential thread-safety violations.\nIf no thread-safety violations are detected, only say \"I could not detect any thread-safety issues.\"\n\nThe following are some examples:\n\nPrompt 1:\n```\npublic class Example1 {\n  public int foo = 0;\n\n  public void doStuff1() {\n    foo++;\n  }\n}\n```\nResponse 1:\nThe variable `foo` is not `volatile`, and therefore different threads may see different values. It is also a publicly accessible\nvariable, allowing external threads to read and write to the variable in non-thread-safe ways.\n\n`foo++` is not an atomic operation, and thread interleaving can cause `foo` to not increment correctly.\n\nA fix for `doStuff1()` can be as follows:\n```\npublic class Example1 {\n  private int foo = 0;\n\n  public synchronized void doStuff1() {\n    foo++;\n  }\n}\n```\n\n---\nExample 2:\n```\npublic class Example2 {\n  private int foo = 0;\n\n  public synchronized void doStuff2() {\n    foo++;\n  }\n}\n```\nResponse 2:\nI could not detect any thread-safety issues.\n\n---\nExample 3:\n```\npublic class Example3 {\n  private ConcurrentHashMap<String, Integer> map = new ConcurrentHashMap<>();\n\n  public Example3() {\n    map.put(\"example3\", 0);\n  }\n\n  public void doSomething() {\n    map.compute(\"example3\", (key, value) -> {\n      return value + 1;\n    });\n  }\n}\n```\nResponse 3:\nI could not detect any thread-safety issues.\n\n---\nExample 4:\n```\npublic class Example4 {\n  private ConcurrentHashMap<String, Integer> map = new ConcurrentHashMap<>();\n\n  public Example4() {\n    map.put(\"example4\", 0);\n  }\n\n  public void doSomething() {\n    int value = map.get(\"example4\");\n    value += 2;\n    map.put(\"example4\", value);\n  }\n}\n```\nResponse 4:\nEven though `map` uses a `ConcurrentHashMap`, the implementation of `doSomething` still has a potential race condition\nwhere the ordering of `map.get`, `value += 1`, and the final storage `map.put` can be interleaved between different\ncalling threads.\n\nOne potential fix for `doSomething()` relying on `ConcurrentHashMap`'s concurrency guarantees can be as follows:\n```\npublic class Example4 {\n  private ConcurrentHashMap<String, Integer> map = new ConcurrentHashMap<>();\n\n  public Example4() {\n    map.put(\"example4\", 0);\n  }\n\n  public synchronized void doSomething() {\n    int value = map.compute(\"example4\");\n    value += 2;\n    map.put(\"example4\", value);\n  }\n}\n```\n\nAnother potential fix for `doSomething()` can be as follows:\n```\npublic class Example4 {\n  private ConcurrentHashMap<String, Integer> map = new ConcurrentHashMap<>();\n\n  public Example4() {\n    map.put(\"example4\", 0);\n  }\n\n  public synchronized void doSomething() {\n    map.get(\"example4\", (key, value) -> {\n      return value + 2;\n    });\n  }\n}\n```\n\nThe following are the contents of code files to analyze for thread-safety issues:";

    public AnalyzeThreadSafetyAction() {
        super("Analyzing thread safety", (Flag<Boolean>)StudioFlags.ANALYZE_THREAD_SAFETY);
    }

    @Override
    @NotNull
    protected List<VirtualFile> mapToFiles(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file.getFileType() instanceof JavaFileType || file.getFileType() instanceof KotlinFileType ? CollectionsKt.listOf((Object)file) : CollectionsKt.emptyList();
    }

    @Override
    public boolean isEnabled(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return ChatService.isReadyToReceiveQuery$default(StudioBot.Companion.getInstance().chat(project2), null, 1, null);
    }

    @Override
    @Nullable
    protected Object sendAndProcessResponse(@NotNull Project project2, @NotNull List<? extends VirtualFile> filteredFiles, @NotNull Continuation<? super Unit> $completion) {
        Prompt prompt2 = SingleSelectionStudioBotActionKt.buildFileContentPrompt$default(project2, preamble, SingleSelectionStudioBotActionKt.readTextFromFiles(project2, filteredFiles), null, 8, null);
        SingleSelectionStudioBotActionKt.sendChat(StudioBot.Companion.getInstance(), project2, prompt2, "Analyze " + (filteredFiles.size() == 1 ? filteredFiles.get(0).getName() : "selected files") + " for thread-safety violations.");
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/studio/ml/analysis/AnalyzeThreadSafetyAction$Companion;", "", "<init>", "()V", "preamble", "", "aiplugin.android"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

