/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.aida;

import androidx.compose.runtime.internal.StabilityInferred;
import java.time.Clock;
import java.time.Instant;
import java.time.InstantSource;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/studio/ml/aida/HourlyRateLimiter;", "", "tokensPerHour", "", "instantSource", "Ljava/time/InstantSource;", "(ILjava/time/InstantSource;)V", "availableTokens", "lastTokenRenewal", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "acquire", "", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
public final class HourlyRateLimiter {
    private final int tokensPerHour;
    @NotNull
    private final InstantSource instantSource;
    private int availableTokens;
    private Instant lastTokenRenewal;
    public static final int $stable = 8;

    public HourlyRateLimiter(int tokensPerHour, @NotNull InstantSource instantSource) {
        Intrinsics.checkNotNullParameter((Object)instantSource, (String)"instantSource");
        this.tokensPerHour = tokensPerHour;
        this.instantSource = instantSource;
        this.availableTokens = this.tokensPerHour;
        this.lastTokenRenewal = this.instantSource.instant();
    }

    public /* synthetic */ HourlyRateLimiter(int n, InstantSource instantSource, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            Clock clock = Clock.systemDefaultZone();
            Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"systemDefaultZone(...)");
            instantSource = clock;
        }
        this(n, instantSource);
    }

    public final boolean acquire() {
        boolean bl;
        Instant current2 = this.instantSource.instant();
        if (current2.minus(1L, ChronoUnit.HOURS).isAfter(this.lastTokenRenewal)) {
            this.lastTokenRenewal = current2;
            this.availableTokens = this.tokensPerHour;
        }
        if (this.availableTokens > 0) {
            int n = this.availableTokens;
            this.availableTokens = n + -1;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }
}

