/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.navigation;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.PsiNavigateUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.daemon.clang.ExternalResolveUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionSymbolInformation;
import com.jetbrains.cidr.lang.daemon.clang.clangd.navigation.ClangGotoAction;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.eclipse.lsp4j.Position;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangNaiveGotoActionSync
extends ClangGotoAction<PsiElement> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final List<CLionSymbolInformation> myTargets;

    public ClangNaiveGotoActionSync(@NlsContexts.PopupTitle @NotNull String name, @NotNull Icon icon, @NotNull Project project, @NotNull PsiElement source, @NotNull List<CLionSymbolInformation> targets) {
        if (name == null) {
            ClangNaiveGotoActionSync.$$$reportNull$$$0(0);
        }
        if (icon == null) {
            ClangNaiveGotoActionSync.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ClangNaiveGotoActionSync.$$$reportNull$$$0(2);
        }
        if (source == null) {
            ClangNaiveGotoActionSync.$$$reportNull$$$0(3);
        }
        if (targets == null) {
            ClangNaiveGotoActionSync.$$$reportNull$$$0(4);
        }
        super(source, name, icon);
        this.myProject = project;
        this.myTargets = targets;
    }

    @NotNull
    public Collection<CLionSymbolInformation> getTargets() {
        List<CLionSymbolInformation> list = this.myTargets;
        if (list == null) {
            ClangNaiveGotoActionSync.$$$reportNull$$$0(5);
        }
        return list;
    }

    public void navigate(@Nullable MouseEvent mouseEvent, @Nullable Editor editor) {
        PsiElement source = this.getSource();
        if (source == null) {
            return;
        }
        Collection targets = (Collection)CidrConcurrentUtilsKt.computeUnderProgress((String)OCBundle.message((String)"navigation.goto.resolving.target", (Object[])new Object[0]), (Project)this.myProject, () -> {
            ArrayList<PsiElement> result = new ArrayList<PsiElement>();
            for (CLionSymbolInformation symInfo : this.myTargets) {
                PsiElement element = ClangNaiveGotoActionSync.findAppropriateElement(this.myProject, symInfo);
                if (element == null) continue;
                result.add(element);
            }
            return result;
        });
        if (targets == null || targets.isEmpty()) {
            return;
        }
        if (targets.size() == 1) {
            PsiNavigateUtil.navigate((PsiElement)((PsiElement)targets.iterator().next()));
            return;
        }
        PsiElement[] targetElementsArray = PsiUtilCore.toPsiElementArray((Collection)targets);
        PsiElementListCellRenderer renderer = this.createRenderer(source, targetElementsArray);
        JBPopup popup = NavigationUtil.getPsiElementPopup((PsiElement[])targetElementsArray, (PsiElementListCellRenderer)renderer, (String)this.getName());
        if (mouseEvent != null) {
            popup.show(new RelativePoint(mouseEvent));
        } else if (editor != null) {
            popup.showInBestPositionFor(editor);
        } else {
            OCLog.LOG.error("mouseEvent and editor are null!");
        }
    }

    @Nullable
    private static PsiElement findAppropriateElement(@NotNull Project project, @NotNull CLionSymbolInformation symInfo) {
        if (project == null) {
            ClangNaiveGotoActionSync.$$$reportNull$$$0(6);
        }
        if (symInfo == null) {
            ClangNaiveGotoActionSync.$$$reportNull$$$0(7);
        }
        try {
            VirtualFile vf = VfsUtil.findFileByURL((URL)new URI(symInfo.getLocation().getUri()).toURL());
            if (vf == null) {
                return null;
            }
            Document document = FileDocumentManager.getInstance().getDocument(vf);
            if (document == null) {
                return null;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(vf);
            if (psiFile == null) {
                return null;
            }
            return ExternalResolveUtils.findAppropriateElement((PsiFile)psiFile, (int)ClangLanguageServiceUtils.lspPos2Offset((Document)document, (Position)symInfo.getLocation().getRange().getStart()));
        }
        catch (MalformedURLException | URISyntaxException ex) {
            LOG.warn((Throwable)ex);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/navigation/ClangNaiveGotoActionSync";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/navigation/ClangNaiveGotoActionSync";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findAppropriateElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

