/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.AdvancedClangIdeFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContextImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionClazyConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangDFAConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.UnusedIncludesInspectionMode;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a&\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0007H\u0002\u001a \u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u001a7\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112!\u0010\u0012\u001a\u001d\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u0002H\u00110\u0013H\u0082\b\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u0019"}, d2={"parseAndShowStats", "", "project", "Lcom/intellij/openapi/project/Project;", "onlySourceFiles", "", "filesLimit", "", "getFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "maxFilesNumber", "showOutputInEditor", "text", "", "caption", "withDisposable", "T", "block", "Lkotlin/Function1;", "Lcom/intellij/openapi/Disposable;", "Lkotlin/ParameterName;", "name", "disposable", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "intellij.cidr.clangd.legacyBridge"})
@SourceDebugExtension(value={"SMAP\nClangdCollectParseStats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangdCollectParseStats.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdCollectParseStatsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,202:1\n195#1,7:210\n774#2:203\n865#2,2:204\n1563#2:206\n1634#2,3:207\n774#2:217\n865#2,2:218\n*S KotlinDebug\n*F\n+ 1 ClangdCollectParseStats.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdCollectParseStatsKt\n*L\n81#1:210,7\n111#1:203\n111#1:204,2\n112#1:206\n112#1:207,3\n177#1:217\n177#1:218,2\n*E\n"})
public final class ClangdCollectParseStatsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void parseAndShowStats(Project project, boolean onlySourceFiles, int filesLimit) {
        Object lock = new Object();
        Collection<VirtualFile> files = ClangdCollectParseStatsKt.getFiles(project, onlySourceFiles, filesLimit);
        ConcurrentHashMap path2Errors = new ConcurrentHashMap();
        Ref.IntRef threadsNumber = new Ref.IntRef();
        threadsNumber.element = Runtime.getRuntime().availableProcessors();
        if (threadsNumber.element > 8) {
            threadsNumber.element = 8;
        } else if (threadsNumber.element > 1) {
            --threadsNumber.element;
        }
        String descriptor = "ParseStats";
        AdvancedClangIdeFacadeImpl facade2 = new AdvancedClangIdeFacadeImpl(descriptor){

            public ClionClangDFAConfigParams getDFAOptions(Project project, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return new ClionClangDFAConfigParams(false, 0, null, null, 15, null);
            }

            public UnusedIncludesInspectionMode getUnusedIncludesInspectionMode(Project project, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return UnusedIncludesInspectionMode.Off;
            }

            public CLionClazyConfigParams getClazyConfig(Project project, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return null;
            }

            public ClionClangTidyConfigParams getClangTidyConfig(Project project, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return null;
            }
        };
        ClangDaemonContextImpl clangDaemonContextImpl = new ClangDaemonContextImpl.Builder(descriptor, project).setIdeFacade((ClangIdeFacade)facade2).create();
        Intrinsics.checkNotNullExpressionValue((Object)clangDaemonContextImpl, (String)"create(...)");
        ClangDaemonContextImpl context = clangDaemonContextImpl;
        ClangdLanguageService service = new ClangdLanguageService((ClangDaemonContext)context);
        try {
            AtomicInteger shutDownsCounter = new AtomicInteger(0);
            AtomicInteger crashesCounter = new AtomicInteger(0);
            long startTimeMs = System.currentTimeMillis();
            try {
                Unit cfr_ignored_0 = (Unit)ActionUtil.underModalProgress((Project)project, (String)"Collecting parse statistics", () -> ClangdCollectParseStatsKt.parseAndShowStats$lambda$8(service, threadsNumber, files, crashesCounter, shutDownsCounter, path2Errors, lock));
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
            long endTimeMs = System.currentTimeMillis();
            int totalErrors = 0;
            HashSet uniqueErrors = new HashSet();
            for (Map.Entry object : ((Map)path2Errors).entrySet()) {
                String string = (String)object.getKey();
                List errors = (List)object.getValue();
                uniqueErrors.addAll(errors);
                totalErrors += errors.size();
            }
            StringBuilder content = new StringBuilder();
            content.append("Time: " + (endTimeMs - startTimeMs) / (long)1000 + " seconds\n");
            content.append("Threads number: " + threadsNumber.element + "\n");
            content.append("Server crashes: " + crashesCounter.get() + " times\n");
            content.append("Server shutdowns: " + shutDownsCounter.get() + " times\n");
            content.append("Processed files: " + files.size() + "\n");
            content.append("Total errors: " + totalErrors + "\n");
            content.append("Unique errors: " + uniqueErrors.size() + "\n");
            for (Map.Entry entry : ((Map)path2Errors).entrySet()) {
                String path = (String)entry.getKey();
                List errors = (List)entry.getValue();
                content.append(path).append("\n");
                for (String error : errors) {
                    content.append(" - " + error + "\n");
                }
            }
            String string = content.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            ClangdCollectParseStatsKt.showOutputInEditor(project, string, "Errors Stats for " + project.getName());
        }
        finally {
            service.stop();
        }
    }

    private static final Collection<VirtualFile> getFiles(Project project, boolean onlySourceFiles, int maxFilesNumber) {
        Object object = ReadAction.compute(() -> ClangdCollectParseStatsKt.getFiles$lambda$10(project, maxFilesNumber, onlySourceFiles));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (Collection)object;
    }

    private static final void showOutputInEditor(Project project, String text, String caption) {
        if (project.isDisposed()) {
            return;
        }
        FileEditorManager.getInstance((Project)project).openFile((VirtualFile)new LightVirtualFile(caption, (Language)PlainTextLanguage.INSTANCE, (CharSequence)text), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T> T withDisposable(Function1<? super Disposable, ? extends T> block) {
        Object object;
        boolean $i$f$withDisposable = false;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        try {
            object = block.invoke((Object)disposable2);
        }
        finally {
            InlineMarker.finallyStart((int)1);
            Disposer.dispose((Disposable)disposable2);
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    private static final List parseAndShowStats$lambda$8$lambda$7$lambda$5$lambda$4$lambda$2(ClangParseResponse it) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ClangDiagnostic it2;
        void $this$filterTo$iv$iv;
        if (it == null) {
            return Collections.singletonList("ClangParseResponse = null");
        }
        CompletableFuture[] completableFutureArray = ClangParseResponse.getAllAnswers((ClangParseResponse)it);
        CompletableFuture<Void> masterFuture = CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length));
        Intrinsics.checkNotNull(masterFuture);
        CidrConcurrentUtilsKt.waitCancelAndWriteActionAware((Future)masterFuture, (String)"diagnostics");
        Supplier supplier = (Supplier)it.getDiagnostics().get();
        if (supplier == null) {
            return Collections.singletonList("diagsSupplier = null");
        }
        Supplier diagsSupplier = supplier;
        List diags = (List)diagsSupplier.get();
        Intrinsics.checkNotNull((Object)diags);
        Iterable $this$filter$iv = diags;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it2 = (ClangDiagnostic)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it2.getSeverity(), (Object)HighlightSeverity.ERROR)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it2 = (ClangDiagnostic)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("[" + it2.getCode() + "] " + it2.getMessage());
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void parseAndShowStats$lambda$8$lambda$7$lambda$5$lambda$4(ClangdLanguageService $service, VirtualFile $file, ConcurrentHashMap $path2Errors, Object $lock, AtomicInteger $processedFiles, ProgressIndicator $indicator, Collection $files) {
        List errors = (List)$service.computeWithOpenedAndParsed($file, ClangdCollectParseStatsKt::parseAndShowStats$lambda$8$lambda$7$lambda$5$lambda$4$lambda$2);
        Object object = $path2Errors;
        object.put($file.getPath(), errors);
        object = $lock;
        synchronized (object) {
            boolean bl = false;
            int curProgress = $processedFiles.incrementAndGet();
            $service.getMemoryUsageWatchDog().getMaxMemory();
            $indicator.setFraction((double)curProgress / (double)$files.size());
            long memBytes = $service.getMemoryUsageWatchDog().getCurrentMemory();
            $indicator.setText2(curProgress + " / " + $files.size() + ", memory: " + memBytes / (long)0x100000 + "Mb");
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final Unit parseAndShowStats$lambda$8$lambda$7$lambda$5(ProgressIndicator $indicator, ClangdLanguageService $service, ConcurrentHashMap $path2Errors, Object $lock, AtomicInteger $processedFiles, Collection $files, VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!$indicator.isCanceled()) {
            ProgressManager.getInstance().runProcess(() -> ClangdCollectParseStatsKt.parseAndShowStats$lambda$8$lambda$7$lambda$5$lambda$4($service, file, $path2Errors, $lock, $processedFiles, $indicator, $files), (ProgressIndicator)new SensitiveProgressWrapper($indicator));
        }
        return Unit.INSTANCE;
    }

    private static final void parseAndShowStats$lambda$8$lambda$7$lambda$6(Function1 $fileProcessor, VirtualFile $file) {
        $fileProcessor.invoke((Object)$file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit parseAndShowStats$lambda$8(ClangdLanguageService $service, Ref.IntRef $threadsNumber, Collection $files, AtomicInteger $crashesCounter, AtomicInteger $shutDownsCounter, ConcurrentHashMap $path2Errors, Object $lock) {
        boolean $i$f$withDisposable = false;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable$iv = disposable;
        try {
            Disposable disposable2 = disposable$iv;
            boolean bl = false;
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            MessageBusConnection messageBusConnection = $service.getMessageBus().connect(disposable2);
            Topic topic = ClangServerListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, (Object)new ClangServerListener($crashesCounter, indicator, $shutDownsCounter){
                final /* synthetic */ AtomicInteger $crashesCounter;
                final /* synthetic */ ProgressIndicator $indicator;
                final /* synthetic */ AtomicInteger $shutDownsCounter;
                {
                    this.$crashesCounter = $crashesCounter;
                    this.$indicator = $indicator;
                    this.$shutDownsCounter = $shutDownsCounter;
                }

                public void onServerFailure() {
                    this.$crashesCounter.incrementAndGet();
                    this.$indicator.cancel();
                }

                public void onServerShutDown() {
                    this.$shutDownsCounter.incrementAndGet();
                    this.$indicator.cancel();
                }
            });
            AtomicInteger processedFiles = new AtomicInteger(0);
            Function1 fileProcessor = arg_0 -> ClangdCollectParseStatsKt.parseAndShowStats$lambda$8$lambda$7$lambda$5(indicator, $service, $path2Errors, $lock, processedFiles, $files, arg_0);
            indicator.setIndeterminate(false);
            indicator.setFraction(0.0);
            ExecutorService execService = Executors.newFixedThreadPool($threadsNumber.element);
            ArrayList futures = new ArrayList($files.size());
            for (VirtualFile file : $files) {
                futures.add(execService.submit(() -> ClangdCollectParseStatsKt.parseAndShowStats$lambda$8$lambda$7$lambda$6(fileProcessor, file)));
            }
            Iterator iterator = futures.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                Future future = (Future)e;
                CidrConcurrentUtilsKt.waitCancelAndWriteActionAware((Future)future, (String)"some file to parse");
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            Disposer.dispose((Disposable)disposable$iv);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection getFiles$lambda$10(Project $project, int $maxFilesNumber, boolean $onlySourceFiles) {
        void $this$filterTo$iv$iv;
        Collection collection = OCSearchScope.getExplicitlySpecifiedProjectSourceFiles((Project)$project);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getExplicitlySpecifiedProjectSourceFiles(...)");
        Collection allFiles = collection;
        Iterable $this$filter$iv = allFiles;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(!$onlySourceFiles || OCFileTypeHelpers.isSourceFile((String)it.getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredFiles = (List)destination$iv$iv;
        return $maxFilesNumber > 0 ? CollectionsKt.take((Iterable)filteredFiles, (int)$maxFilesNumber) : filteredFiles;
    }

    public static final /* synthetic */ void access$parseAndShowStats(Project project, boolean onlySourceFiles, int filesLimit) {
        ClangdCollectParseStatsKt.parseAndShowStats(project, onlySourceFiles, filesLimit);
    }
}

