/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.references;

import com.android.tools.r8.internal.j81;
import com.android.tools.r8.internal.sa0;
import com.android.tools.r8.internal.u81;
import com.android.tools.r8.references.ArrayReference;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.FieldReference;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.references.PackageReference;
import com.android.tools.r8.references.PrimitiveReference;
import com.android.tools.r8.references.TypeReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class Reference {
    public static PrimitiveReference BOOL;
    public static PrimitiveReference BYTE;
    public static PrimitiveReference CHAR;
    public static PrimitiveReference SHORT;
    public static PrimitiveReference INT;
    public static PrimitiveReference FLOAT;
    public static PrimitiveReference LONG;
    public static PrimitiveReference DOUBLE;
    static final /* synthetic */ boolean a;

    public static TypeReference returnTypeFromDescriptor(String descriptor) {
        String string;
        if (descriptor.equals("V")) {
            return null;
        }
        return Reference.typeFromDescriptor(string);
    }

    public static TypeReference returnTypeFromTypeName(String typename) {
        String string;
        if (typename.equals("void")) {
            return null;
        }
        return Reference.typeFromTypeName(string);
    }

    public static TypeReference typeFromDescriptor(String descriptor) {
        String string;
        char c15 = descriptor.charAt(0);
        if (c15 != 'L') {
            if (c15 != '[') {
                return Reference.primitiveFromDescriptor(string);
            }
            return Reference.arrayFromDescriptor(string);
        }
        return Reference.classFromDescriptor(string);
    }

    public static TypeReference typeFromTypeName(String typeName) {
        return Reference.typeFromDescriptor(sa0.H(typeName));
    }

    public static PrimitiveReference primitiveFromDescriptor(String descriptor) {
        return PrimitiveReference.a(descriptor);
    }

    public static ClassReference classFromDescriptor(String descriptor) {
        return ClassReference.a(descriptor);
    }

    public static ClassReference classFromBinaryName(String binaryName) {
        return Reference.classFromDescriptor(sa0.k(binaryName));
    }

    public static ClassReference classFromTypeName(String typeName) {
        return Reference.classFromDescriptor(sa0.H(typeName));
    }

    public static ClassReference classFromClass(Class<?> clazz) {
        return Reference.classFromTypeName(clazz.getTypeName());
    }

    public static ArrayReference arrayFromDescriptor(String descriptor) {
        return ArrayReference.a(descriptor);
    }

    /*
     * WARNING - void declaration
     */
    public static ArrayReference array(TypeReference baseType, int dimensions) {
        void var1_1;
        return ArrayReference.a(baseType, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static MethodReference method(ClassReference holderClass, String methodName, List<TypeReference> formalTypes, TypeReference returnType) {
        void var3_3;
        void var1_1;
        ClassReference classReference;
        u81 u812;
        u812 = u81.a(u812);
        return new MethodReference(classReference, (String)var1_1, u812, (TypeReference)var3_3);
    }

    public static MethodReference methodFromMethod(Executable executable) {
        Executable executable2;
        if (executable instanceof Constructor) {
            return Reference.methodFromMethod((Constructor)executable2);
        }
        if (!a && !(executable2 instanceof Method)) {
            throw new AssertionError();
        }
        return Reference.methodFromMethod((Method)executable2);
    }

    public static MethodReference methodFromMethod(Method method) {
        Object object;
        Method method2 = method;
        String string = method2.getName();
        Object object2 = method2.getDeclaringClass();
        Object object3 = method2.getParameterTypes();
        object = ((Method)object).getReturnType();
        boolean bl5 = false;
        Object[] objectArray = new Object[4];
        int n15 = 0;
        int n16 = ((Class<?>[])object3).length;
        for (int i15 = 0; i15 < n16; ++i15) {
            TypeReference typeReference = Reference.typeFromDescriptor(sa0.H(object3[i15].getTypeName()));
            typeReference.getClass();
            int n17 = n15 + 1;
            if (objectArray.length < n17) {
                boolean bl6;
                Object[] objectArray2 = Arrays.copyOf(objectArray, j81.a(objectArray.length, n17));
                bl5 = bl6 = false;
                objectArray = objectArray2;
            } else if (bl5) {
                boolean bl7;
                Object[] objectArray3 = Arrays.copyOf(objectArray, objectArray.length);
                bl5 = bl7 = false;
                objectArray = objectArray3;
            }
            n17 = n15 + 1;
            objectArray[n15] = typeReference;
            n15 = n17;
        }
        object2 = Reference.classFromClass(object2);
        object3 = u81.b(n15, objectArray);
        object = object == Void.TYPE ? null : Reference.typeFromDescriptor(sa0.H(((Class)object).getTypeName()));
        return Reference.method((ClassReference)object2, string, object3, (TypeReference)object);
    }

    public static MethodReference methodFromMethod(Constructor<?> method) {
        Constructor<?> constructor = method;
        GenericDeclaration genericDeclaration = constructor.getDeclaringClass();
        Class<?>[] classArray = constructor.getParameterTypes();
        boolean bl5 = false;
        Object[] objectArray = new Object[4];
        int n15 = 0;
        int n16 = classArray.length;
        for (int i15 = 0; i15 < n16; ++i15) {
            TypeReference typeReference = Reference.typeFromDescriptor(sa0.H(classArray[i15].getTypeName()));
            typeReference.getClass();
            int n17 = n15 + 1;
            if (objectArray.length < n17) {
                boolean bl6;
                Object[] objectArray2 = Arrays.copyOf(objectArray, j81.a(objectArray.length, n17));
                bl5 = bl6 = false;
                objectArray = objectArray2;
            } else if (bl5) {
                boolean bl7;
                Object[] objectArray3 = Arrays.copyOf(objectArray, objectArray.length);
                bl5 = bl7 = false;
                objectArray = objectArray3;
            }
            n17 = n15 + 1;
            objectArray[n15] = typeReference;
            n15 = n17;
        }
        return Reference.method(Reference.classFromClass(genericDeclaration), "<init>", u81.b(n15, objectArray), null);
    }

    /*
     * WARNING - void declaration
     */
    public static MethodReference methodFromDescriptor(String classDescriptor, String methodName, String methodDescriptor) {
        void var1_1;
        ClassReference classReference;
        Object object;
        boolean bl5 = false;
        Object[] objectArray = new Object[4];
        int n15 = 0;
        String[] stringArray = sa0.e(methodDescriptor);
        int n16 = stringArray.length;
        for (int i15 = 0; i15 < n16; ++i15) {
            TypeReference typeReference = Reference.typeFromDescriptor(stringArray[i15]);
            typeReference.getClass();
            int n17 = n15 + 1;
            if (objectArray.length < n17) {
                boolean bl6;
                Object[] objectArray2 = Arrays.copyOf(objectArray, j81.a(objectArray.length, n17));
                bl5 = bl6 = false;
                objectArray = objectArray2;
            } else if (bl5) {
                boolean bl7;
                Object[] objectArray3 = Arrays.copyOf(objectArray, objectArray.length);
                bl5 = bl7 = false;
                objectArray = objectArray3;
            }
            n17 = n15 + 1;
            objectArray[n15] = typeReference;
            n15 = n17;
        }
        object = sa0.u((String)object);
        classReference = Reference.classFromDescriptor((String)((Object)classReference));
        u81 u812 = u81.b(n15, objectArray);
        object = ((String)object).equals("V") ? null : Reference.typeFromDescriptor((String)object);
        return Reference.method(classReference, (String)var1_1, u812, (TypeReference)object);
    }

    /*
     * WARNING - void declaration
     */
    public static MethodReference methodFromDescriptor(ClassReference classReference, String methodName, String methodDescriptor) {
        void var1_1;
        ClassReference classReference2;
        Object object;
        boolean bl5 = false;
        Object[] objectArray = new Object[4];
        int n15 = 0;
        String[] stringArray = sa0.e(methodDescriptor);
        int n16 = stringArray.length;
        for (int i15 = 0; i15 < n16; ++i15) {
            TypeReference typeReference = Reference.typeFromDescriptor(stringArray[i15]);
            typeReference.getClass();
            int n17 = n15 + 1;
            if (objectArray.length < n17) {
                boolean bl6;
                Object[] objectArray2 = Arrays.copyOf(objectArray, j81.a(objectArray.length, n17));
                bl5 = bl6 = false;
                objectArray = objectArray2;
            } else if (bl5) {
                boolean bl7;
                Object[] objectArray3 = Arrays.copyOf(objectArray, objectArray.length);
                bl5 = bl7 = false;
                objectArray = objectArray3;
            }
            n17 = n15 + 1;
            objectArray[n15] = typeReference;
            n15 = n17;
        }
        object = sa0.u((String)object);
        u81 u812 = u81.b(n15, objectArray);
        object = ((String)object).equals("V") ? null : Reference.typeFromDescriptor((String)object);
        return Reference.method(classReference2, (String)var1_1, u812, (TypeReference)object);
    }

    public static MethodReference classConstructor(ClassReference type) {
        return Reference.method(type, "<clinit>", Collections.EMPTY_LIST, null);
    }

    /*
     * WARNING - void declaration
     */
    public static FieldReference field(ClassReference holderClass, String fieldName, TypeReference fieldType) {
        void var2_2;
        void var1_1;
        ClassReference classReference;
        return new FieldReference(classReference, (String)var1_1, (TypeReference)var2_2);
    }

    public static FieldReference fieldFromField(Field field) {
        Field field2 = field;
        AnnotatedElement annotatedElement = field2.getDeclaringClass();
        String string = field2.getName();
        Class<?> clazz = field2.getType();
        return Reference.field(Reference.classFromClass(annotatedElement), string, Reference.typeFromDescriptor(sa0.H(clazz.getTypeName())));
    }

    public static PackageReference packageFromString(String packageName) {
        String string;
        return new PackageReference(string);
    }

    public static PackageReference packageFromPackage(Package pkg) {
        Package package_;
        return new PackageReference(package_.getName());
    }

    static {
        a = Reference.class.desiredAssertionStatus() ^ true;
        BOOL = PrimitiveReference.a;
        BYTE = PrimitiveReference.b;
        CHAR = PrimitiveReference.c;
        SHORT = PrimitiveReference.d;
        INT = PrimitiveReference.e;
        FLOAT = PrimitiveReference.f;
        LONG = PrimitiveReference.g;
        DOUBLE = PrimitiveReference.h;
    }
}

