/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.assistant.runtime;

import com.android.tools.r8.assistant.runtime.ReflectiveOperationReceiver;
import com.android.tools.r8.assistant.runtime.ReflectiveOracle;
import com.android.tools.r8.keepanno.annotations.KeepForApi;
import java.lang.reflect.InvocationHandler;
import java.util.Arrays;

@KeepForApi
public class ReflectiveOperationLogger
implements ReflectiveOperationReceiver {
    @Override
    public void onClassNewInstance(ReflectiveOracle.Stack stack, Class<?> clazz) {
        System.out.println("Reflectively created new instance of " + clazz.getName());
    }

    private String printMethod(String method, Class<?> ... parameters) {
        return method + this.printParameters(parameters);
    }

    private String printConstructor(Class<?> ... parameters) {
        return "<init>" + this.printParameters(parameters);
    }

    private String printParameters(Class<?> ... parameters) {
        if (parameters == null) {
            return "(null)";
        }
        if (parameters.length == 0) {
            return "()";
        }
        StringBuilder sb5 = new StringBuilder();
        sb5.append("(");
        Class<?> first = parameters[0];
        for (Class<?> parameter : parameters) {
            if (parameter != first) {
                sb5.append(", ");
            }
            sb5.append(parameter.getName());
        }
        sb5.append(")");
        return sb5.toString();
    }

    @Override
    public void onClassGetDeclaredMethod(ReflectiveOracle.Stack stack, Class<?> returnType, Class<?> clazz, String method, Class<?> ... parameters) {
        System.out.println("Reflectively got declared method " + this.printMethod(method, parameters) + " on " + clazz.getName());
    }

    @Override
    public void onClassGetDeclaredMethods(ReflectiveOracle.Stack stack, Class<?> clazz) {
        System.out.println("Reflectively got declared methods on " + clazz.getName());
    }

    @Override
    public void onClassGetDeclaredField(ReflectiveOracle.Stack stack, Class<?> fieldType, Class<?> clazz, String fieldName) {
        System.out.println("Reflectively got declared field " + fieldName + " on " + clazz.getName());
    }

    @Override
    public void onClassGetDeclaredFields(ReflectiveOracle.Stack stack, Class<?> clazz) {
        System.out.println("Reflectively got declared fields on " + clazz.getName());
    }

    @Override
    public void onClassGetDeclaredConstructor(ReflectiveOracle.Stack stack, Class<?> clazz, Class<?> ... parameters) {
        System.out.println("Reflectively got declared constructor " + this.printConstructor(parameters) + " on " + clazz.getName());
    }

    @Override
    public void onClassGetDeclaredConstructors(ReflectiveOracle.Stack stack, Class<?> clazz) {
        System.out.println("Reflectively got declared constructors on " + clazz.getName());
    }

    @Override
    public void onClassGetMethod(ReflectiveOracle.Stack stack, Class<?> returnType, Class<?> clazz, String method, Class<?> ... parameters) {
        System.out.println("Reflectively got method " + this.printMethod(method, parameters) + " on " + clazz.getName());
    }

    @Override
    public void onClassGetMethods(ReflectiveOracle.Stack stack, Class<?> clazz) {
        System.out.println("Reflectively got methods on " + clazz.getName());
    }

    @Override
    public void onClassGetField(ReflectiveOracle.Stack stack, Class<?> fieldType, Class<?> clazz, String fieldName) {
        System.out.println("Reflectively got field " + fieldName + " on " + clazz.getName());
    }

    @Override
    public void onClassGetFields(ReflectiveOracle.Stack stack, Class<?> clazz) {
        System.out.println("Reflectively got fields on " + clazz.getName());
    }

    @Override
    public void onClassGetConstructor(ReflectiveOracle.Stack stack, Class<?> clazz, Class<?> ... parameters) {
        System.out.println("Reflectively got constructor " + this.printConstructor(parameters) + " on " + clazz.getName());
    }

    @Override
    public void onClassGetConstructors(ReflectiveOracle.Stack stack, Class<?> clazz) {
        System.out.println("Reflectively got constructors on " + clazz.getName());
    }

    @Override
    public void onClassGetName(ReflectiveOracle.Stack stack, Class<?> clazz, ReflectiveOperationReceiver.NameLookupType lookupType) {
        System.out.println("Reflectively got name on " + clazz.getName() + "(" + lookupType.toString() + ")");
    }

    @Override
    public void onClassForName(ReflectiveOracle.Stack stack, String className, boolean initialize, ClassLoader classLoader) {
        System.out.println("Reflectively called Class.forName on " + className);
    }

    @Override
    public void onClassGetComponentType(ReflectiveOracle.Stack stack, Class<?> clazz) {
        System.out.println("Reflectively called Class.getComponentType on " + clazz);
    }

    @Override
    public void onClassGetPackage(ReflectiveOracle.Stack stack, Class<?> clazz) {
        System.out.println("Reflectively called Class.getPackage on " + clazz);
    }

    @Override
    public void onClassIsAssignableFrom(ReflectiveOracle.Stack stack, Class<?> clazz, Class<?> sup) {
        System.out.println("Reflectively called Class.isAssignableFrom on " + clazz + " with " + sup);
    }

    @Override
    public void onClassGetSuperclass(ReflectiveOracle.Stack stack, Class<?> clazz) {
        System.out.println("Reflectively called Class.getSuperclass on " + clazz.getName());
    }

    @Override
    public void onClassAsSubclass(ReflectiveOracle.Stack stack, Class<?> holder, Class<?> clazz) {
        System.out.println("Reflectively called Class.asSubclass on " + clazz.getName() + " from " + holder.getName());
    }

    @Override
    public void onClassIsInstance(ReflectiveOracle.Stack stack, Class<?> holder, Object object) {
        System.out.println("Reflectively called Class.isInstance on " + object + " from " + holder.getName());
    }

    @Override
    public void onClassCast(ReflectiveOracle.Stack stack, Class<?> holder, Object object) {
        System.out.println("Reflectively called Class.cast on " + object + " from " + holder.getName());
    }

    @Override
    public void onClassFlag(ReflectiveOracle.Stack stack, Class<?> clazz, ReflectiveOperationReceiver.ClassFlag classFlag) {
        System.out.println("Reflectively got class flag " + classFlag);
    }

    @Override
    public void onAtomicFieldUpdaterNewUpdater(ReflectiveOracle.Stack stack, Class<?> fieldClass, Class<?> clazz, String name) {
        System.out.println("Reflectively got AtomicReferenceFieldUpdater.newUpdater on " + fieldClass + " " + clazz + "#" + name);
    }

    @Override
    public void onServiceLoaderLoad(ReflectiveOracle.Stack stack, Class<?> clazz, ClassLoader classLoader) {
        System.out.println("Reflectively got ServiceLoader.load on " + clazz + " with " + classLoader);
    }

    @Override
    public void onProxyNewProxyInstance(ReflectiveOracle.Stack stack, ClassLoader classLoader, Class<?>[] interfaces, InvocationHandler invocationHandler) {
        System.out.println("Reflectively got Proxy.newProxyInstance on " + Arrays.toString(interfaces) + " with " + classLoader + " and " + invocationHandler);
    }

    @Override
    public boolean requiresStackInformation() {
        return true;
    }
}

