/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.ui;

import com.android.uiautomator.UiAutomatorModel;
import com.android.uiautomator.tree.BasicTreeNode;
import com.google.gct.testrecorder.ui.RecordingDialog;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class ScreenshotPanel
extends JPanel {
    private RecordingDialog myParent;
    private BufferedImage myImage;
    private UiAutomatorModel myModel;
    private Dimension myCanvasSize;
    private Dimension myImageSize;
    private float myScale;
    private int startX;
    private int startY;
    private int myScaledWidth;
    private int myScaleHeight;
    private BasicTreeNode myHoverNode;
    private BasicTreeNode mySelectedNode;

    public ScreenshotPanel(RecordingDialog parent) {
        this.myParent = parent;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!ScreenshotPanel.this.isValidAssertionMode()) {
                    return;
                }
                BasicTreeNode node = ScreenshotPanel.this.getElementAtMousePosition(mouseEvent);
                if (node == null) {
                    return;
                }
                if (ScreenshotPanel.this.mySelectedNode == null) {
                    ScreenshotPanel.this.mySelectedNode = node;
                    ScreenshotPanel.this.myParent.setUpAssertionPanel(node);
                    ScreenshotPanel.this.repaint();
                } else {
                    ScreenshotPanel.this.mySelectedNode = null;
                    ScreenshotPanel.this.myParent.setUpEmptyAssertionPanel();
                    ScreenshotPanel.this.repaint();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (!ScreenshotPanel.this.isValidAssertionMode()) {
                    return;
                }
                BasicTreeNode node = ScreenshotPanel.this.getElementAtMousePosition(mouseEvent);
                if (node == null || !node.equals(ScreenshotPanel.this.myHoverNode)) {
                    ScreenshotPanel.this.myHoverNode = node;
                    ScreenshotPanel.this.repaint();
                }
                ScreenshotPanel.this.myHoverNode = node;
            }
        });
    }

    private boolean isValidAssertionMode() {
        return this.myImage != null && this.myModel != null && this.myParent.isAssertionMode();
    }

    private BasicTreeNode getElementAtMousePosition(MouseEvent mouseEvent) {
        int mouseX = mouseEvent.getX();
        int mouseY = mouseEvent.getY();
        mouseX = (int)((float)(mouseX - this.startX) / this.myScale);
        mouseY = (int)((float)(mouseY - this.startY) / this.myScale);
        return this.myModel.updateSelectionForCoordinates(mouseX, mouseY);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myImage == null) {
            return;
        }
        this.myCanvasSize = this.getSize();
        this.myImageSize = new Dimension(this.myImage.getWidth(), this.myImage.getHeight());
        float scaleX = (float)this.myCanvasSize.width / (float)this.myImageSize.width;
        float scaleY = (float)this.myCanvasSize.height / (float)this.myImageSize.height;
        this.myScale = Math.min(scaleX, scaleY);
        this.myScaledWidth = (int)((float)this.myImageSize.width * this.myScale);
        this.myScaleHeight = (int)((float)this.myImageSize.height * this.myScale);
        Image scaledImage = this.myImage.getScaledInstance(this.myScaledWidth, this.myScaleHeight, 4);
        this.startX = (this.myCanvasSize.width - this.myScaledWidth) / 2;
        this.startY = (this.myCanvasSize.height - this.myScaleHeight) / 2;
        g.drawImage(scaledImage, this.startX, this.startY, null);
        if (!this.myParent.isAssertionMode()) {
            this.mySelectedNode = null;
            this.myHoverNode = null;
        }
        if (this.mySelectedNode != null) {
            int x = (int)((float)this.mySelectedNode.x * this.myScale) + this.startX;
            int y = (int)((float)this.mySelectedNode.y * this.myScale) + this.startY;
            int w = (int)((float)this.mySelectedNode.width * this.myScale);
            int h = (int)((float)this.mySelectedNode.height * this.myScale);
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(Color.RED);
            g2.setStroke(new BasicStroke(2.0f));
            g2.drawRect(x, y, w, h);
        } else if (this.myHoverNode != null) {
            int x = (int)((float)this.myHoverNode.x * this.myScale) + this.startX;
            int y = (int)((float)this.myHoverNode.y * this.myScale) + this.startY;
            int w = (int)((float)this.myHoverNode.width * this.myScale);
            int h = (int)((float)this.myHoverNode.height * this.myScale);
            g.setColor(Color.RED);
            g.drawRect(x, y, w, h);
        }
    }

    public void updateScreenShot(BufferedImage image, UiAutomatorModel model) {
        this.myImage = image;
        this.myModel = model;
        this.clearSelectionAndRepaint();
    }

    public void clearSelectionAndRepaint() {
        this.mySelectedNode = null;
        this.myHoverNode = null;
        this.revalidate();
        this.repaint();
    }

    public void setSelectedNodeAndRepaint(@Nullable BasicTreeNode node) {
        this.mySelectedNode = node;
        this.repaint();
    }

    public UiAutomatorModel getModel() {
        return this.myModel;
    }
}

