/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.tools.perflib.analyzer.Capture;
import com.android.tools.perflib.captures.DataBuffer;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Field;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.HprofParser;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.InstanceList;
import com.android.tools.perflib.heap.NonRecursiveVisitor;
import com.android.tools.perflib.heap.RootObj;
import com.android.tools.perflib.heap.RootType;
import com.android.tools.perflib.heap.StackFrame;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.ThreadObj;
import com.android.tools.perflib.heap.Type;
import com.android.tools.perflib.heap.analysis.LinkEvalDominators;
import com.android.tools.perflib.heap.analysis.ShortestDistanceVisitor;
import com.android.tools.perflib.heap.ext.NativeRegistryPostProcessor;
import com.android.tools.perflib.heap.ext.SnapshotPostProcessor;
import com.android.tools.proguard.ProguardMap;
import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 e2\u00020\u0001:\u0001eB\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020\nJ\u0016\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u00020,2\u0006\u00100\u001a\u00020\nJ\u0010\u00101\u001a\u0004\u0018\u00010\n2\u0006\u0010+\u001a\u00020,J\u0010\u00101\u001a\u0004\u0018\u00010\n2\u0006\u0010-\u001a\u00020.J\u0016\u00102\u001a\n 3*\u0004\u0018\u00010\u00140\u00142\u0006\u00104\u001a\u00020\u0014J\u0010\u00105\u001a\u0004\u0018\u00010\u00142\u0006\u0010+\u001a\u00020\u001dJ\u0016\u00106\u001a\n 3*\u0004\u0018\u00010\u00110\u00112\u0006\u00107\u001a\u00020\u0011J\u0010\u00108\u001a\u0004\u0018\u00010\u00112\u0006\u00109\u001a\u00020,J\u0018\u0010:\u001a\u0004\u0018\u00010\u00112\u0006\u00109\u001a\u00020,2\u0006\u0010;\u001a\u00020,J\u000e\u0010<\u001a\u00020(2\u0006\u0010=\u001a\u00020\u000eJ\u0018\u0010>\u001a\u00020(2\b\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010A\u001a\u00020,J\u000e\u0010B\u001a\u00020@2\u0006\u0010A\u001a\u00020,J\u000e\u0010C\u001a\u00020(2\u0006\u0010D\u001a\u00020,J\u000e\u0010E\u001a\u00020,2\u0006\u0010F\u001a\u00020GJ\u0016\u0010H\u001a\u00020(2\u0006\u0010+\u001a\u00020\u001d2\u0006\u0010I\u001a\u00020JJ\u0016\u0010K\u001a\u00020(2\u0006\u0010+\u001a\u00020\u001d2\u0006\u0010L\u001a\u00020\u0019J\u0010\u0010M\u001a\u0004\u0018\u00010J2\u0006\u0010+\u001a\u00020\u001dJ\u0010\u0010N\u001a\u0004\u0018\u00010\u00192\u0006\u0010+\u001a\u00020\u001dJ\u0012\u0010N\u001a\u0004\u0018\u00010\u00192\b\u0010-\u001a\u0004\u0018\u00010.J\u0016\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00190\"2\b\u0010-\u001a\u0004\u0018\u00010.J\u0006\u0010P\u001a\u00020(J\u0006\u0010Q\u001a\u00020(J\u0006\u0010R\u001a\u00020(J\u0006\u0010S\u001a\u00020(J\u0014\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00190U2\u0006\u0010V\u001a\u00020.J\u000e\u0010W\u001a\n\u0012\u0004\u0012\u00020J\u0018\u00010XJ\b\u0010Y\u001a\u00020(H\u0002J\u000e\u0010Z\u001a\b\u0012\u0004\u0012\u00020J0XH\u0002J\u001f\u0010[\u001a\u00020(2\u0014\b\u0004\u0010\\\u001a\u000e\u0012\u0004\u0012\u00020J\u0012\u0004\u0012\u00020(0]H\u0082\bJ\f\u0010^\u001a\b\u0012\u0004\u0012\u00020J0UJ#\u0010_\u001a\u0004\u0018\u0001H`\"\u0004\b\u0000\u0010`2\f\u0010a\u001a\b\u0012\u0004\u0012\u0002H`0bH\u0016\u00a2\u0006\u0002\u0010cJ\b\u0010d\u001a\u00020.H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\tj\b\u0012\u0004\u0012\u00020\u000e`\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0\"8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010$\u00a8\u0006f"}, d2={"Lcom/android/tools/perflib/heap/Snapshot;", "Lcom/android/tools/perflib/analyzer/Capture;", "buffer", "Lcom/android/tools/perflib/captures/DataBuffer;", "<init>", "(Lcom/android/tools/perflib/captures/DataBuffer;)V", "getBuffer", "()Lcom/android/tools/perflib/captures/DataBuffer;", "heapList", "Ljava/util/ArrayList;", "Lcom/android/tools/perflib/heap/Heap;", "Lkotlin/collections/ArrayList;", "currentHeap", "roots", "Lcom/android/tools/perflib/heap/RootObj;", "traces", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "Lcom/android/tools/perflib/heap/StackTrace;", "frames", "Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "Lcom/android/tools/perflib/heap/StackFrame;", "areRetainedSizesComputed", "", "referenceClasses", "Lit/unimi/dsi/fastutil/objects/ObjectOpenHashSet;", "Lcom/android/tools/perflib/heap/ClassObj;", "typeSizes", "", "value", "", "idSizeMask", "getIdSizeMask", "()J", "heaps", "", "getHeaps", "()Ljava/util/Collection;", "gcRoots", "getGcRoots", "dispose", "", "setToDefaultHeap", "setHeapTo", "id", "", "name", "", "getHeapIndex", "heap", "getHeap", "addStackFrame", "kotlin.jvm.PlatformType", "theFrame", "getStackFrame", "addStackTrace", "theTrace", "getStackTrace", "traceSerialNumber", "getStackTraceAtDepth", "depth", "addRoot", "root", "addThread", "thread", "Lcom/android/tools/perflib/heap/ThreadObj;", "serialNumber", "getThread", "setIdSize", "size", "getTypeSize", "type", "Lcom/android/tools/perflib/heap/Type;", "addInstance", "instance", "Lcom/android/tools/perflib/heap/Instance;", "addClass", "theClass", "findInstance", "findClass", "findClasses", "resolveClasses", "identifySoftReferences", "resolveReferences", "compactMemory", "findAllDescendantClasses", "", "className", "computeRetainedSizes", "Lcom/android/tools/perflib/heap/analysis/LinkEvalDominators$Result;", "prepareComputeRetainedSizes", "doComputeRetainedSizes", "forEachReachableInstance", "visit", "Lkotlin/Function1;", "getReachableInstances", "getRepresentation", "T", "asClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "getTypeName", "Companion", "android.sdktools.perflib"})
@SourceDebugExtension(value={"SMAP\nSnapshot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Snapshot.kt\ncom/android/tools/perflib/heap/Snapshot\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,304:1\n258#1,7:329\n1#2:305\n1#2:326\n1374#3:306\n1460#3,5:307\n1869#3,2:312\n1869#3,2:314\n1387#3:316\n1475#3,5:317\n1869#3,2:322\n1625#3:324\n1869#3:325\n1870#3:327\n1626#3:328\n*S KotlinDebug\n*F\n+ 1 Snapshot.kt\ncom/android/tools/perflib/heap/Snapshot\n*L\n268#1:329,7\n244#1:326\n148#1:306\n148#1:307,5\n183#1:312,2\n206#1:314,2\n215#1:316\n215#1:317,5\n234#1:322,2\n244#1:324\n244#1:325\n244#1:327\n244#1:328\n*E\n"})
public final class Snapshot
extends Capture {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataBuffer buffer;
    @JvmField
    @NotNull
    public final ArrayList<Heap> heapList;
    @Nullable
    private Heap currentHeap;
    @NotNull
    private ArrayList<RootObj> roots;
    @NotNull
    private Int2ObjectOpenHashMap<StackTrace> traces;
    @NotNull
    private Long2ObjectOpenHashMap<StackFrame> frames;
    private boolean areRetainedSizesComputed;
    @NotNull
    private final ObjectOpenHashSet<ClassObj> referenceClasses;
    @Nullable
    private int[] typeSizes;
    private long idSizeMask;
    @NotNull
    public static final String TYPE_NAME = "hprof";
    @NotNull
    private static final String JAVA_LANG_CLASS = "java.lang.Class";
    @JvmField
    @NotNull
    public static final Instance SENTINEL_ROOT = new RootObj(RootType.UNKNOWN, 0L, 0, null, 14, null);
    private static final int DEFAULT_HEAP_ID = 0;

    @VisibleForTesting
    public Snapshot(@NotNull DataBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
        this.heapList = new ArrayList();
        this.roots = new ArrayList();
        this.traces = new Int2ObjectOpenHashMap();
        this.frames = new Long2ObjectOpenHashMap();
        this.referenceClasses = new ObjectOpenHashSet();
        this.idSizeMask = 0xFFFFFFFFL;
        this.setToDefaultHeap();
    }

    @NotNull
    public final DataBuffer getBuffer() {
        return this.buffer;
    }

    public final long getIdSizeMask() {
        return this.idSizeMask;
    }

    @NotNull
    public final Collection<Heap> getHeaps() {
        return this.heapList;
    }

    @NotNull
    public final Collection<RootObj> getGcRoots() {
        return this.roots;
    }

    public final void dispose() {
        this.buffer.dispose();
    }

    @NotNull
    public final Heap setToDefaultHeap() {
        return this.setHeapTo(0, "default");
    }

    @NotNull
    public final Heap setHeapTo(int id, @NotNull String name) {
        Heap heap;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Heap heap2 = this.getHeap(id);
        if (heap2 == null) {
            Heap heap3;
            Heap it = heap3 = new Heap(id, name);
            boolean bl = false;
            it.mSnapshot = this;
            this.heapList.add(it);
            heap2 = heap3;
        }
        this.currentHeap = heap = heap2;
        return heap;
    }

    public final int getHeapIndex(@NotNull Heap heap) {
        Intrinsics.checkNotNullParameter((Object)heap, (String)"heap");
        return this.heapList.indexOf(heap);
    }

    @Nullable
    public final Heap getHeap(int id) {
        Object v0;
        block1: {
            Iterable iterable = this.heapList;
            for (Object t : iterable) {
                Heap it = (Heap)t;
                boolean bl = false;
                if (!(it.getId() == id)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final Heap getHeap(@NotNull String name) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable iterable = this.heapList;
            for (Object t : iterable) {
                Heap it = (Heap)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final StackFrame addStackFrame(@NotNull StackFrame theFrame) {
        Intrinsics.checkNotNullParameter((Object)theFrame, (String)"theFrame");
        return (StackFrame)this.frames.put(theFrame.mId, (Object)theFrame);
    }

    @Nullable
    public final StackFrame getStackFrame(long id) {
        return (StackFrame)this.frames.get(id);
    }

    public final StackTrace addStackTrace(@NotNull StackTrace theTrace) {
        Intrinsics.checkNotNullParameter((Object)theTrace, (String)"theTrace");
        return (StackTrace)this.traces.put(theTrace.mSerialNumber, (Object)theTrace);
    }

    @Nullable
    public final StackTrace getStackTrace(int traceSerialNumber) {
        return (StackTrace)this.traces.get(traceSerialNumber);
    }

    @Nullable
    public final StackTrace getStackTraceAtDepth(int traceSerialNumber, int depth) {
        StackTrace stackTrace = (StackTrace)this.traces.get(traceSerialNumber);
        return stackTrace != null ? stackTrace.fromDepth(depth) : null;
    }

    public final void addRoot(@NotNull RootObj root2) {
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        this.roots.add(root2);
        root2.setHeap(this.currentHeap);
    }

    public final void addThread(@Nullable ThreadObj thread, int serialNumber) {
        Heap heap = this.currentHeap;
        Intrinsics.checkNotNull((Object)heap);
        heap.addThread(thread, serialNumber);
    }

    @NotNull
    public final ThreadObj getThread(int serialNumber) {
        Heap heap = this.currentHeap;
        Intrinsics.checkNotNull((Object)heap);
        ThreadObj threadObj = heap.getThread(serialNumber);
        Intrinsics.checkNotNullExpressionValue((Object)threadObj, (String)"getThread(...)");
        return threadObj;
    }

    public final void setIdSize(int size) {
        int n;
        int maxId;
        Type[] typeArray = Type.values();
        if (typeArray.length == 0) {
            throw new NoSuchElementException();
        }
        Type it = typeArray[0];
        boolean bl = false;
        int n2 = it.getTypeId();
        int n3 = 1;
        int n4 = ArraysKt.getLastIndex((Object[])typeArray);
        if (n3 <= n4) {
            while (true) {
                Type it2 = typeArray[n3];
                $i$a$-maxOf-Snapshot$setIdSize$maxId$1 = false;
                int n5 = it2.getTypeId();
                if (n2 < n5) {
                    n2 = n5;
                }
                if (n3 == n4) break;
                ++n3;
            }
        }
        int n6 = 1 <= (maxId = n2) ? (maxId <= Type.LONG.getTypeId() ? 1 : 0) : (n = 0);
        if (_Assertions.ENABLED && n == 0) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        n = 0;
        n2 = maxId + 1;
        int[] nArray = new int[n2];
        Snapshot snapshot = this;
        while (n < n2) {
            n4 = n++;
            nArray[n4] = -1;
        }
        snapshot.typeSizes = nArray;
        n2 = Type.values().length;
        for (int i = 0; i < n2; ++i) {
            Intrinsics.checkNotNull((Object)this.typeSizes);
            this.typeSizes[Type.values()[i].getTypeId()] = Type.values()[i].getSize();
        }
        Intrinsics.checkNotNull((Object)this.typeSizes);
        this.typeSizes[Type.OBJECT.getTypeId()] = size;
        this.idSizeMask = -1L >>> (8 - size) * 8;
    }

    public final int getTypeSize(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNull((Object)this.typeSizes);
        return this.typeSizes[type.getTypeId()];
    }

    public final void addInstance(long id, @NotNull Instance instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        Heap heap = this.currentHeap;
        Intrinsics.checkNotNull((Object)heap);
        heap.addInstance(id, instance);
        instance.setHeap(this.currentHeap);
    }

    public final void addClass(long id, @NotNull ClassObj theClass) {
        Intrinsics.checkNotNullParameter((Object)theClass, (String)"theClass");
        Heap heap = this.currentHeap;
        Intrinsics.checkNotNull((Object)heap);
        heap.addClass(id, theClass);
        theClass.setHeap(this.currentHeap);
    }

    @Nullable
    public final Instance findInstance(long id) {
        Instance instance;
        Instance instance2;
        block2: {
            for (Heap it : (Iterable)this.heapList) {
                boolean bl = false;
                Instance instance3 = it.getInstance(id);
                if (instance3 == null) continue;
                instance2 = instance3;
                break block2;
            }
            instance2 = instance = null;
        }
        if (instance2 == null) {
            instance = this.findClass(id);
        }
        return instance;
    }

    @Nullable
    public final ClassObj findClass(long id) {
        ClassObj classObj;
        block1: {
            for (Heap it : (Iterable)this.heapList) {
                boolean bl = false;
                ClassObj classObj2 = it.getClass(id);
                if (classObj2 == null) continue;
                classObj = classObj2;
                break block1;
            }
            classObj = null;
        }
        return classObj;
    }

    @Nullable
    public final ClassObj findClass(@Nullable String name) {
        ClassObj classObj;
        block1: {
            for (Heap it : (Iterable)this.heapList) {
                boolean bl = false;
                ClassObj classObj2 = it.getClass(name);
                if (classObj2 == null) continue;
                classObj = classObj2;
                break block1;
            }
            classObj = null;
        }
        return classObj;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<ClassObj> findClasses(@Nullable String name) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.heapList;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Heap it = (Heap)element$iv$iv;
            boolean bl = false;
            Collection<ClassObj> collection = it.getClasses(name);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getClasses(...)");
            Iterable list$iv$iv = collection;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void resolveClasses() {
        ClassObj clazz;
        ClassObj classObj = clazz = this.findClass(JAVA_LANG_CLASS);
        int javaLangClassSize = classObj != null ? classObj.getInstanceSize() : 0;
        Iterator<Heap> iterator = this.heapList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Heap> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Heap heap;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            for (ClassObj classObj2 : heap.getClasses()) {
                ClassObj superClass;
                ClassObj classObj3 = superClass = classObj2.getSuperClassObj();
                if (classObj3 != null) {
                    Intrinsics.checkNotNull((Object)classObj2);
                    classObj3.addSubclass(classObj2);
                }
                int classSize = javaLangClassSize;
                for (Field f : classObj2.getStaticFields()) {
                    Type type = f.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)type), (String)"getType(...)");
                    classSize += this.getTypeSize(type);
                }
                classObj2.setSize(classSize);
            }
            int heapId = heap.getId();
            heap.forEachInstance(arg_0 -> Snapshot.resolveClasses$lambda$8(heapId, arg_0));
        }
    }

    public final void identifySoftReferences() {
        for (ClassObj classObj : this.findAllDescendantClasses(ClassObj.Companion.getReferenceClassName())) {
            classObj.setIsSoftReference();
            this.referenceClasses.add((Object)classObj);
        }
    }

    public final void resolveReferences() {
        for (Heap heap : this.getHeaps()) {
            Collection<ClassObj> collection = heap.getClasses();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getClasses(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Instance p0 = (Instance)element$iv;
                boolean bl = false;
                p0.resolveReferences();
            }
            heap.forEachInstance(Snapshot::resolveReferences$lambda$9);
        }
    }

    public final void compactMemory() {
        Map cache2 = new LinkedHashMap();
        for (Heap heap : this.getHeaps()) {
            Collection<ClassObj> collection = heap.getClasses();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getClasses(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Instance p0 = (Instance)element$iv;
                boolean bl = false;
                Snapshot.compactMemory$compact(cache2, p0);
            }
            heap.forEachInstance(arg_0 -> Snapshot.compactMemory$lambda$11(cache2, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ClassObj> findAllDescendantClasses(@NotNull String className) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Iterable $this$flatMap$iv = this.findClasses(className);
        boolean $i$f$flatMapSequence = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ClassObj it = (ClassObj)element$iv$iv;
            boolean bl = false;
            Sequence<ClassObj> list$iv$iv = it.getDescendantClasses();
            CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final LinkEvalDominators.Result<Instance> computeRetainedSizes() {
        if (!this.areRetainedSizesComputed) {
            this.areRetainedSizesComputed = true;
            this.prepareComputeRetainedSizes();
            return this.doComputeRetainedSizes();
        }
        return null;
    }

    private final void prepareComputeRetainedSizes() {
        this.resolveReferences();
        this.compactMemory();
        new ShortestDistanceVisitor().doVisit((Iterable<? extends Instance>)this.getGcRoots());
        for (Heap heap : this.getHeaps()) {
            Collection<ClassObj> collection = heap.getClasses();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getClasses(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Instance p0 = (Instance)element$iv;
                boolean bl = false;
                p0.resetRetainedSize();
            }
            heap.forEachInstance(Snapshot::prepareComputeRetainedSizes$lambda$14);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final LinkEvalDominators.Result<Instance> doComputeRetainedSizes() {
        void destination$iv;
        void $this$mapNotNullTo$iv;
        Iterable iterable = this.getGcRoots();
        Collection collection = new LinkedHashSet();
        LinkEvalDominators linkEvalDominators = LinkEvalDominators.INSTANCE;
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            Instance it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            RootObj p0 = (RootObj)element$iv;
            boolean bl2 = false;
            if (p0.getReferredInstance() == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        LinkEvalDominators.Result<Instance> result2 = linkEvalDominators.computeDominators((Set)destination$iv, Snapshot::doComputeRetainedSizes$lambda$16);
        List instances = result2.component1();
        List immDom = result2.component2();
        int n = ((Collection)instances).size() + -1;
        if (0 <= n) {
            do {
                int i = n--;
                Instance instance = (Instance)immDom.get(i);
                if (instance == null) continue;
                Object t = instances.get(i);
                Intrinsics.checkNotNull(t);
                instance.addRetainedSizes((Instance)t);
            } while (0 <= n);
        }
        return result2;
    }

    private final void forEachReachableInstance(Function1<? super Instance, Unit> visit) {
        boolean $i$f$forEachReachableInstance = false;
        new NonRecursiveVisitor(visit){
            final /* synthetic */ Function1<Instance, Unit> $visit;
            {
                this.$visit = $visit;
            }

            protected void defaultAction(Instance instance) {
                Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
                if (instance.isReachable()) {
                    this.$visit.invoke((Object)instance);
                }
            }
        }.doVisit((Iterable<? extends Instance>)this.getGcRoots());
    }

    @NotNull
    public final List<Instance> getReachableInstances() {
        ArrayList result2 = new ArrayList();
        Snapshot this_$iv = this;
        boolean $i$f$forEachReachableInstance = false;
        new NonRecursiveVisitor(result2){
            final /* synthetic */ ArrayList receiver$inlined;
            {
                this.receiver$inlined = arrayList;
            }

            protected void defaultAction(Instance instance) {
                Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
                if (instance.isReachable()) {
                    Instance p0 = instance;
                    boolean bl = false;
                    this.receiver$inlined.add(p0);
                }
            }
        }.doVisit((Iterable<? extends Instance>)this_$iv.getGcRoots());
        return result2;
    }

    @Override
    @Nullable
    public <T> T getRepresentation(@NotNull Class<T> asClass) {
        Intrinsics.checkNotNullParameter(asClass, (String)"asClass");
        return asClass.isAssignableFrom(this.getClass()) ? (T)asClass.cast(this) : null;
    }

    @Override
    @NotNull
    public String getTypeName() {
        return TYPE_NAME;
    }

    private static final Boolean resolveClasses$lambda$8(int $heapId, Instance instance) {
        block0: {
            ClassObj classObj;
            ClassObj classObj2 = classObj = instance.getClassObj();
            if (classObj2 == null) break block0;
            Intrinsics.checkNotNull((Object)instance);
            classObj2.addInstance($heapId, instance);
        }
        return true;
    }

    private static final Boolean resolveReferences$lambda$9(Instance instance) {
        instance.resolveReferences();
        return true;
    }

    private static final Object compactMemory$compactList(Map<Set<Instance>, InstanceList> cache2, Object insts) {
        return ((InstanceList)InstanceList.onCases-impl(insts, (Function1)new Function1<Instance, InstanceList>((Object)InstanceList.Companion){

            public final Object invoke-GO6bYc0(Instance p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((InstanceList.Companion)this.receiver).of-GO6bYc0(p0);
            }
        }, (Function1)new Function1<Instance[], InstanceList>(cache2){
            final /* synthetic */ Map<Set<Instance>, InstanceList> $cache;
            {
                this.$cache = $cache;
            }

            /*
             * WARNING - void declaration
             */
            public final Object invoke-GO6bYc0(Instance[] it) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it.length == 0) {
                    object = InstanceList.Companion.getEmpty-s3XpT2Q();
                } else {
                    Object object2;
                    void $this$getOrPut$iv;
                    HashSet hashSet = SequencesKt.toHashSet((Sequence)SequencesKt.filterNotNull((Sequence)ArraysKt.asSequence((Object[])it)));
                    Map<Set<Instance>, InstanceList> map2 = this.$cache;
                    HashSet elems = hashSet;
                    boolean bl = false;
                    Map<Set<Instance>, InstanceList> map3 = map2;
                    HashSet key$iv = elems;
                    boolean $i$f$getOrPut = false;
                    V value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl2 = false;
                        Collection $this$toTypedArray$iv = elems;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        InstanceList answer$iv = InstanceList.box-impl(InstanceList.Companion.of-GO6bYc0(thisCollection$iv.toArray(new Instance[0])));
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object2 = answer$iv;
                    } else {
                        object2 = value$iv;
                    }
                    object = ((InstanceList)object2).unbox-impl();
                }
                return object;
            }
        })).unbox-impl();
    }

    private static final void compactMemory$compact(Map<Set<Instance>, InstanceList> cache2, Instance inst) {
        inst.set_hardFwdRefs-OLAdukE$android_sdktools_perflib(Snapshot.compactMemory$compactList(cache2, inst.get_hardFwdRefs-s3XpT2Q$android_sdktools_perflib()));
        inst.set_hardRevRefs-OLAdukE$android_sdktools_perflib(Snapshot.compactMemory$compactList(cache2, inst.get_hardRevRefs-s3XpT2Q$android_sdktools_perflib()));
        inst.set_softRevRefs-OLAdukE(Snapshot.compactMemory$compactList(cache2, inst.get_softRevRefs-s3XpT2Q()));
    }

    private static final Boolean compactMemory$lambda$11(Map $cache, Instance instance) {
        Intrinsics.checkNotNull((Object)instance);
        Snapshot.compactMemory$compact($cache, instance);
        return true;
    }

    private static final Boolean prepareComputeRetainedSizes$lambda$14(Instance it) {
        it.resetRetainedSize();
        return true;
    }

    private static final Stream doComputeRetainedSizes$lambda$16(Instance it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StreamsKt.asStream(it.getHardForwardReferences());
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Snapshot createSnapshot(@NotNull DataBuffer buffer, @NotNull ProguardMap map2, @NotNull List<? extends SnapshotPostProcessor> postProcessors) {
        return Companion.createSnapshot(buffer, map2, postProcessors);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Snapshot createSnapshot(@NotNull DataBuffer buffer, @NotNull ProguardMap map2) {
        return Companion.createSnapshot(buffer, map2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Snapshot createSnapshot(@NotNull DataBuffer buffer) {
        return Companion.createSnapshot(buffer);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/perflib/heap/Snapshot$Companion;", "", "<init>", "()V", "TYPE_NAME", "", "JAVA_LANG_CLASS", "SENTINEL_ROOT", "Lcom/android/tools/perflib/heap/Instance;", "DEFAULT_HEAP_ID", "", "createSnapshot", "Lcom/android/tools/perflib/heap/Snapshot;", "buffer", "Lcom/android/tools/perflib/captures/DataBuffer;", "map", "Lcom/android/tools/proguard/ProguardMap;", "postProcessors", "", "Lcom/android/tools/perflib/heap/ext/SnapshotPostProcessor;", "android.sdktools.perflib"})
    @SourceDebugExtension(value={"SMAP\nSnapshot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Snapshot.kt\ncom/android/tools/perflib/heap/Snapshot$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,304:1\n1869#2,2:305\n*S KotlinDebug\n*F\n+ 1 Snapshot.kt\ncom/android/tools/perflib/heap/Snapshot$Companion\n*L\n296#1:305,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Snapshot createSnapshot(@NotNull DataBuffer buffer, @NotNull ProguardMap map2, @NotNull List<? extends SnapshotPostProcessor> postProcessors) {
            Snapshot snapshot;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Intrinsics.checkNotNullParameter((Object)map2, (String)"map");
            Intrinsics.checkNotNullParameter(postProcessors, (String)"postProcessors");
            try {
                Snapshot snapshot2 = snapshot = new Snapshot(buffer);
                boolean bl = false;
                HprofParser.parseBuffer(snapshot2, buffer, map2);
                Iterable $this$forEach$iv = postProcessors;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SnapshotPostProcessor it = (SnapshotPostProcessor)element$iv;
                    boolean bl2 = false;
                    it.postProcess(snapshot2);
                }
            }
            catch (RuntimeException e) {
                buffer.dispose();
                throw e;
            }
            return snapshot;
        }

        public static /* synthetic */ Snapshot createSnapshot$default(Companion companion, DataBuffer dataBuffer, ProguardMap proguardMap, List list2, int n, Object object) {
            if ((n & 2) != 0) {
                proguardMap = new ProguardMap();
            }
            if ((n & 4) != 0) {
                list2 = CollectionsKt.listOf((Object)new NativeRegistryPostProcessor());
            }
            return companion.createSnapshot(dataBuffer, proguardMap, list2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Snapshot createSnapshot(@NotNull DataBuffer buffer, @NotNull ProguardMap map2) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Intrinsics.checkNotNullParameter((Object)map2, (String)"map");
            return com.android.tools.perflib.heap.Snapshot$Companion.createSnapshot$default(this, buffer, map2, null, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Snapshot createSnapshot(@NotNull DataBuffer buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            return com.android.tools.perflib.heap.Snapshot$Companion.createSnapshot$default(this, buffer, null, null, 6, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

