/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.ThreadObj;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collection;
import java.util.function.Function;

public class Heap {
    private final int mId;
    private final String mName;
    Int2ObjectMap<ThreadObj> mThreads = new Int2ObjectOpenHashMap();
    Long2ObjectMap<ClassObj> mClassesById = new Long2ObjectOpenHashMap();
    Multimap<String, ClassObj> mClassesByName = ArrayListMultimap.create();
    private final Long2ObjectMap<Instance> mInstances = new Long2ObjectOpenHashMap();
    Snapshot mSnapshot;

    public Heap(int id, String name) {
        this.mId = id;
        this.mName = name;
    }

    public int getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public final void addThread(ThreadObj thread, int serialNumber) {
        this.mThreads.put(serialNumber, (Object)thread);
    }

    public final ThreadObj getThread(int serialNumber) {
        return (ThreadObj)this.mThreads.get(serialNumber);
    }

    public final void addInstance(long id, Instance instance) {
        this.mInstances.put(id, (Object)instance);
    }

    public final Instance getInstance(long id) {
        return (Instance)this.mInstances.get(id);
    }

    public final void addClass(long id, ClassObj theClass) {
        this.mClassesById.put(id, (Object)theClass);
        this.mClassesByName.put((Object)theClass.getClassName(), (Object)theClass);
    }

    public final ClassObj getClass(long id) {
        return (ClassObj)this.mClassesById.get(id);
    }

    public final ClassObj getClass(String name) {
        Collection classes = this.mClassesByName.get((Object)name);
        if (classes.size() == 1) {
            return (ClassObj)classes.iterator().next();
        }
        return null;
    }

    public final Collection<ClassObj> getClasses(String name) {
        return this.mClassesByName.get((Object)name);
    }

    public final void dumpInstanceCounts() {
        for (ClassObj theClass : this.mClassesById.values()) {
            int count = theClass.getInstanceCount();
            if (count <= 0) continue;
            System.out.println(String.valueOf(theClass) + ": " + count);
        }
    }

    public final void dumpSubclasses() {
        for (ClassObj theClass : this.mClassesById.values()) {
            int count = theClass.getSubclasses().size();
            if (count <= 0) continue;
            System.out.println(theClass);
            theClass.dumpSubclasses();
        }
    }

    public final void dumpSizes() {
        for (ClassObj theClass : this.mClassesById.values()) {
            int size = 0;
            for (Instance instance : theClass.getHeapInstances(this.getId())) {
                size += instance.getCompositeSize();
            }
            if (size <= 0) continue;
            System.out.println(String.valueOf(theClass) + ": base " + theClass.getSize() + ", composite " + size);
        }
    }

    public Collection<ClassObj> getClasses() {
        return this.mClassesByName.values();
    }

    public void forEachInstance(Function<Instance, Boolean> procedure) {
        for (Instance instance : this.mInstances.values()) {
            if (procedure.apply(instance).booleanValue()) continue;
            return;
        }
    }

    public int getInstancesCount() {
        return this.mInstances.size();
    }
}

