/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.annotations.TestOnly;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.ConfigurationHierarchy;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintTomlValue;
import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.client.api.Vendor;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Constraint;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.LocationType;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.CharSequences;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 ]2\u00020\u0001:\u0001]B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010#\u001a\u00020\u0016J\n\u0010(\u001a\u0004\u0018\u00010\nH\u0016J\u001c\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u00100\u001a\u000201H\u0016J\u0018\u00102\u001a\u00020.2\u0006\u0010/\u001a\u0002032\u0006\u00100\u001a\u000201H\u0002J\u000e\u00104\u001a\u00020\u00162\u0006\u00105\u001a\u000206J,\u00107\u001a\u0002082\u0006\u00105\u001a\u0002062\u0006\u00109\u001a\u00020.2\u0006\u0010:\u001a\u00020;2\n\b\u0002\u0010<\u001a\u0004\u0018\u00010=H\u0017J\u000e\u00107\u001a\u0002082\u0006\u0010>\u001a\u00020?J\u0006\u0010@\u001a\u00020\u0016J\u0016\u00107\u001a\u0002082\u0006\u0010>\u001a\u00020?2\u0006\u0010A\u001a\u00020BJ\u0016\u00107\u001a\u0002082\u0006\u0010>\u001a\u00020?2\u0006\u0010C\u001a\u00020DJ\u000e\u0010E\u001a\u00020F2\u0006\u00105\u001a\u000206J\u000e\u0010G\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bJ3\u0010H\u001a\u0002082\b\u0010I\u001a\u0004\u0018\u00010J2\b\u0010K\u001a\u0004\u0018\u00010;2\u0012\u0010L\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010M\"\u00020\u0001\u00a2\u0006\u0002\u0010NJ\u001e\u0010S\u001a\u0002082\u0006\u0010T\u001a\u00020U2\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019J\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010Y\u001a\u00020\u00162\u0006\u0010Z\u001a\u00020P2\u0006\u00105\u001a\u000206R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0010R\u0011\u0010$\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0011\u0010)\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0011\u0010O\u001a\u00020P8F\u00a2\u0006\u0006\u001a\u0004\bQ\u0010RR\u0016\u0010V\u001a\u0004\u0018\u00010;8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\bW\u0010XR\u0014\u0010[\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\\\u0010\u001e\u00a8\u0006^"}, d2={"Lcom/android/tools/lint/detector/api/Context;", "", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "project", "Lcom/android/tools/lint/detector/api/Project;", "main", "file", "Ljava/io/File;", "contents", "", "<init>", "(Lcom/android/tools/lint/client/api/LintDriver;Lcom/android/tools/lint/detector/api/Project;Lcom/android/tools/lint/detector/api/Project;Ljava/io/File;Ljava/lang/CharSequence;)V", "getDriver", "()Lcom/android/tools/lint/client/api/LintDriver;", "getProject", "()Lcom/android/tools/lint/detector/api/Project;", "configuration", "Lcom/android/tools/lint/client/api/Configuration;", "getConfiguration", "()Lcom/android/tools/lint/client/api/Configuration;", "containsCommentSuppress", "", "Ljava/lang/Boolean;", "scope", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Scope;", "getScope", "()Ljava/util/EnumSet;", "isTestSource", "()Z", "setTestSource", "(Z)V", "mainProject", "getMainProject", "isMainProject", "client", "Lcom/android/tools/lint/client/api/LintClient;", "getClient", "()Lcom/android/tools/lint/client/api/LintClient;", "getContents", "sdkInfo", "Lcom/android/tools/lint/client/api/SdkInfo;", "getSdkInfo", "()Lcom/android/tools/lint/client/api/SdkInfo;", "getLocation", "Lcom/android/tools/lint/detector/api/Location;", "node", "type", "Lcom/android/tools/lint/detector/api/LocationType;", "findNodeInProject", "Lorg/w3c/dom/Node;", "isEnabled", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "report", "", "location", "message", "", "quickfixData", "Lcom/android/tools/lint/detector/api/LintFix;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "isGlobalAnalysis", "constraint", "Lcom/android/tools/lint/detector/api/Constraint;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "getPartialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "findConfiguration", "log", "exception", "", "format", "args", "", "(Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "phase", "", "getPhase", "()I", "requestRepeat", "detector", "Lcom/android/tools/lint/detector/api/Detector;", "suppressCommentPrefix", "getSuppressCommentPrefix", "()Ljava/lang/String;", "isSuppressedWithComment", "startOffset", "forbidMainAccess", "getForbidMainAccess", "Companion", "android.sdktools.lint-api"})
@SourceDebugExtension(value={"SMAP\nContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Context.kt\ncom/android/tools/lint/detector/api/Context\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,793:1\n1#2:794\n774#3:795\n865#3,2:796\n*S KotlinDebug\n*F\n+ 1 Context.kt\ncom/android/tools/lint/detector/api/Context\n*L\n318#1:795\n318#1:796,2\n*E\n"})
public class Context {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LintDriver driver;
    @NotNull
    private final Project project;
    @Nullable
    private final Project main;
    @JvmField
    @NotNull
    public final File file;
    @Nullable
    private CharSequence contents;
    @NotNull
    private final Configuration configuration;
    @Nullable
    private Boolean containsCommentSuppress;
    private boolean isTestSource;
    @NotNull
    public static final String SUPPRESS_XML_COMMENT_PREFIX = "<!--suppress ";
    @NotNull
    public static final String SUPPRESS_JAVA_COMMENT_PREFIX = "noinspection ";
    @Nullable
    private static Set<String> detectorsWarned;

    public Context(@NotNull LintDriver driver, @NotNull Project project, @Nullable Project main2, @NotNull File file, @Nullable CharSequence contents) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.driver = driver;
        this.project = project;
        this.main = main2;
        this.file = file;
        this.contents = contents;
        Configuration configuration = this.getClient().getConfiguration(this.file);
        if (configuration == null) {
            Configuration configuration2 = this.project.getConfiguration(this.driver);
            configuration = configuration2;
            Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"getConfiguration(...)");
        }
        this.configuration = configuration;
        this.isTestSource = Intrinsics.areEqual((Object)this.project.isTestProject(), (Object)true);
    }

    public /* synthetic */ Context(LintDriver lintDriver, Project project, Project project2, File file, CharSequence charSequence, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            charSequence = null;
        }
        this(lintDriver, project, project2, file, charSequence);
    }

    @NotNull
    public final LintDriver getDriver() {
        return this.driver;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Configuration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final EnumSet<Scope> getScope() {
        return this.driver.getScope();
    }

    public final boolean isTestSource() {
        return this.isTestSource;
    }

    public final void setTestSource(boolean bl) {
        this.isTestSource = bl;
    }

    @NotNull
    public final Project getMainProject() {
        boolean forbidden;
        if (this.getForbidMainAccess() && (forbidden = com.android.tools.lint.detector.api.Context$Companion.checkForbidden$default(Companion, "context.getMainProject()", this.file, this.driver, null, 8, null))) {
            return this.project;
        }
        Project project = this.main;
        if (project == null) {
            project = this.project;
        }
        return project;
    }

    public final boolean isMainProject() {
        return this.project == this.main;
    }

    @NotNull
    public final LintClient getClient() {
        return this.driver.getClient();
    }

    @Nullable
    public CharSequence getContents() {
        if (this.contents == null) {
            this.contents = this.driver.getClient().readFile(this.file);
        }
        return this.contents;
    }

    @NotNull
    public final SdkInfo getSdkInfo() {
        SdkInfo sdkInfo = this.project.getSdkInfo();
        Intrinsics.checkNotNullExpressionValue((Object)sdkInfo, (String)"getSdkInfo(...)");
        return sdkInfo;
    }

    @NotNull
    public Location getLocation(@Nullable Object node, @NotNull LocationType type) {
        Object object;
        block62: {
            JavaContext javaContext;
            block64: {
                JavaContext javaContext2;
                Object object2;
                block66: {
                    block65: {
                        block63: {
                            block57: {
                                JavaContext javaContext3;
                                block59: {
                                    JavaContext javaContext4;
                                    Object object3;
                                    block61: {
                                        block60: {
                                            block58: {
                                                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                                                if (node == null) {
                                                    return Location.NONE;
                                                }
                                                object = node;
                                                if (!(object instanceof UElement)) break block57;
                                                if (!(this instanceof JavaContext)) break block58;
                                                javaContext3 = (JavaContext)this;
                                                break block59;
                                            }
                                            object3 = ((UElement)node).getSourcePsi();
                                            if (object3 == null || (object3 = object3.getContainingFile()) == null || (object3 = object3.getVirtualFile()) == null) break block60;
                                            Object it = object3;
                                            boolean bl = false;
                                            File file = VfsUtilCore.virtualToIoFile((VirtualFile)it);
                                            object3 = file;
                                            if (file != null) break block61;
                                        }
                                        object3 = this.file;
                                    }
                                    Object file = object3;
                                    JavaContext $this$getLocation_u24lambda_u241 = javaContext4 = new JavaContext(this.driver, this.project, this.main, (File)file);
                                    boolean bl = false;
                                    $this$getLocation_u24lambda_u241.setUastParser($this$getLocation_u24lambda_u241.getClient().getUastParser($this$getLocation_u24lambda_u241.getProject()));
                                    javaContext3 = javaContext4;
                                }
                                JavaContext context2 = javaContext3;
                                return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                                    case 1 -> context2.getLocation((UElement)node);
                                    case 2 -> {
                                        if (node instanceof UCallExpression) {
                                            yield context2.getCallLocation((UCallExpression)node, true, true);
                                        }
                                        yield context2.getUastParser().getLocation(context2, (UElement)node);
                                    }
                                    case 3 -> context2.getNameLocation((UElement)node);
                                    case 4 -> context2.getCallLocation((UCallExpression)node, false, true);
                                    case 5 -> context2.getCallLocation((UCallExpression)node, true, false);
                                    case 6 -> throw new IllegalStateException((type + " not supported for " + node.getClass()).toString());
                                    default -> throw new NoWhenBranchMatchedException();
                                };
                            }
                            if (!(object instanceof PsiElement)) break block62;
                            if (!(this instanceof JavaContext)) break block63;
                            javaContext = (JavaContext)this;
                            break block64;
                        }
                        object2 = ((PsiElement)node).getContainingFile();
                        if (object2 == null || (object2 = object2.getVirtualFile()) == null) break block65;
                        Object it = object2;
                        boolean bl = false;
                        File file = VfsUtilCore.virtualToIoFile((VirtualFile)it);
                        object2 = file;
                        if (file != null) break block66;
                    }
                    object2 = this.file;
                }
                Object file = object2;
                JavaContext $this$getLocation_u24lambda_u243 = javaContext2 = new JavaContext(this.driver, this.project, this.main, (File)file);
                boolean bl = false;
                $this$getLocation_u24lambda_u243.setUastParser($this$getLocation_u24lambda_u243.getClient().getUastParser($this$getLocation_u24lambda_u243.getProject()));
                javaContext = javaContext2;
            }
            JavaContext context3 = javaContext;
            return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1 -> context3.getLocation((PsiElement)node);
                case 2 -> context3.getLocation((PsiElement)node);
                case 3 -> context3.getNameLocation((PsiElement)node);
                case 4, 5 -> context3.getLocation((PsiElement)node);
                case 6 -> throw new IllegalStateException((type + " not supported for " + node.getClass()).toString());
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        if (object instanceof Node) {
            XmlContext xmlContext;
            if (this.getClient().isMergeManifestNode((Node)node)) {
                com.android.utils.Pair<File, ? extends Node> source;
                if (Intrinsics.areEqual((Object)((Node)node).getNodeName(), (Object)"application")) {
                    Node node2 = ((Node)node).getParentNode();
                    if (Intrinsics.areEqual((Object)(node2 != null ? node2.getNodeName() : null), (Object)"manifest")) {
                        return this.findNodeInProject((Node)node, type);
                    }
                }
                if ((source = this.getClient().findManifestSourceNode((Node)node)) != null && source.getSecond() != node) {
                    if (Intrinsics.areEqual((Object)source.getFirst(), (Object)this.file)) {
                        return this.getLocation(source.getSecond(), type);
                    }
                    Document doc = ((Node)node).getOwnerDocument();
                    Object object4 = source.getFirst();
                    Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"getFirst(...)");
                    File file = (File)object4;
                    Intrinsics.checkNotNull((Object)doc);
                    XmlContext xmlContext2 = new XmlContext(this.driver, this.project, this.main, file, null, null, doc);
                    return xmlContext2.getLocation(source.getSecond(), type);
                }
            }
            String string2 = this.file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            if (!StringsKt.endsWith$default((String)string2, (String)".xml", (boolean)false, (int)2, null)) {
                return this.findNodeInProject((Node)node, type);
            }
            if (this instanceof XmlContext) {
                xmlContext = (XmlContext)this;
            } else {
                Document doc = ((Node)node).getOwnerDocument();
                Object object5 = doc.getUserData(File.class.getName());
                File file = object5 instanceof File ? (File)object5 : null;
                if (file == null) {
                    File file2;
                    Object object6 = doc.getUserData(PsiFile.class.getName());
                    PsiFile psiFile = object6 instanceof PsiFile ? (PsiFile)object6 : null;
                    if (psiFile != null && (psiFile = psiFile.getVirtualFile()) != null) {
                        PsiFile it = psiFile;
                        boolean bl = false;
                        file2 = VfsUtilCore.virtualToIoFile((VirtualFile)it);
                    } else {
                        file2 = file = null;
                    }
                    if (file2 == null) {
                        List<File> list2 = this.project.getManifestFiles();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"getManifestFiles(...)");
                        File file3 = (File)CollectionsKt.firstOrNull(list2);
                        if (file3 == null) {
                            file3 = this.project.dir;
                        }
                        File file4 = file3;
                        Intrinsics.checkNotNull((Object)file4);
                        return Location.Companion.create(file4);
                    }
                }
                File file5 = file;
                Intrinsics.checkNotNull((Object)doc);
                xmlContext = new XmlContext(this.driver, this.project, this.main, file5, null, null, doc);
            }
            XmlContext context4 = xmlContext;
            return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 2 -> context4.getLocation((Node)node);
                case 1 -> {
                    if (node instanceof Element) {
                        yield context4.getElementLocation((Element)node);
                    }
                    yield context4.getLocation((Node)node);
                }
                case 3 -> context4.getNameLocation((Node)node);
                case 6 -> {
                    if (node instanceof Attr) {
                        yield context4.getValueLocation((Attr)node);
                    }
                    yield context4.getLocation((Node)node);
                }
                case 4, 5 -> throw new IllegalStateException((type + " not supported for " + node.getClass()).toString());
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        if (object instanceof LintTomlValue) {
            Location location;
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 2: {
                    location = ((LintTomlValue)node).getFullLocation();
                    break;
                }
                case 3: {
                    location = ((LintTomlValue)node).getKeyLocation();
                    if (location != null) break;
                    location = ((LintTomlValue)node).getLocation();
                    break;
                }
                case 1: {
                    location = ((LintTomlValue)node).getLocation();
                    break;
                }
                default: {
                    location = ((LintTomlValue)node).getLocation();
                }
            }
            return location;
        }
        if (object instanceof ClassNode) {
            if (this instanceof ClassContext) {
                return ((ClassContext)this).getLocation((ClassNode)node);
            }
            throw new IllegalStateException("Can only get ClassNode locations on a ClassContext".toString());
        }
        if (object instanceof AbstractInsnNode) {
            if (this instanceof ClassContext) {
                return ((ClassContext)this).getLocation((AbstractInsnNode)node);
            }
            throw new IllegalStateException("Can only get AbstractInsnNode locations on a ClassContext".toString());
        }
        if (this instanceof GradleContext) {
            return ((GradleContext)this).getLocation(node);
        }
        return Location.Companion.create(this.file);
    }

    public static /* synthetic */ Location getLocation$default(Context context2, Object object, LocationType locationType, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getLocation");
        }
        if ((n & 2) != 0) {
            locationType = LocationType.DEFAULT;
        }
        return context2.getLocation(object, locationType);
    }

    /*
     * WARNING - void declaration
     */
    private final Location findNodeInProject(Node node, LocationType type) {
        Element element;
        Object object = node;
        Element element2 = object instanceof Element ? (Element)node : (element = object instanceof Attr ? ((Attr)node).getOwnerElement() : null);
        if (element != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Object object2 = new Project[]{this.project};
            Sequence sequence2 = SequencesKt.sequenceOf((Object[])object2);
            List<Project> list2 = this.project.getAllLibraries();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getAllLibraries(...)");
            object2 = list2;
            Sequence sequence3 = sequence2;
            boolean $i$f$filter = false;
            Iterator<File> iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Project it = (Project)element$iv$iv;
                boolean bl = false;
                if (!(!it.isExternalLibrary())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Sequence projects = SequencesKt.plus((Sequence)sequence3, (Iterable)((List)destination$iv$iv));
            for (Project p : projects) {
                for (File manifest : p.getManifestFiles()) {
                    try {
                        Document document;
                        Node sourceNode;
                        XmlParser xmlParser = this.getClient().getXmlParser();
                        Intrinsics.checkNotNull((Object)manifest);
                        if (xmlParser.parseXml(manifest) == null || (sourceNode = (Node)Lint.matchXmlElement(element, document)) == null || sourceNode == element) continue;
                        Document doc = node.getOwnerDocument();
                        Intrinsics.checkNotNull((Object)p);
                        Intrinsics.checkNotNull((Object)doc);
                        XmlContext xmlContext = new XmlContext(this.driver, p, this.main, manifest, null, null, doc);
                        return xmlContext.getLocation(sourceNode, type);
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
        List<File> list3 = this.project.getManifestFiles();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"getManifestFiles(...)");
        File file = (File)CollectionsKt.firstOrNull(list3);
        if (file == null) {
            file = this.project.dir;
        }
        object = file;
        Intrinsics.checkNotNull((Object)object);
        return Location.Companion.create((File)object);
    }

    public final boolean isEnabled(@NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        return this.configuration.isEnabled(issue);
    }

    @JvmOverloads
    public void report(@NotNull Issue issue, @NotNull Location location, @NotNull String message, @Nullable LintFix quickfixData) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Incident incident = new Incident(issue, location, message, quickfixData);
        LintClient.report$default(this.driver.getClient(), this, incident, null, 4, null);
    }

    public static /* synthetic */ void report$default(Context context2, Issue issue, Location location, String string2, LintFix lintFix, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: report");
        }
        if ((n & 8) != 0) {
            lintFix = null;
        }
        context2.report(issue, location, string2, lintFix);
    }

    public final void report(@NotNull Incident incident) {
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        LintClient.report$default(this.driver.getClient(), this, incident, null, 4, null);
    }

    public final boolean isGlobalAnalysis() {
        return this.driver.isGlobalAnalysis();
    }

    public final void report(@NotNull Incident incident, @NotNull Constraint constraint) {
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
        this.getClient().report(this, incident, constraint);
    }

    public final void report(@NotNull Incident incident, @NotNull LintMap map2) {
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map2, (String)"map");
        this.getClient().report(this, incident, map2);
    }

    @NotNull
    public final PartialResult getPartialResults(@NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        return this.getClient().getPartialResults(this.project, issue);
    }

    @NotNull
    public final Configuration findConfiguration(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ConfigurationHierarchy configurations = this.driver.getClient().getConfigurations();
        File dir = file.getParentFile();
        Object object = ConfigurationHierarchy.getConfigurationForFolder$default(configurations, dir, null, 2, null);
        if (object == null) {
            Context $this$findConfiguration_u24lambda_u246 = this;
            boolean bl = false;
            Project project = $this$findConfiguration_u24lambda_u246.driver.findProjectFor(file);
            object = project;
            if (object == null || (object = ((Project)object).getConfiguration($this$findConfiguration_u24lambda_u246.driver)) == null) {
                object = $this$findConfiguration_u24lambda_u246.configuration;
            }
        }
        return object;
    }

    public final void log(@Nullable Throwable exception, @Nullable String format, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.driver.getClient().log(exception, format, Arrays.copyOf(args, args.length));
    }

    public final int getPhase() {
        return this.driver.getPhase();
    }

    public final void requestRepeat(@NotNull Detector detector, @Nullable EnumSet<Scope> scope) {
        Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
        this.driver.requestRepeat(detector, scope);
    }

    @Nullable
    protected String getSuppressCommentPrefix() {
        String path = this.file.getPath();
        Intrinsics.checkNotNull((Object)path);
        if (StringsKt.endsWith$default((String)path, (String)".java", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path, (String)".gradle", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path, (String)".kts", (boolean)false, (int)2, null)) {
            return SUPPRESS_JAVA_COMMENT_PREFIX;
        }
        if (StringsKt.endsWith$default((String)path, (String)".xml", (boolean)false, (int)2, null)) {
            return SUPPRESS_XML_COMMENT_PREFIX;
        }
        if (StringsKt.endsWith$default((String)path, (String)".cfg", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path, (String)".pro", (boolean)false, (int)2, null)) {
            return "#suppress ";
        }
        return null;
    }

    public final boolean containsCommentSuppress() {
        if (this.containsCommentSuppress == null) {
            CharSequence contents;
            this.containsCommentSuppress = false;
            String prefix = this.getSuppressCommentPrefix();
            if (prefix != null && (contents = this.getContents()) != null) {
                this.containsCommentSuppress = CharSequences.indexOf((CharSequence)contents, (CharSequence)prefix) != -1;
            }
        }
        Boolean bl = this.containsCommentSuppress;
        Intrinsics.checkNotNull((Object)bl);
        return bl;
    }

    public final boolean isSuppressedWithComment(int startOffset, @NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        String string2 = this.getSuppressCommentPrefix();
        if (string2 == null) {
            return false;
        }
        String prefix = string2;
        CharSequence charSequence = this.getContents();
        if (charSequence == null) {
            charSequence = "";
        }
        String string3 = Companion.getSuppressionDirective(prefix, charSequence, startOffset);
        if (string3 == null) {
            return false;
        }
        String line = string3;
        return Companion.isSuppressedWithComment(line, issue);
    }

    private final boolean getForbidMainAccess() {
        return this.driver.getMode() == LintDriver.DriverMode.ANALYSIS_ONLY;
    }

    @JvmOverloads
    public final void report(@NotNull Issue issue, @NotNull Location location, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Context.report$default(this, issue, location, message, null, 8, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J \u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0005H\u0002J\b\u0010!\u001a\u00020\"H\u0007J*\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(2\b\b\u0002\u0010)\u001a\u00020\u0005J\"\u0010*\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110,\u0018\u00010+2\u0006\u0010'\u001a\u00020(R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/android/tools/lint/detector/api/Context$Companion;", "", "<init>", "()V", "SUPPRESS_XML_COMMENT_PREFIX", "", "SUPPRESS_JAVA_COMMENT_PREFIX", "getSuppressionDirective", "prefix", "source", "", "startOffset", "", "isSuppressedWithComment", "", "line", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "category", "Lcom/android/tools/lint/detector/api/Category;", "lineContainsId", "id", "isWord", "word", "index", "isWordDelimiter", "c", "", "findPrefixOnPreviousLine", "contents", "lineStart", "detectorsWarned", "", "clearDetectorWarnings", "", "checkForbidden", "methodName", "file", "Ljava/io/File;", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "extraMessage", "findCallingDetector", "Lkotlin/Pair;", "", "android.sdktools.lint-api"})
    @SourceDebugExtension(value={"SMAP\nContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Context.kt\ncom/android/tools/lint/detector/api/Context$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,793:1\n1761#2,3:794\n1617#2,9:798\n1869#2:807\n1870#2:809\n1626#2:810\n1056#2:811\n1#3:797\n1#3:808\n*S KotlinDebug\n*F\n+ 1 Context.kt\ncom/android/tools/lint/detector/api/Context$Companion\n*L\n592#1:794,3\n715#1:798,9\n715#1:807\n715#1:809\n715#1:810\n717#1:811\n715#1:808\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getSuppressionDirective(@NotNull String prefix, @NotNull CharSequence source, int startOffset) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (StringsKt.startsWith$default((CharSequence)source, (CharSequence)"//", (int)startOffset, (boolean)false, (int)4, null) || StringsKt.startsWith$default((CharSequence)source, (CharSequence)"/*", (boolean)false, (int)2, null)) {
                int end2;
                int index2;
                for (index2 = startOffset + 2; index2 < source.length() && source.charAt(index2) == ' '; ++index2) {
                }
                if (CharSequences.regionMatches((CharSequence)source, (int)index2, (CharSequence)prefix, (int)0, (int)prefix.length()) && (end2 = StringsKt.indexOf$default((CharSequence)source, (char)'\n', (int)index2, (boolean)false, (int)4, null)) != -1) {
                    return ((Object)source.subSequence(index2 + prefix.length(), end2)).toString();
                }
            }
            if (startOffset <= 0) {
                return null;
            }
            if (startOffset >= source.length()) {
                return null;
            }
            int lineStart = StringsKt.lastIndexOf$default((CharSequence)source, (char)'\n', (int)startOffset, (boolean)false, (int)4, null) + 1;
            if (lineStart <= 1) {
                return null;
            }
            int index3 = this.findPrefixOnPreviousLine(source, lineStart, prefix);
            if (index3 != -1 && index3 + prefix.length() < lineStart) {
                return ((Object)source.subSequence(index3 + prefix.length(), lineStart)).toString();
            }
            return null;
        }

        @VisibleForTesting
        public final boolean isSuppressedWithComment(@NotNull String line, @NotNull Issue issue) {
            boolean bl;
            block4: {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
                Iterable $this$any$iv = issue.getAliases();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String alias = (String)element$iv;
                        boolean bl2 = false;
                        if (!Companion.lineContainsId(line, alias)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return true;
            }
            return this.lineContainsId(line, issue.getId()) || this.lineContainsId(line, "all") || this.isSuppressedWithComment(line, issue.getCategory());
        }

        private final boolean isSuppressedWithComment(String line, Category category) {
            return this.lineContainsId(line, category.getName()) || this.lineContainsId(line, category.getFullName()) || category.getParent() != null && this.isSuppressedWithComment(line, category.getParent());
        }

        private final boolean lineContainsId(String line, String id) {
            for (int index2 = 0; index2 < line.length(); index2 += id.length()) {
                if ((index2 = StringsKt.indexOf((CharSequence)line, (String)id, (int)index2, (boolean)true)) == -1) {
                    return false;
                }
                if (!this.isWord(line, id, index2)) continue;
                return true;
            }
            return false;
        }

        private final boolean isWord(String line, String word, int index2) {
            int end2 = index2 + word.length();
            if (end2 < line.length() && !this.isWordDelimiter(line.charAt(end2))) {
                return false;
            }
            if (index2 > 0 && !this.isWordDelimiter(line.charAt(index2 - 1))) {
                int prefixStart = index2 - 11;
                return index2 >= 11 && StringsKt.regionMatches$default((String)line, (int)prefixStart, (String)"AndroidLint", (int)0, (int)11, (boolean)false, (int)16, null) && (prefixStart == 0 || this.isWordDelimiter(line.charAt(prefixStart - 1)));
            }
            return true;
        }

        private final boolean isWordDelimiter(char c) {
            return !Character.isJavaIdentifierPart(c);
        }

        private final int findPrefixOnPreviousLine(CharSequence contents, int lineStart, String prefix) {
            char first = prefix.charAt(0);
            boolean seenNonWhitespace = false;
            for (int offset = lineStart - 2; offset >= 0; --offset) {
                char c = contents.charAt(offset);
                if (seenNonWhitespace && c == '\n') {
                    return -1;
                }
                if (!seenNonWhitespace && !Character.isWhitespace(c)) {
                    seenNonWhitespace = true;
                }
                if (c != first || !CharSequences.regionMatches((CharSequence)contents, (int)offset, (CharSequence)prefix, (int)0, (int)prefix.length())) continue;
                return offset;
            }
            return -1;
        }

        @TestOnly
        public final void clearDetectorWarnings() {
            block0: {
                Set set2 = detectorsWarned;
                if (set2 == null) break block0;
                set2.clear();
            }
        }

        /*
         * WARNING - void declaration
         */
        public final boolean checkForbidden(@NotNull String methodName, @NotNull File file, @Nullable LintDriver driver, @NotNull String extraMessage) {
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)extraMessage, (String)"extraMessage");
            LintDriver lintDriver = driver;
            if (lintDriver == null && (lintDriver = (LintDriver)CollectionsKt.firstOrNull(LintDriver.Companion.getCurrentDrivers())) == null) {
                return true;
            }
            LintDriver currentDriver = lintDriver;
            if (currentDriver.getMode() == LintDriver.DriverMode.ANALYSIS_ONLY) {
                Set warnings;
                Iterable it;
                Pair<String, List<Issue>> pair2 = this.findCallingDetector(currentDriver);
                if (pair2 == null) {
                    return false;
                }
                Pair<String, List<Issue>> pair3 = pair2;
                String detector = (String)pair3.component1();
                List issues = (List)pair3.component2();
                Set set2 = detectorsWarned;
                if (set2 == null) {
                    HashSet hashSet;
                    it = hashSet = new HashSet();
                    boolean bl = false;
                    detectorsWarned = it;
                    set2 = hashSet;
                }
                if ((warnings = set2).add(detector)) {
                    String string2;
                    void $this$sortedBy$iv;
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv;
                    StringBuilder stack = new StringBuilder();
                    LintDriver.Companion.appendStackTraceSummary(new RuntimeException(), stack, 1, 20);
                    it = issues;
                    boolean $i$f$mapNotNull = false;
                    LintClient.Companion companion = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        Issue it2 = (Issue)element$iv$iv;
                        boolean bl2 = false;
                        Vendor vendor = it2.getVendor();
                        if (vendor == null) {
                            IssueRegistry issueRegistry = it2.getRegistry();
                            vendor = issueRegistry != null ? issueRegistry.getVendor() : null;
                        }
                        if (vendor == null) continue;
                        Vendor it$iv$iv = vendor;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                    boolean $i$f$sortedBy22 = false;
                    List vendors = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            Vendor it = (Vendor)a;
                            boolean bl = false;
                            Comparable comparable = (Comparable)((Object)it.getIdentifier());
                            it = (Vendor)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getIdentifier())));
                        }
                    });
                    if (!((Collection)issues).isEmpty()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("\nIssue Vendors:\n");
                        for (Vendor vendor : vendors) {
                            String it3;
                            if (vendor.getVendorName() != null) {
                                boolean bl = false;
                                sb.append("Vendor: " + it3 + "\n");
                            }
                            if (vendor.getIdentifier() != null) {
                                boolean bl = false;
                                sb.append("Identifier: " + it3 + "\n");
                            }
                            if (vendor.getContact() != null) {
                                boolean bl = false;
                                sb.append("Contact: " + it3 + "\n");
                            }
                            if (vendor.getFeedbackUrl() != null) {
                                boolean bl = false;
                                sb.append("Feedback: " + it3 + "\n");
                            }
                            sb.append("\n");
                        }
                        string2 = sb.toString();
                    } else {
                        string2 = "";
                    }
                    String $i$f$sortedBy22 = string2;
                    Intrinsics.checkNotNull((Object)$i$f$sortedBy22);
                    String vendorString = $i$f$sortedBy22;
                    Object object = driver;
                    if (object == null || (object = ((LintDriver)object).getClient()) == null || (object = ((LintClient)object).getClientDisplayName()) == null) {
                        object = LintClient.Companion.getClientName();
                    }
                    String message = StringsKt.trimIndent((String)("\n            The lint detector\n                `" + detector + "`\n            called `" + methodName + "` during module analysis.\n\n            This does not work correctly when running in " + (String)object + ".\n            " + (String)(!StringsKt.isBlank((CharSequence)extraMessage) ? extraMessage + "\n" : "") + "\n            In particular, there may be false positives or false negatives because\n            the lint check may be using the minSdkVersion or manifest information\n            from the library instead of any consuming app module.\n\n            Contact the vendor of the lint issue to get it fixed/updated (if\n            known, listed below), and in the meantime you can try to work around\n            this by disabling the following issues:\n\n            " + CollectionsKt.joinToString$default((Iterable)issues, (CharSequence)",", null, null, (int)0, null, Companion::checkForbidden$lambda$8, (int)30, null) + "\n            ")) + "\n" + vendorString + "Call stack: " + stack;
                    companion = LintClient.Companion;
                    LintClient lintClient = currentDriver.getClient();
                    Issue issue = IssueRegistry.LINT_ERROR;
                    Location location = Location.Companion.create(file);
                    LintClient.Companion.report$default(companion, lintClient, issue, message, null, null, null, null, null, null, null, null, currentDriver, location, 2040, null);
                }
                return true;
            }
            return false;
        }

        public static /* synthetic */ boolean checkForbidden$default(Companion companion, String string2, File file, LintDriver lintDriver, String string3, int n, Object object) {
            if ((n & 8) != 0) {
                string3 = "";
            }
            return companion.checkForbidden(string2, file, lintDriver, string3);
        }

        @Nullable
        public final Pair<String, List<Issue>> findCallingDetector(@NotNull LintDriver driver) {
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            Throwable throwable = new Throwable().fillInStackTrace();
            Object[] frames = throwable.getStackTrace();
            Intrinsics.checkNotNull((Object)throwable);
            Pair<String, List<Issue>> result2 = LintDriver.Companion.getAssociatedDetector(throwable, driver);
            if (result2 != null) {
                return result2;
            }
            Iterator iterator = ArrayIteratorKt.iterator((Object[])frames);
            while (iterator.hasNext()) {
                StackTraceElement element = (StackTraceElement)iterator.next();
                String detectorClass = element.getClassName();
                Intrinsics.checkNotNull((Object)detectorClass);
                if (StringsKt.startsWith$default((String)detectorClass, (String)"com.android.tools.lint.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)detectorClass, (String)"com.android.tools.lint.checks.", (boolean)false, (int)2, null)) continue;
                return new Pair((Object)detectorClass, LintDriver.Companion.getDetectorIssues(detectorClass, driver));
            }
            return new Pair((Object)"unknown detector", (Object)CollectionsKt.emptyList());
        }

        private static final CharSequence checkForbidden$lambda$8(Issue it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return "\"" + it + "\"";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LocationType.values().length];
            try {
                nArray[LocationType.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LocationType.ALL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LocationType.NAME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LocationType.CALL_WITH_ARGUMENTS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LocationType.CALL_WITH_RECEIVER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LocationType.VALUE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

